#ifndef _INDEX_HPP_
#define _INDEX_HPP_

#include "globals.hpp"
#include "PTree.hpp"
#include "Container_simple.hpp"
#include "PSpeicher.hpp"
//#include "Logger.hpp"
#include "time.h"
#include "math.h"
#include <iomanip>


/**
 * Index vereinigt PTree mit Container_simple.
 * Stellt in etwa das zur Verfügung, was in PTIndex.java definiert ist (ohne ODCII).
 *
 */
class Index {

	friend bool processFromFile(string& indexname, string filename, char operation);
	PTree * tree;
	Container_simple * container;

	string name_index;
	string name_schema;
	int modus; // schreiben (neu) oder lesen /schreiben

public:
	/**
	 * Initialisiert den Index
	 */
	Index(string idx_name, string schema_name, char p_modus);
	~Index();

	/*
	 * interne Zugriffe
	 */
	PTree * getTree(){return tree;}
	Container_simple * getContainer(){return container;}

	unsigned int getMax();
	unsigned int getMin();

	void setMinMax();
	/**
	 * Veranlaßt den Container, seine Daten auf Platte zu schreiben
	 */
	void saveContainer();

	/**
	 * löscht alle Files eine Index'
	 */
	bool indexDrop();
	/**
	 * baut einen Index neu auf<br/>
	 * - aus einem Textfile
	 */
	bool insertFromFile(string filename, bool sequential = false);
	/**
	 * baut einen Index neu auf<br/>
	 * - aus einer Datenbanktabelle
	 */
	bool insertFromDatabase(string username, string password, string host, string schema, string table, string attribute);
	/**
	 * Einfügeoperation: p_string ist das Attribut, TID die TupleID (oder auch RID für RowID)
	 */
	bool insert(string p_string, string TID);
	/**
	 * für sequenzielles Einfügen, d.h. ohne Nutzung der vorherigen Key-Bestimmung
	 */
	bool insertSeq(string p_string, string TID);

	/**
	 * Löscht einen String, aber nur mit zugehöriger TID (bzw. rid oder rowid)
	 *
	 * 1. Suchen
	 * 2. TID finden und genau das Paar löschen (aus Container)
	 * 3. wenns nur ein Paar gab, dann den String aus dem Baum löschen
	 *
	 */
	bool deleteString(string p_string, string p_TID);


	/**
	 * Führt im wesentlichen IOOrder(T,T) aus
	 */
	bool indexOptimize();

	/**
	 * Führt select o.ä. mit den Daten eines Files aus --> pro Zeile eine Anfrage
	 *
	 * operation:
	 *  e - select_eq
	 *  l/L - select_lt /select_elt
	 *  g/G - select_gt /select_egt
	 *  X - select_LIKE
	 */

	// wieder ausgelagert als externe (private)Funktion
	//bool processFromFile(string filename, char operation);

	// hier dann die unterschiedlichen Prädikate
	// gt, egt, lt, elt, eq

	// == // wenn CppPtEq(,)=1
	/**
	 * ==
	 */
	StringVector * select_eq(string& p_string);
	/**
	 * <
	 */
	StringVector * select_lt(string& p_string);
	/**
	 * >
	 */
	StringVector * select_gt(string& p_string);
	/**
	 * <=
	 */
	StringVector * select_elt(string& p_string);
	/**
	 * >=
	 */
	StringVector * select_egt(string& p_string);

	/**
	 * x between y
	 */
	StringVector * select_between(string p_string_left, string p_string_right);

	/**
	 * prefix-suche
	 */
	StringVector * select_prefix(string& p_string);

	// '_AACGT___%'
	// Wildcard-Selektoren...
	/**
	 * Wildcard-Suche
	 */
	StringVector * select_LIKE(string& p_string);

	/*Insert Astrid*/
	/* k-Mismatch*/
	StringVector *select_kMismatch(string& p_string, int k);

	/*eLA*/
	StringVector *select_eLA(string& p_string, int k);
	/*Insert Ende*/
};


/**
 * Wrapper-Funktionen für die C-Aufrufkonvention des ODCI bereitstellen.
 * extern "C" für C-Namenskonvention
 *
 */
extern "C" {

	/**
	 * Interface für IndexCreate-Funktion.
	 * Host/User/Pass sollten über die PARAMETER-Option in CREATE INDEX übergeben werden
	 */
	int itf_ODCIIndexCreate(
		char * indexName,
		char * schemaName,
		char * tableName,
		char * attributeName,
		char * hostname,
		char * username,
		char * password);

	/**
	 * ODCI Index Drop
	 */
	int itf_ODCIIndexDrop(
		char * indexName,
		char * schemaName);

	/**
	 * neuen String einfügen
	 */
	int itf_ODCIIndexInsert(
		char * indexName,
		char * schemaName,
		char * rid,
		char * newVal);

	/**
	 * String löschen
	 */
	int itf_ODCIIndexDelete(
		char * indexName,
		char * schemaName,
		char * rid,
		char * oldVal);

	/**
	 * String ersetzen
	 */
	int itf_ODCIIndexUpdate(
		char * indexName,
		char * schemaName,
		char * rid,
		char * oldVal,
		char * newVal);

	/**
	 * Startet einen Index-Scan. Je nach OperationType (siehe unten) eine der Select-Funktionen.
	 */
	int itf_ODCIIndexStart(
		char * indexName,
		char * schemaName,
		char * operationType,
		char * cmpVal,
		char ** rowids); // einfaches Feld ->


}


#endif /*_INDEX_HPP_*/
