
#include "Index.hpp"
#include "Watch.h"
#include <stdio.h>
#include <list>

#include <occi.h>

using namespace oracle::occi;
using namespace std;

#define cerr cout

// special_debug jetzt in globals.cpp definiert!
int treshold=0;
/*
 * Index-Modi:
 * - N: new or create (überschreibt ggf. vorhandene Files
 * - W: read & write (keine Unterscheidung nach nur-Lesen)
 * - R: nur read (nicht eingesetzt)
 * - D: DROP
 * (//- delete wird nur über eine Member-Funktion bereitgestellt)
 *
 */
Index::Index(string idx_name, string schema_name, char p_modus): name_index(idx_name), name_schema(schema_name), modus(p_modus) {
	tree = new PTree(name_index, name_schema, modus);
	//container = new Container_simple(string(name_index+"_"+name_schema), modus);
	container = new Container_simple(string(name_index), string(name_schema), modus);
//	logger = new Logger(string(name_index),string(name_schema), string(""));
}

Index::~Index(){
	//cerr << "Index::~Index()" << endl;
	delete tree;
	delete container;
//	delete logger;
}


void Index::saveContainer(){
	container->save();
}

void Index::setMinMax(){
	tree->setStringLengths(tree->getRootNode(),0);
}

#define MAX_EST_SIZE 5000
bool Index::insertFromFile(string filename, bool sequential){
	fstream m_stream(filename.c_str());
	if(!m_stream){
		cerr << "file " << filename << " not found!" << endl;
		return false;
	}

	char buffer_line[MAX_EST_SIZE+2];
	char buffer_linenum[20];
	int line_counter = 0;

	clock_t timeStart = clock();
	clock_t timeOld = timeStart;

	int curNodesCreateCountOnDisk = 0;

	int curNodeCreate = 0;
	int curNodeDelete = 0;
	//int curLineCount = 0;
	int curStrLength = 0;

	clock_t timeNow;
	clock_t timediff;
	clock_t timediff_start;
	double seconds_double;
	double seconds_start;

	//cerr << "timeStart == " << timeStart << endl;
	int num_mod = 10000;
	//special_debug = true;

	while(!m_stream.eof()){
		m_stream.getline(buffer_line, MAX_EST_SIZE);
		++line_counter;
		sprintf(buffer_linenum, "%*d", CONTAINER_TID_SIZE, line_counter);
		curStrLength += strlen(buffer_line);

		timeNow = clock();

		//if(line_counter == 41650){num_mod = 1;special_debug = true;}

		//if( (double(timeNow - timeOld)/(double)CLOCKS_PER_SEC) >= 1){
		if(line_counter % num_mod == 0){
			//timeNow = clock();
			timediff = timeNow - timeOld;
			timediff_start = timeNow - timeStart;
			seconds_double = (double)timediff / (double)CLOCKS_PER_SEC;
			seconds_start = (double)timediff_start / (double)CLOCKS_PER_SEC;
			timeOld = timeNow;

//			// Logfile output
//			(*logger) << timeNow << " ; "

			cout << line_counter
				<< ";\"time:\";" << seconds_double
				<< ";\"ins/sec:\";" << floor(((double)num_mod / (double)(seconds_double)))
				<< ";\"avg:\";" << (int)floor(((double)line_counter / (double)(seconds_start)))
				<< ";\"avg_len:\";" << (curStrLength / num_mod)
				<< ";\"mem_nodes:\";" << (CharNode::internalNodeCountCreate - curNodeCreate)
				<< ";\"disk_nodes:\";" << (CharNode::internalNodeCountCreateOnDisk - curNodesCreateCountOnDisk)
				<< endl;

			curNodeCreate = CharNode::internalNodeCountCreate;
			curNodeDelete = CharNode::internalNodeCountDelete;
			curNodesCreateCountOnDisk = CharNode::internalNodeCountCreateOnDisk;
			//curLineCount = line_counter;
			curStrLength = 0;

		}

		if(m_stream.fail()) break;
		string string_buffer_line(buffer_line);
		if(string_buffer_line.length() == 0) break;
		if(sequential == true){
			if(!insertSeq(string_buffer_line, string(buffer_linenum))){
				cerr << "insert fehlgeschlagen...." << endl;
				saveContainer();
				return false;
			}
		}else{
			if(!insert(string_buffer_line, string(buffer_linenum))){
				cerr << "insert fehlgeschlagen...." << endl;
				saveContainer();
				return false;
			}
		}

	}// while
	timediff = timeNow - timeOld;
	timediff_start = timeNow - timeStart;
	seconds_double = (double)timediff / (double)CLOCKS_PER_SEC;
	seconds_start = (double)timediff_start / (double)CLOCKS_PER_SEC;
	timeOld = timeNow;
	--line_counter;
//	(*logger) << timeNow << " ; "
	if(line_counter % num_mod != 0){
		cout << line_counter
			<< ";\"time:\";" << seconds_double
			<< ";\"ins/sec:\";" << floor(((double)num_mod / (double)(seconds_double)))
			<< ";\"avg:\";" << (int)floor(((double)line_counter / (double)(seconds_start)))
			<< ";\"avg_len:\";" << (curStrLength / num_mod)
			<< ";\"mem_nodes:\";" << (CharNode::internalNodeCountCreate - curNodeCreate)
			<< ";\"disk_nodes:\";" << (CharNode::internalNodeCountCreateOnDisk - curNodesCreateCountOnDisk)
			<< endl;
	}
	saveContainer();
	return true;
}


/*
 *
 * Indexiert die Attribute einer Oracle-Datenbank.
 *
 */
bool Index::insertFromDatabase(
	string username,
	string password,
	string host,
	string schema,
	string table,
	string attribute){
	try{
		Watch watch;
		Logger * logger = new Logger(table, schema, string("insDB"));

		Environment * env = Environment::createEnvironment(Environment::DEFAULT);

		(*logger) << "connecting DB with user " << username << ", pass == " << password << ", host == " << host << "\n";

		Connection * conn = env->createConnection(username,password,host);

		(*logger) << "SQL: alter session set nls_sort=BINARY\n";
		Statement * stmt_alter_session = conn->createStatement("alter session set nls_sort=BINARY");
		int res_alter_session = stmt_alter_session->execute();
		conn->terminateStatement(stmt_alter_session);

		string str_statement(
				"SELECT " + attribute + ", rowid " +
				"FROM \""+schema+"\".\"" + table + "\" a " +
				"ORDER BY " + attribute );

		(*logger) << "SQL == " + str_statement << "\n";

		Statement * stmt = conn->createStatement(str_statement);
		ResultSet * res = stmt->executeQuery();
		(*logger) << "executeQuery()..." << "\n";

		//vector<MetaData> metaDataVector = res->getColumnListMetaData();
		//cerr << metaDataVector.size() << endl;

		try{

			clock_t timeStart = clock();
			clock_t timeOld = timeStart;

			int curSuffixReadCount = 0;
			int curSuffixWriteCount = 0;
			int curNodesCreateCountOnDisk = 0;
			double curSuffixReadDistance = 0;
			double curSuffixWriteDistance = 0;

			int curNodeCreate = 0;
			int curNodeDelete = 0;
			int curLineCount = 0;
			int curStrLength = 0;

			clock_t timeNow;
			clock_t timediff;
			clock_t timediff_start;
			double seconds_double;
			double seconds_start;

			//cerr << "timeStart == " << timeStart << endl;
			int num_mod = 10000;
			//special_debug = true;

			int line_counter = 0;

			//string strEST;
			//string strROWID;

			while( res->next() == oracle::occi::ResultSet::DATA_AVAILABLE ){
				const string& strEST = (res->getString(1));
				const string& strROWID = (res->getString(2));
				curStrLength += strEST.length();
				if(!insertSeq(strEST, strROWID)){
				//if(!insert(strEST, strROWID)){
//					(*logger) << "insert fehlgeschlagen.... at # " << line_counter << "\n";
					saveContainer();
					return false;
				}
				++line_counter;
				timeNow = clock();
//				if( (double(timeNow - timeOld)/(double)CLOCKS_PER_SEC) >= 1){
				if(line_counter % num_mod == 0){
					//timeNow = clock();
					timediff = timeNow - timeOld;
					timediff_start = timeNow - timeStart;
					seconds_double = (double)timediff / (double)CLOCKS_PER_SEC;
					seconds_start = (double)timediff_start / (double)CLOCKS_PER_SEC;
					timeOld = timeNow;

					(*logger) << line_counter
						<< ";\"time:\";" << seconds_double
						<< ";\"ins/sec:\";" << floor(((double)num_mod / (double)(seconds_double)))
						<< ";\"avg:\";" << (int)floor(((double)line_counter / (double)(seconds_start)))
						<< ";\"avg_len:\";" << (curStrLength / num_mod)
						<< ";\"mem_nodes:\";" << (CharNode::internalNodeCountCreate - curNodeCreate)
						<< ";\"disk_nodes:\";" << (CharNode::internalNodeCountCreateOnDisk - curNodesCreateCountOnDisk)
						<< "\n"; //endl;


					curNodeCreate = CharNode::internalNodeCountCreate;
					curNodeDelete = CharNode::internalNodeCountDelete;
					curNodesCreateCountOnDisk = CharNode::internalNodeCountCreateOnDisk;
					curLineCount = line_counter;
				}
			}
			timediff = timeNow - timeOld;
			timediff_start = timeNow - timeStart;
			seconds_double = (double)timediff / (double)CLOCKS_PER_SEC;
			seconds_start = (double)timediff_start / (double)CLOCKS_PER_SEC;
			timeOld = timeNow;
			--line_counter;
			(*logger) << line_counter << " ; "
				<< ";\"time:\";" << seconds_double
				<< ";\"ins/sec:\";" << floor(((double)num_mod / (double)(seconds_double)))
				<< ";\"avg:\";" << (int)floor(((double)line_counter / (double)(seconds_start)))
				<< ";\"avg_len:\";" << (curStrLength / num_mod)
				<< ";\"mem_nodes:\";" << (CharNode::internalNodeCountCreate - curNodeCreate)
				<< ";\"disk_nodes:\";" << (CharNode::internalNodeCountCreateOnDisk - curNodesCreateCountOnDisk)
				<< "\n"; //endl;

		}catch(SQLException sqlex){
//			(*logger) << sqlex.getMessage() << "\n";
		}

		stmt->closeResultSet(res);
		conn->terminateStatement(stmt);
		env->terminateConnection(conn);
		Environment::terminateEnvironment(env);
		(*logger) << "XXOINDEXODCI"
				<< ";" << table
				<< ";time;" << (watch.stamp()/(double)1000)
				<< "\n";
		delete logger;
	}catch(SQLException sqlex){
//		(*logger) << "Ein fehler ist aufgetreten..." << "\n";
//		(*logger) << sqlex.getMessage() << "\n";
		cerr << sqlex.getMessage() << endl;
	}catch(exception ex){
//		(*logger) << "Eine exception ist aufgetreten (keine SQLException!)" << "\n";
//		(*logger) << ex.what() << "\n";
	}catch(...){
//		(*logger) << "Ein fehler ist aufgetreten, der keine exception ist!" << "\n";
	}
	saveContainer();
	return true;
}

/*
 * in den Index einfügen
 */
bool Index::insert(string p_string, string TID){
	//cerr << "Index::insert(" << p_string << ", " << TID << ")..." << endl;
	KEY_TYPE container_key = PTREE_NULLKEY;
	try{
		container_key = tree->insertStringOrder(p_string);
	}catch(KollisionException /*k_ex*/){
		// Baum und Container mit neuen Keys versorgen
		cerr << "KollisionException empfangen" /*<< k_ex.state*/ << endl;

		clock_t timeStart = clock();
		AlterKeysMap * map_alterkeys = tree->updateAllKeys(container->getNumberOfDistinctKeys());

		clock_t timeNow = clock();
		double seconds = (double)(timeNow - timeStart)/(double)CLOCKS_PER_SEC;
		timeStart = timeNow;
		cerr << "tree->updateAllKeys() beendet (" << seconds << " sec.)" << endl;

		container->updateKeys(*map_alterkeys);
		delete map_alterkeys; // muß hier gelöscht werden; wird in tree->updateAllKeys() auch per new erstellt

		timeNow = clock();
		seconds = (double)(timeNow - timeStart)/(double)CLOCKS_PER_SEC;
		cerr << "container->updateKeys(*map_alterkeys) beendet (" << seconds << " sec.)" << endl;
		// fertig, kann jetzt neuen Einfügeversuch starten
		try{
			container_key = tree->insertStringOrder(p_string);
		}catch(KollisionException /*ex*/){
			cerr << "Doppelte Kollision --> einfügen funktioniert hier nicht mehr" << endl;
			exit(-1);
		}
	}
	//cerr << "container_key == " << container_key << endl;
	container->insert(container_key,TID); // muß darauf vertrauen, daß das nicht schief geht

	return true;
}

/*
 * Sequetielles Einfügen nach einem SELECT ... ORDER BY
 */
bool Index::insertSeq(string p_string, string TID){
	try{
		KEY_TYPE container_key = tree->insertStringSeq(p_string);
		container->insert(container_key, TID);
	}catch(...){
		cerr << "Fehler ist aufgetreten." << endl;
		return false;
	}
	return true;
}


/*
 * Löschen eines Tupels aus dem Index
 * (erst wenn die TID nicht mehr im container ist wird der String auch im Baum gelöscht)
 */
bool Index::deleteString(string p_string, string TID){
	KEY_TYPE container_key = tree->select_eq(p_string);
	// wenn nicht gefunden, dann zurück
	if(container_key == PTREE_NULLKEY) return true;
	container->erase(container_key, TID);
	if(!container->find(container_key)){
		tree->deleteString(p_string);
	}
	return true;
}


/*
 * Startet das neusortieren des Baumes
 *
 */
bool Index::indexOptimize(){
	cerr << "Index::indexOptimize() start" << endl;

	this->tree = PTree::IOOrder(this->getTree());

	cerr << "Index::indexOptimize() end" << endl;
	return true;
}



// ==
StringVector * Index::select_eq(string& p_string){
	//cerr << "Index::select_eqt()..." << endl;
	KEY_TYPE container_key = tree->select_eq(p_string);
	//cerr << "container_key == " << container_key << endl;
	StringVector * s_vector = new StringVector;
	if(container_key != PTREE_NULLKEY){
		//container->get((*s_vector), container_key);
	}
	return s_vector;
}
// <
StringVector * Index::select_lt(string& p_string){
	KEY_TYPE container_key = tree->select_lt(p_string);
	StringVector * s_vector = new StringVector;
	if(container_key != PTREE_NULLKEY){
		//container->getRange((*s_vector), PTREE_MIN, container_key);
	}
	return s_vector;
}
// >
StringVector * Index::select_gt(string& p_string){
	KEY_TYPE container_key = tree->select_gt(p_string);
	StringVector * s_vector = new StringVector;
	if(container_key != PTREE_NULLKEY){
		//container->getRange((*s_vector), container_key, PTREE_MAX);
	}
	return s_vector;
}
// <=
StringVector * Index::select_elt(string& p_string){
	KEY_TYPE container_key = tree->select_elt(p_string);
	StringVector * s_vector = new StringVector;
	if(container_key != PTREE_NULLKEY){
		//container->getRange((*s_vector), PTREE_MIN, container_key);
	}
	return s_vector;
}
// >=
StringVector * Index::select_egt(string& p_string){
	KEY_TYPE container_key = tree->select_egt(p_string);
	StringVector * s_vector = new StringVector;
	if(container_key != PTREE_NULLKEY){
		//container->getRange((*s_vector), container_key, PTREE_MAX);
	}
	return s_vector;
}

// between X and Y
StringVector * Index::select_between(string p_string_left, string p_string_right){
	if(p_string_left.compare(p_string_right) > 0){
		swap(p_string_left, p_string_right);
	}
	KEY_TYPE key_untergrenze = tree->select_egt(p_string_left);
	KEY_TYPE key_obergrenze  = tree->select_elt(p_string_right);
	StringVector * s_vector = new StringVector;
	if(key_untergrenze > key_obergrenze){
		return s_vector; // leere Menge zurückgeben
	}
	//container->getRange((*s_vector), key_untergrenze, key_obergrenze);
	return s_vector;
}

// LIKE 'p_string%'
StringVector * Index::select_prefix(string& p_string){
	StringVector * s_vector = new StringVector;
	KeyPair keypair = tree->select_prefix(p_string);
	if(keypair.first == PTREE_NULLKEY || keypair.second == PTREE_NULLKEY){
		return s_vector; // leeren vector zurückgeben
	}
	if(keypair.first != PTREE_NULLKEY && keypair.second != PTREE_NULLKEY){
		//container->getRange(*s_vector, keypair.first, keypair.second);
	}
	return s_vector;

}

// LIKE '__AAACCTG_%'
StringVector * Index::select_LIKE(string& p_string){
	StringVector * s_vector = new StringVector;
	// hier kommen jetzt viele Ranges zurück
	KeyPairVector * kpv = tree->select_LIKE(p_string);
	//cerr << "Index::select_LIKE(...) tree->select_LIKE() beendet" << endl;
	// ... na das soll mal der Container erledigen

	// hier kann auch mal ganz locker nichts ankommen...
	if(kpv != NULL){
		if(kpv->size() > 0){
			//container->getRange(*s_vector, *kpv);
		}
		delete kpv;
	}
	return s_vector;
}

/*
 * Interface für IndexCreate-Funktion.
 * Host/User/Pass sollten über die PARAMETER-Option in CREATE INDEX übergeben werden
 */
int itf_ODCIIndexCreate(
	char * indexName,
	char * schemaName,
	char * tableName,
	char * attributeName,
	char * hostname,
	char * username,
	char * password)
{
	FILE * f = fopen("odciindexcreate2.txt","w");
	if(f){
		fprintf(f,"%s\n",indexName);
		fprintf(f,"%s\n",schemaName);
		fprintf(f,"%s\n",tableName);
		fprintf(f,"%s\n",attributeName);
		fprintf(f,"%s\n",hostname);
		fprintf(f,"%s\n",username);
		fprintf(f,"%s\n",password);
		fclose(f);
	}


	// odci einschalten
	global_var_use_odci = true;
	//try{
		// neues Index-Onjekt bauen
		Index index(string(indexName), string(schemaName), 'N');
		// Index aus der Datenbank laden
		index.insertFromDatabase(string(username), string(password), string(hostname), string(schemaName), string(tableName), string(attributeName));
		// index komprimieren
		// todo: alle Exceptions durchlassen
		//index.logger->flush();
		//index.logger->close();
		index.indexOptimize();
	//}catch(...){
	//	_fcloseall();
	//}
	return 0;
}

/**
 * Das sollte zur Identifikation ausreichen.
 */
int itf_ODCIIndexDrop(
	char * indexName,
	char * schemaName)
{
	// odci einschalten
	global_var_use_odci = true;
	try{
		Index index(string(indexName), string(schemaName), 'D');
	}catch(...){
//		_fcloseall(); TODO wieder einschalten
	}
	return 0;
}

/**
 * neuen String einfügen
 */
int itf_ODCIIndexInsert(
	char * indexName,
	char * schemaName,
	char * rid,
	char * newVal)
{
	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Onjekt bauen
	Index index(string(indexName), string(schemaName), 'W');
	// String und rowid einfügen
	index.insert(string(newVal),string(rid));
	return 0;
}


/**
 * String löschen
 */
int itf_ODCIIndexDelete(
	char * indexName,
	char * schemaName,
	char * rid,
	char * oldVal)
{
	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Onjekt bauen
	Index index(string(indexName), string(schemaName), 'W');
	// String und rowid einfügen
	index.deleteString(string(oldVal),string(rid));
	return 0;
}


/**
 * String ersetzen
 */
int itf_ODCIIndexUpdate(
	char * indexName,
	char * schemaName,
	char * rid,
	char * oldVal,
	char * newVal)
{
	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Onjekt bauen
	Index index(string(indexName), string(schemaName), 'W');
	// String und rowid einfügen
	index.deleteString(string(oldVal),string(rid));
	// String und rowid einfügen
	index.insert(string(newVal),string(rid));
	return 0;
}


/**
 * Interface
 * - indexName
 * - indexSchema
 * - int Operation
 * - char * cmpVal
 * - char ** returned_rowids (zeiger auf ein RowID-Feld)
 *
 * In den Scan-Context:
 * - Pointer auf Feld
 * - int Gesamtgröße
 * - Pointer auf aktuelle Position
 *
 */
int itf_ODCIIndexStart(
		char * indexName,
		char * schemaName,
		char * operationType,
		char * cmpVal,
		//char * cmpVal2,
		char ** rowids){

	if(!operationType) return -10101;
	if(!cmpVal) return -10102;
	if(!rowids) return -10103;


	FILE * f = fopen("D:/oracle/express_edition/oradata/idx_data/log_itf_ODCIIndexStart.log","w");
	if(f){
		fprintf(f, "indexName == %s\n" , indexName);
		fprintf(f, "schemaName == %s\n" , schemaName);
		fprintf(f, "operationType == %s\n" , operationType);
		fprintf(f, "cmpVal == %s\n" , cmpVal);
		//fclose(f);
	}


	// odci einschalten
	global_var_use_odci = true;
	// neues Index-Onjekt bauen
	Index i(string(indexName), string(schemaName),'W');

	// Rückgabewerte der Selektoren
	StringVector * sv = NULL;

	if(strcmp(operationType, "CppPTeq")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_eq(s_cmpVal);
		//sv = i.select_eq(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_eq(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CPPPTEQ")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_eq(s_cmpVal);
		//sv = i.select_eq(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_eq(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CppPTlt")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_lt(s_cmpVal);
		//sv = i.select_lt(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_lt(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CPPPTLT")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_lt(s_cmpVal);
		//sv = i.select_lt(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_lt(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CppPTgt")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_gt(s_cmpVal);
		//sv = i.select_gt(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_gt(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CPPPTGT")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_gt(s_cmpVal);
		//sv = i.select_gt(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_gt(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CppPTsw")==0){ // startsWith
		string s_cmpVal((string)cmpVal);
		sv = i.select_prefix(s_cmpVal);
		//sv = i.select_prefix(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_sw(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CPPPTSW")==0){ // startsWith
		string s_cmpVal((string)cmpVal);
		sv = i.select_prefix(s_cmpVal);
		//sv = i.select_prefix(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_sw(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CppPTlike")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_LIKE(s_cmpVal);
		//sv = i.select_LIKE(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_LIKE(string(cmpVal));\n");
	}else
	if(strcmp(operationType, "CPPPTLIKE")==0){
		string s_cmpVal((string)cmpVal);
		sv = i.select_LIKE(s_cmpVal);
		//sv = i.select_LIKE(string(cmpVal));
		if(f)fprintf(f,"sv = i.select_LIKE(string(cmpVal));\n");
//	}else
//	if(strcmp(operationType, "CppPTbw")){
//		// dafür ist die indexstart-routine mit den zwei cmpvals ...
//		//i.select_between()
//		return -10108;
	}else{
		//Default
		// noch eine exception werfen...
		return -10109;
	}

	// sv? -> toChar* (field) : NULL;

	if(sv != NULL && sv->size() > 0){
		int sizeSV = sv->size();
		int sizeField = (sizeSV + 1)*CONTAINER_TID_SIZE; // für die NULL am Ende
		char * rid = (char*)malloc(sizeField);
		char * cPos = rid;
		char * emptyEntry = "emptyEntryNULLNULL";

		if(f)fprintf(f,"sizeSV == %d\n", sizeSV);
		if(f)fprintf(f,"sizeField == %d\n", sizeField);

		for(StringVector::iterator it = sv->begin(); it != sv->end(); ++it){
			memcpy(cPos, it->c_str(), CONTAINER_TID_SIZE);
			cPos += CONTAINER_TID_SIZE;
			if(f)fprintf(f,"it->c_str() == %s\n", it->c_str());
			if(f)fprintf(f,"cPos == %d\n", cPos);
		}
		memcpy(cPos, emptyEntry, CONTAINER_TID_SIZE);
		delete sv;
		// Pointer auf das Feld zurückgeben
		*rowids = rid;
		if(f)fclose(f);
		return sizeSV;
	}

	if(f)fclose(f);

	// sv löschen, falls vorhanden (sollte nicht)
	if(sv) delete sv;
	// und beenden (nichts gefunden)
	if(sv->size() == 0){
		return 0;
	}
	return -10104;
}


class interval_histogram {

	int mod_interval;
	vector<double> * histo1; // werte
	vector<int> * histo2; // counter

public:
	interval_histogram(int p_interval): mod_interval(p_interval){
		histo1 = new vector<double>((int)(5000 / mod_interval)+10);
		histo2 = new vector<int>((int)(5000 / mod_interval)+10);

		for(int i=0;i<(int)(5000 / mod_interval);++i){
			(*histo1)[i] = 0;
			(*histo2)[i] = 0;
		}
	}
	void insert(int p_key, double p_value){
		int key = (int)(p_key / mod_interval);
		(*histo1)[key] = (*histo1)[key] + p_value;
		(*histo2)[key] = (*histo2)[key] + 1;

	}
	void output(int p_from, int p_to){
		for(int i= p_from; i < p_to; ++i){
			cout << "key == " << i
				<< ", count == " << ((*histo2)[i])
				<< ", sum == " << ((*histo1)[i])
				<< ", value == " << ((*histo1)[i] / (*histo2)[i])
				<< endl;
		}
	}
};


/**
 * Kann als Testvehikel benutzt werden -> massenhafte selects etc.
 *
 *
 * >>index.exe OY FdbEST_p1_p4_sorted.txt fdata/dbEST_p3_part.txt Ye
 * kMismatch: index.exe OY F<filename> fdata/<filename> Yk
 * eLA: index.exe OY F<filename> fdata/<filename YK
 */
bool /*Index::*/processFromFile(string& indexname, string filename, char operation){
	//cout << "doing process from file"<<endl;
	fstream m_stream(filename.c_str());
	if(!m_stream){
		cerr << "file " << filename << " not found!" << endl;
		return false;
	}


	char buffer_line[MAX_EST_SIZE+2];
	char buffer_linenum[20];
	int line_counter = 0;

	int curNodeCreate = 0;
	int curNodeDelete = 0;
	//int curLineCount = 0;
	int curStrLength = 0;

	long countGood = 0;
	long countBad = 0;
	//////////////////////
	//	LONGLONG g_Frequency, g_CurentCount, g_LastCount;
	//	double total(0.0);
	//	QueryPerformanceFrequency((LARGE_INTEGER*)&g_Frequency);
	////////////////////////
		// Histogramm in 10er-Schnitten
		interval_histogram histo(100);

//many k-Mismatches
	if(operation=='M') {
//		cerr << "read index" << endl;
		Index index(indexname,string("_"), 'W');
//		cerr << "done"<<endl;
		KEY_TYPE ret = PTREE_NULLKEY;
//		cerr <<"read infile"<<endl;
		list<string> dest;

		string s;
		while (!m_stream.eof()){
			getline(m_stream,s);;
			//ignore empty lines
			if (s.empty()) continue;
			dest.push_back(s);
		}
//		cerr << "done"<<endl;


		int matches(0);
		Watch watch_total;
		int x(0);
		for (list<string>::iterator i = dest.begin();i != dest.end();++i){
			++x;
//				cerr << "comparing "<<x<<endl;
//			StringVector *str = index.select_kMismatch(*i, treshold);
//			matches+= (int)str->size();
		}
		double total_time = (watch_total.stamp()/1000.00);

		cout << "total no of matches for k = " << treshold<<": " << matches << endl;
		cout << "total time: " << total_time << " ms"<<endl;

		return 1;
	}



	else{
		while(!m_stream.eof()){
		m_stream.getline(buffer_line, MAX_EST_SIZE);
		++line_counter;
		sprintf(buffer_linenum, "%*d", CONTAINER_TID_SIZE, line_counter);
		curStrLength = strlen(buffer_line);

		if(m_stream.fail()) break;
		string string_buffer_line(buffer_line);
		if(string_buffer_line.length() == 0) break;

		{


		Watch watch;
//////////////////
//		QueryPerformanceCounter((LARGE_INTEGER*)&g_CurentCount);
//////////////////
		Index index(indexname,string("_"), 'W');

		KEY_TYPE ret = PTREE_NULLKEY;
		switch (operation){
			case 'e': // equal
				ret = index.tree->select_eq(string_buffer_line);
				break;
			case 'l': // less
				ret = index.tree->select_lt(string_buffer_line);
				break;
			case 'L': // less or equal
				ret = index.tree->select_elt(string_buffer_line);
				break;
			case 'g': // greater
				ret = index.tree->select_gt(string_buffer_line);
				break;
			case 'G': // greater or equal
				ret = index.tree->select_egt(string_buffer_line);
				break;
			case 'X':{ // LIKE
				KeyPairVector * kpv = index.tree->select_LIKE(string_buffer_line);
				if(kpv){
					if(kpv->size() > 0){ret = 1;}else{ret = PTREE_NULLKEY;}
				}
				break;}
			default:
				ret = PTREE_NULLKEY;
				break;
		}
		if(ret != PTREE_NULLKEY){
			++countGood;// cerr << "+" << endl;
		}else{
			++countBad;// cerr << "-" << endl;
		}
////////////////
//		QueryPerformanceCounter((LARGE_INTEGER*)&g_LastCount);
//		double dTimeDiff = (((double)(g_LastCount-g_CurentCount))/((double)g_Frequency));
//		total += dTimeDiff;
//		cout << "processing pattern " << string_buffer_line << "\t in " << dTimeDiff << " s" <<endl;
////////////////
		double wtime = (watch.stamp()/(double)1000);
		//cout << "len; " << curStrLength << " time; " << (wtime) << "; ms" << endl;
		// jetzt ins Histogramm einfügen
		histo.insert(curStrLength, wtime);
		}

	}// while
	}
	histo.output(0, (int)(3500/100));
//////////////////////
//	cout << "total running time: " << total << " s" <<endl;
/////////////////////

	streamout(cerr, countGood);
	streamout(cerr, countBad);

	return true;
}

unsigned int Index::getMin(){
	return tree->getRootNode()->minLength;
}
unsigned int Index::getMax(){
	return tree->getRootNode()->maxLength;
}
#ifdef MAKEFLAG_INDEX_EXE

int main(int argc, char **argv){

	Watch watch;
	special_debug = false;

	// F - File insert
	// I - IOOrder
	// S - Statistics

	char operation = 0;
	char operation_type = 0;
	char * fileName="";
	char * fileNameOps = "";
	char * destSubDir = "";
	string filename = "";
	int suffixSize = DEFAULT_INTERNALSAVEDSUFFIXSIZE; // _ONDISK;
	int infixSize = DEFAULT_INTERNALSAVEDINFIXSIZE; //b_ONDISK;
	int nodePageSize = DEFAULT_PAGESIZE_ON_DISK;
	int suffixPageSize = DEFAULT_SUFFIX_PAGESIZE_ON_DISK;
	int nodePagesInBuffer = DEFAULT_NUMBER_OF_NODE_DISKPAGES_IN_MEMORY;
	int suffixPagesInBuffer = DEFAULT_NUMBER_OF_SUFFIX_DISKPAGES_IN_MEMORY;

	for(int i=1; i < argc; ++i){
		cout<<"case is " <<*argv[i]<<endl;
		switch(*argv[i]){

			case 'O': // Operation
				operation = argv[i][1];
				cout << "Operation is "<<argv[i][1]<<endl;
				break;
			case 's': // suffix size
				suffixSize = atoi(&(argv[i][1]));
				break;
			case 'i': // infix size
				infixSize = atoi(&(argv[i][1]));
				break;

			case 'S': // suffix page size
				suffixPageSize = atoi(&(argv[i][1]));
				break;
			case 'P': // node page size
				nodePageSize = atoi(&(argv[i][1]));
				break;

			case 'T': // suffix pages in buffer
				suffixPagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'Q': // node pages in buffer;
				nodePagesInBuffer = atoi(&(argv[i][1]));
				break;
			case 'F': {// FileName
				fileName = &argv[i][1];
				///////////////////
				filename = fileName;
				///////////////////
				cout << "Filename is "<<&argv[i][1]<<endl;
				break;}
			case 'f': // FileName für operationen
				fileNameOps = &argv[i][1];
				break;
			case 'D': // Destination subdir
				destSubDir = &argv[i][1];
				break;
			case 'C':
				if(argv[i][1] == '+')packBitsCompression = true;
				if(argv[i][1] == '-')packBitsCompression = false;
				break;
			case 'c':
				if(argv[i][1] == '+')packBitsCompression_for_Infixes = true;
				if(argv[i][1] == '-')packBitsCompression_for_Infixes = false;
				break;
			case 'Y': // operation in ProcessFromFile
				operation_type = argv[i][1];
				if (operation_type=='M') treshold=atoi(&(argv[i][2]));
				break;
			default:
				break;
		}
	}

	nsCalculateNodeSizeParameters(
		suffixSize,
		infixSize,
		nodePageSize,
		suffixPageSize,
		nodePagesInBuffer,
		suffixPagesInBuffer);

	cerr << "Operation " << operation << endl;
	cerr << "FileName " << fileName << endl;
	cerr << "FileNameOps " << fileNameOps << endl;
	cerr << "DestSubDir " << destSubDir << endl;

	cerr << "nsParameters" << endl;

	streamout(cerr, nsInfixSize);
	streamout(cerr, nsInfixStringLength);
	streamout(cerr, nsIntSuffixSize);
	streamout(cerr, nsIntSuffixStringLength);
	cerr << endl;
	streamout(cerr, nsNodeSizeOnDisk);
	streamout(cerr, nsNodePageSize);
	streamout(cerr, nsSuffixPageSize);
	cerr << endl;
	streamout(cerr, nsNodePagesInBuffer);
	streamout(cerr, nsSuffixPagesInBuffer);
	streamout(cerr, nsNodeBufferSize);
	streamout(cerr, nsSuffixBufferSize);
	cerr << endl;
	streamout(cerr, nsStuffBytesNormalNode);
	streamout(cerr, nsStuffBytesSuffixNode);
	streamout(cerr, nsStuffBytesInfixNode);


	switch(operation){
		case 'O':{ // CREATE FROM FILE, oracle mode (sequential, needs sorted input)
			Index i(filename,string("_"), 'N');
			i.insertFromFile(DATA_SUBDIR + filename, true);
			//Index i(string(fileName),string("_"), 'N');
			//i.insertFromFile(DATA_SUBDIR + string(fileName), true);
			cout << "XXFINDEXCREATE"
				<< ";" << fileName
				<< ";suffixSize;" << suffixSize  // ist die Länge des Suffix-Strings! nicht die Größe im Speicher!
				<< ";infixSize;" << infixSize
				<< ";nodePageSize;" << nodePageSize
				<< ";suffixPageSize;" << suffixPageSize
				<< ";time;" << (watch.stamp()/(double)1000)
				<< ";suffixIntComp;" << CharNode::internalSuffixIntCompCount
				<< ";suffixExtComp;" << CharNode::internalSuffixExtCompCount
				<< endl;
			CharNode::printRuntimeStats(cerr);
			PSpeicher::printStatistics(cerr);
			break;}
//		case 'D':{ // CREATE FROM DATABASE, oracle mode (sequential, needs sorted input)
//			Index i(string(fileName),string("_"), 'N');
//			i.insertFromFile(DATA_SUBDIR + string(fileName), true);
//			CharNode::printRuntimeStats(cerr);
//			PSpeicher::printStatistics(cerr);
//			break;}
		case 'F':{ // CREATE FROM FILE
			Index i(string(fileName),string("_"), 'N');
			i.insertFromFile(DATA_SUBDIR + string(fileName));

			cout << "\"XXFINDEXCREATE\""
				<< ";" << fileName
				<< ";suffixSize;" << suffixSize  // ist die Länge des Suffix-Strings! nicht die Größe im Speicher!
				<< ";infixSize;" << infixSize
				<< ";nodePageSize;" << nodePageSize
				<< ";suffixPageSize;" << suffixPageSize
				<< ";time;" << (watch.stamp()/(double)1000)
				<< ";suffixIntComp;" << CharNode::internalSuffixIntCompCount
				<< ";suffixExtComp;" << CharNode::internalSuffixExtCompCount
				<< endl;
			CharNode::printRuntimeStats(cerr);
			PSpeicher::printStatistics(cerr);
			cerr<<"set string lengths..."<<endl;
			i.setMinMax();
			cerr<<"MIN: "<<i.getMin()<<endl;
			cerr<<"MAX: "<<i.getMax()<<endl;
			break;}
		case 'I':{ // IIORDER
			Index i(string(fileName),string("_"), 'W');
			i.indexOptimize();
			cout << "XXIINDEXIOORDER"
				<< ";" << fileName
				<< ";suffixSize;" << suffixSize  // ist die Länge des Suffix-Strings! nicht die Größe im Speicher!
				<< ";infixSize;" << infixSize
				<< ";nodePageSize;" << nodePageSize
				<< ";suffixPageSize;" << suffixPageSize
				<< ";time;" << (watch.stamp()/(double)1000)
				<< endl;
			CharNode::printRuntimeStats(cerr);
			PSpeicher::printStatistics(cerr);
			break;}
		case 'S':{ // STATS
			Index i(string(fileName),string("_"), 'W');
			i.getTree()->getRootNode()->printStatistics(cerr);
			CharNode::printRuntimeStats(cerr);
			PSpeicher::printStatistics(cerr);
			break;}
		case 'P':{ // PRINT
			Index i(string(fileName),string("_"), 'W');
			i.getTree()->getRootNode()->print();
			break;}
		case 'A':{ // ALL: CREATE FROM FILE, IOORDER, STATS
			Index i(string(fileName),string("_"), 'N');
			i.insertFromFile(DATA_SUBDIR + string(fileName));
			i.indexOptimize();
			i.getTree()->getRootNode()->printStatistics(cerr);
			CharNode::printRuntimeStats(cerr);
			PSpeicher::printStatistics(cerr);
			break;}
		case 'T':{ // insert From Table
			Index i(string(fileName),string("MARTIN"),'N');
			i.insertFromDatabase(
				string("martin"),  // user
				string("test"),    // pass
				string("localhost"), // host
				string("MARTIN"),  // schema
				string(fileName),  // tablename
				string("EST"));    // attribute
			cout << "\"XXFINDEXCREATE\""
				<< ";" << fileName
				<< ";suffixSize;" << suffixSize  // ist die Länge des Suffix-Strings! nicht die Größe im Speicher!
				<< ";infixSize;" << infixSize
				<< ";nodePageSize;" << nodePageSize
				<< ";suffixPageSize;" << suffixPageSize
				<< ";time;" << (watch.stamp()/(double)1000)
				<< ";suffixIntComp;" << CharNode::internalSuffixIntCompCount
				<< ";suffixExtComp;" << CharNode::internalSuffixExtCompCount
				<< endl;
			CharNode::printRuntimeStats(cerr);
			PSpeicher::printStatistics(cerr);
			break;
		}
		case 'Y':{ // processFromFile
			//cerr<<"starting processFromFile"<<endl;
			//cerr << "file: " << fileName << "\tfileNameOps: " << fileNameOps <<"\toperation_type: " <<operation_type<<endl;
			processFromFile(filename, fileNameOps, operation_type);
			//processFromFile(string(fileName), fileNameOps, operation_type);
			cerr<<"done processFromFile"<<endl;
			CharNode::printRuntimeStats(cerr);
			PSpeicher::printStatistics(cerr);
			break;}
		default:
			break;
	}
	return 0;
	}

#endif

