
#include "DiskPagePool.hpp"

void DiskPage::write(char * source, unsigned int count){
	//cerr << "DiskPage::write() begin" << endl;
	//cerr << "put_ptr == " << (long)put_ptr << ", source == " << (long)source << ", count == " << count << endl;
	//cerr << endl;
	memcpy(put_ptr,source, count);
	put_ptr+=count;
	pos_put+=count;
	pos_end = (pos_put > pos_end?pos_put:pos_end);
	dirty = true;
	//cerr << "DiskPage::write() end" << endl;
}

#ifdef USE_C_FILES
/**
 * Schreibt die gesamte Speicherseite auf die Platte
 * (schreibt aber nur so viel wie nötig, da das Ende des Files noch gebraucht wird...)
 *
 */
void DiskPage::writePage(FILE * & c_file){
//	cerr << "write page " << pos_start << endl;
	fseek(c_file, pos_start, SEEK_SET);
	fwrite(mPage, 1, (pos_end - pos_start), c_file);
	dirty = false;
}

/**
 * Liest möglichst einen ganzen Block ein. Falls die letzte Seite gelesen wird,
 * werden nicht PAGESIZE_ON_DISK chars gelesen; der tatsächliche Wert wird abgefragt
 *
 */
void DiskPage::readPage(FILE * & c_file){
//	cerr << "read page " << pos_start << endl;
	fseek(c_file, pos_start, SEEK_SET);
	pos_end = pos_start + fread(mPage, 1, nsNodePageSize, c_file); // fwrite gibt die tatsächlich geschriebenen Bytes zurück
	dirty = false;
}
#else
/**
 * Schreibt die gesamte Speicherseite auf die Platte
 * (schreibt aber nur so viel wie nötig, da das Ende des Files noch gebraucht wird...)
 *
 */
void DiskPage::writePage(fstream& stream){
//	cerr << "write page " << pos_start << endl;
	stream.clear();
	stream.seekp(pos_start);
	stream.write(mPage, (pos_end - pos_start));
	dirty = false;
}

/**
 * Liest möglichst einen ganzen Block ein. Falls die letzte Seite gelesen wird,
 * werden nicht PAGESIZE_ON_DISK chars gelesen; der tatsächliche Wert wird abgefragt
 *
 */
void DiskPage::readPage(fstream& stream){
//	cerr << "read page " << pos_start << endl;
	stream.seekg(pos_start);
	stream.read(mPage, nsNodePageSize); // möglichst alles lesen
	pos_end = pos_start + stream.gcount();// tatsächlich eingelesene Bytes
	stream.clear();
	dirty = false;
}
#endif

/**
 * D'tor: schaut in der map nach, ob noch Seiten drin sind
 * Seite dirty --> schreiben und löschen, sonst nur löschen
 */
DiskPagePool::~DiskPagePool(){
	for(PagePoolBufferIterator it = pagePool.begin(); it != pagePool.end(); ++it){
		DiskPage* dp = (*it).second;
		if(dp->isDirty()){
#ifdef USE_C_FILES
			dp->writePage(c_baumFile);
#else
			dp->writePage(baumFile);
#endif
		}
		delete dp;
	}
}

/**
 * Setzt den put-Pointer und bereitet den direkten Zugriff auf die Page vor
 * 1. Position setzen
 * 2. Seite suchen und ggf. Laden
 * 3. Zeiger auf aktuelle Seite setzen (currentPutPage)
 *
 */
void DiskPagePool::seekp(POS_TYPE pos){
	pos_put = pos;
	// startPos berechnen
	POS_TYPE startPos = pos_put / nsNodePageSize;
	startPos = (POS_TYPE)startPos * (POS_TYPE)nsNodePageSize;

	currentPutPage = getFromPool(startPos);
	// spart einen Funktionsaufruf
	if(lruList.latest != startPos)lruList.touch(startPos);

	if(currentPutPage == NULL){
		currentPutPage = new DiskPage(startPos);
#ifdef USE_C_FILES
		currentPutPage->readPage(c_baumFile);
#else
		currentPutPage->readPage(baumFile);
#endif
		insertIntoPool(currentPutPage);
	}
	currentPutPage->seekp(pos);
}

/**
 * Setzt den get-Pointer und bereitet den direkten Zugriff auf die Page vor
 * 1. Position setzen
 * 2. Seite suchen und ggf. Laden
 * 3. Zeiger auf aktuelle Seite setzen (currentGetPage)
 *
 */
void DiskPagePool::seekg(POS_TYPE pos){
	pos_get = pos;
	// startPos berechnen
	POS_TYPE startPos = pos_get / nsNodePageSize;

	startPos = (POS_TYPE)startPos * (POS_TYPE)nsNodePageSize;
	// spart einen Funktionsaufruf
	if(lruList.latest != startPos)lruList.touch(startPos);

	currentGetPage = getFromPool(startPos);
	if(currentGetPage == NULL){
		currentGetPage = new DiskPage(startPos);
#ifdef USE_C_FILES
		currentGetPage->readPage(c_baumFile);
#else
		currentGetPage->readPage(baumFile);
#endif
		insertIntoPool(currentGetPage);
	}
	currentGetPage->seekg(pos);
}

/**
 * sucht die DiskPage aus dem Pool heraus, sofern vorhanden
 */
DiskPage * DiskPagePool::getFromPool(POS_TYPE startPos){
	DiskPage * ret = NULL;
	PagePoolBufferIterator it = pagePool.find(startPos);
	if(it != pagePool.end()){
		ret = it->second;
	}
	return ret;
}

/**
 * Fügt eine Seite in den Cache ein
 * --> muß noch das Cache-Verfahren implementieren
 */
bool DiskPagePool::insertIntoPool(DiskPage * page){
	if(nsNodePagesInBuffer == pagePool.size()){
		//cerr << "NUMBER_OF_NODE_DISKPAGES_IN_MEMORY == pagePool.size()" << endl;
		// Pool ist voll; aus der lru-Liste die eine Seite herausnehmen
		POS_TYPE pagePosToReplace = lruList.pop_oldest();
		DiskPage * pageToReplace = pagePool.find(pagePosToReplace)->second;
		// kann an der Stelle einfach nicht null sein, daher auch keine Überprüfung
		// wenn in LRUList, dann auch im PagePool
		pagePool.erase(pagePosToReplace);
		if(pageToReplace->isDirty()){
#ifdef USE_C_FILES
			pageToReplace->writePage(c_baumFile);
#else
			pageToReplace->writePage(baumFile);
#endif
		}
		delete pageToReplace;
	}
	pagePool.insert(pair<POS_TYPE, DiskPage*>(page->getStartPos(), page));
	return true;
}


#ifdef MAKEFLAGE_PAGEPOOL_MAIN // im weiteren nur ein Dummy

// nur fürs compilieren
int main(){
	fstream myFile;
	DiskPagePool dpp(myFile);
	DiskPage dp(0);

	dp.readPage(myFile);
	dp.writePage(myFile);

	dpp.seekg(0);
	dpp.seekp(0);
	dpp.write(NULL,0);
	dpp.read(NULL,0);

	return 0;
}

#endif

