#include <stdio.h>
#include <odci.h>
#include <oci.h>
#include <memory.h>
#include "Index.hpp"
#include "Join.hpp"
#include <cstdlib>


#define  __declspec(  )

//#define SPECIAL_INTERFACE_SPEED_TEST 42

/**
 * Wrapper-Funktionen für die C-Aufrufkonvention des ODCI bereitstellen.
 * extern "C" für C-Namenskonvention
 * --> sind in index.hpp deklariert, definiert in index.cpp
 */

/**
 * Interface für IndexCreate-Funktion.
 * Host/User/Pass sollten über die PARAMETER-Option in CREATE INDEX übergeben werden
 */
extern int itf_ODCIIndexCreate(
	char * indexName,
	char * schemaName,
	char * tableName,
	char * attributeName,
	char * hostname,
	char * username,
	char * password);

/**
 * Das sollte zur Identifikation ausreichen.
 */
extern int itf_ODCIIndexDrop(
	char * indexName,
	char * schemaName);

/**
 * neuen String einfügen
 */
extern int itf_ODCIIndexInsert(
	char * indexName,
	char * schemaName,
	char * rid,
	char * newVal);

/**
 * String löschen
 */
extern int itf_ODCIIndexDelete(
	char * indexName,
	char * schemaName,
	char * rid,
	char * oldVal);

/**
 * String ersetzen
 */
extern int itf_ODCIIndexUpdate(
	char * indexName,
	char * schemaName,
	char * rid,
	char * oldVal,
	char * newVal);

/**
 * Select initialisieren und ausführen; Ergebnisse für Rückgabe vorbereiten
 */
extern int itf_ODCIIndexStart(
		char * indexName,
		char * schemaName,
		char * operationType,
		char * cmpVal,
		char ** rowids); // einfaches Feld ->

extern int itf_ODCIIndexStart(
		char * indexName,
		char * indexSchema,
		char * predicateName,
		char * cmpVal,
		char ** rowid_field,
		int treshold);
//// für between
//extern int itf_ODCIIndexStart_twoArgs(
//		char * indexName,
//		char * schemaName,
//		char * operationType,
//		char * cmpVal,
//		char * cmpVal2,
//		char ** rowids);

// fetch und close werden nicht nach weiter draußen weitergegeben

/***
 * externe Funktionen für die Join-Tablefunction
 * rowids werden als Feld zurückgegeben, bei dem die IDs direkt hintereinander stehen
 */
extern int itf_ODCITableStart(
		char * schemaName,
		char * leftIndexName,
		char * rightIndexName,
		char ** rowids);

//extern int ift_ODCITableFetch();
//extern int ift_ODCITableClose();

/* direkt aus dem Beispiel der Oracle-Doku kopiert (und umbenannt)*/
static int error_processing_routine(OCIExtProcContext *ctx,OCIError *errhp,sword status)
{
  text errbuf[512];
  sb4 errcode = 0;
  int errnum = 29400;  /* choose some oracle error number */
  int rc = 0;

  switch (status)
  {
  case OCI_SUCCESS:
    rc = 0;
    break;
  case OCI_ERROR:
    (void) OCIErrorGet((dvoid *)errhp, (ub4)1, (text *)NULL, &errcode, errbuf, (ub4)sizeof(errbuf), OCI_HTYPE_ERROR);
    /* Raise exception */
    OCIExtProcRaiseExcpWithMsg(ctx, errnum, errbuf, strlen((char *)errbuf));
    rc = 1;
    break;
  default:
    (void) sprintf((char *)errbuf, "Warning - some error (%d)\n", status);
    /* Raise exception */
    (void) OCIErrorGet((dvoid *)errhp, (ub4)1, (text *)NULL, &errcode, errbuf, (ub4)sizeof(errbuf), OCI_HTYPE_ERROR);
    OCIExtProcRaiseExcpWithMsg(ctx, errnum, errbuf, strlen((char *)errbuf));
    rc = 1;
    break;
  }
  return (rc);
}

 OCINumber * ODCIIndexCreate(
	OCIExtProcContext * ctx,
	ODCIIndexInfo * indexInfo,
	ODCIIndexInfo_ind * indexInfo_ind,
	char * parms,
	short params_ind,
	ODCIEnv * indexEnv,
	ODCIEnv_ind * indexEnv_ind
	){

	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */

	/**
	 * Define variables
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;
//	char * strArray[20];

	ODCIColInfo  *column_info;
	dvoid *elemind = (dvoid *)0;
	boolean      exists;

	FILE * f;

	/**
	 * Initialisierung + init return value
	 */

	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));

	/* Get oci handles */
	if (error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){
		return(rval);
	}
  	if (error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){
    	return rval;
	}

	/**
	 * Do something
	 */


	//sprintf(buff, "%d", count_elements);
	// kurze Version mit direktem Zugriff //
	// nur das erste Attribut wird betrachtet, alle weiteren werden ignoriert
	OCICollGetElem(envhp, errhp, indexInfo->IndexCols, 0, &exists, (dvoid**) &column_info, &elemind);

	f = fopen("odciindexcreate.txt","w");
	if(f){
		fprintf(f, "gestartet\n");
		fprintf(f, "%s\n", OCIStringPtr(envhp, indexInfo->IndexName));
		fprintf(f, "%s\n", OCIStringPtr(envhp, indexInfo->IndexSchema));
		fprintf(f, "%s\n", OCIStringPtr(envhp, column_info->TableName));
		fprintf(f, "%s\n", OCIStringPtr(envhp, column_info->ColName));
		fclose(f);
	}


	retval = itf_ODCIIndexCreate(
				(char*)OCIStringPtr(envhp, indexInfo->IndexName),
				(char*)OCIStringPtr(envhp, indexInfo->IndexSchema),
				(char*)OCIStringPtr(envhp, column_info->TableName),
				(char*)OCIStringPtr(envhp, column_info->ColName),
				"localhost","martin","test");

	return rval;
}

 OCINumber * ODCIIndexDrop(
	OCIExtProcContext * ctx,
	ODCIIndexInfo * indexInfo,
	ODCIIndexInfo_ind * indexInfo_ind,
	ODCIEnv * indexEnv,
	ODCIEnv_ind * indexEnv_ind
	){

	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */

	/**
	 * Init return value
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;

	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));

	/* Get oci handles */
	if (error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){
		return(rval);
	}
  	if (error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){
    	return rval;
	}

	/**
	 * Do something
	 */

	retval = itf_ODCIIndexDrop((char*)OCIStringPtr(envhp, indexInfo->IndexName), (char*)OCIStringPtr(envhp, indexInfo->IndexSchema));

	return rval;
}

 OCINumber * ODCIIndexInsert(
	OCIExtProcContext * ctx,
	ODCIIndexInfo * indexInfo,
	ODCIIndexInfo_ind * indexInfo_ind,
	char * rid,
	short rid_ind,
	char * newVal,
	short newVal_ind,
	ODCIEnv * indexEnv,
	ODCIEnv_ind * indexEnv_ind
	){

	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */

	/**
	 * Init return value
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;

	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));

	/* Get oci handles */
	if (error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){
		return(rval);
	}
  	if (error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){
    	return rval;
	}

	/**
	 * Do something
	 */

	retval = itf_ODCIIndexInsert((char*)OCIStringPtr(envhp, indexInfo->IndexName), (char*)OCIStringPtr(envhp, indexInfo->IndexSchema), rid, newVal);

	return rval;
}

 OCINumber * ODCIIndexDelete(
	OCIExtProcContext * ctx,
	ODCIIndexInfo * indexInfo,
	ODCIIndexInfo_ind * indexInfo_ind,
	char * rid,
	short rid_ind,
	char * oldVal,
	short oldVal_ind,
	ODCIEnv * indexEnv,
	ODCIEnv_ind * indexEnv_ind
	){

	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */

	/**
	 * Init return value
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;

	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));

	/* Get oci handles */
	if (error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){
		return(rval);
	}
  	if (error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){
    	return rval;
	}

	/**
	 * Do something
	 */

	retval = itf_ODCIIndexDelete((char*)OCIStringPtr(envhp, indexInfo->IndexName), (char*)OCIStringPtr(envhp, indexInfo->IndexSchema), rid, oldVal);

	return rval;
}


 OCINumber * ODCIIndexUpdate(
	OCIExtProcContext * ctx,
	ODCIIndexInfo * indexInfo,
	ODCIIndexInfo_ind * indexInfo_ind,
	char * rid,
	short rid_ind,
	char * oldVal,
	short oldVal_ind,
	char * newVal,
	short newVal_ind,
	ODCIEnv * indexEnv,
	ODCIEnv_ind * indexEnv_ind
	){

	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */

	/**
	 * Init return value
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;

	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));

	/* Get oci handles */
	if (error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){
		return(rval);
	}
  	if (error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){
    	return rval;
	}

	/**
	 * Do something
	 */

	retval = itf_ODCIIndexUpdate((char*)OCIStringPtr(envhp, indexInfo->IndexName), (char*)OCIStringPtr(envhp, indexInfo->IndexSchema), rid, oldVal, newVal);

	return rval;
}

/* The index implementation type is an object type with a single RAW attribute
 * which will be used to store the context key value.
 * C mapping of the implementation type :
 */
//qxiqtim
struct struct_impl_type
{
   OCIRaw *sctx_qxiqtim; // speichert den Key auf den Scan-Context
};
typedef struct struct_impl_type idx_impl_type;

//qxiqtin
struct struct_impl_type_ind
{
  short atomic_qxiqtin;
  short scind_qxiqtin;
};
typedef struct struct_impl_type_ind idx_impl_type_ind;

/*
 * Ein Pointer auf diese Struktur wird im impl_type gespeichert
 *
 *  Speichert
 * - einen Pointer auf ein char*-Feld mit den rowids
 * - einen int der Gesamtgröße des Feldes
 * - einen int der aktuellen Position im Feld (also die next-Position)
 */
struct struct_cpppt_scan_context{
	OCIString * rid_field_string;
	OCIRaw * rid_count;
	OCIRaw * rid_pos;
};
typedef struct struct_cpppt_scan_context cpppt_scan_context;


OCINumber * ODCIIndexStart(
	OCIExtProcContext * ctx,

	idx_impl_type           *sctx,
	idx_impl_type_ind       *sctx_ind,

	ODCIIndexInfo * indexInfo,
	ODCIIndexInfo_ind * indexInfo_ind,
	ODCIPredInfo * indexPredInfo,
	ODCIPredInfo_ind * indexPredInfo_ind,
	ODCIQueryInfo * indexQueryInfo,
	ODCIQueryInfo_ind * indexQueryInfo_ind,
	OCINumber * start,
	short start_ind,
	OCINumber * stop,
	short stop_ind,
	char * cmpVal,
	short cmpVal_ind,
	ODCIEnv * indexEnv,
	ODCIEnv_ind * indexEnv_ind
	){

	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */
	OCISession * usrhp; /* user handle -> scheint ein session-handle zu sein */

	// neu
	cpppt_scan_context * scan_context; // Scan Context für später
	ub4 key; // scan context key value

	int strtVal;
	int stopVal;

	// dann ggf. noch error messages
//	int errnum = 29400;
//	char errmsg[512];
//	size_t errmsg_len;

	// SQL-Statement, das wohl mit übergeben wird
	//char select_statement[2000];


	boolean      exists;
	ODCIColInfo  *colInfo;
//	ODCIObject   *odciObject;
	dvoid *elemind = (dvoid *)0;
//	dvoid *elem = (dvoid *)0;

//	char * strArray[300]; //!
//	int strArrayPos = 0;
//	int count_elements = 0;
//	OCIIter * iterator;
//	int i = 0;
//	sword status;
//	boolean eoc;
//	char strCount[20];
	char * indexName;
	char * indexSchema;
	char * predicateName;
	char * rowid_field = (char*)0;

	int count_rowids = 0;
	int pos_rowids = 0;

	FILE * f;

	/**
	 * Initialsierung
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;
	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));
	// context holen
	if(error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){return(rval);}
	// ret-val kopieren und initialisieren
  	if(error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){return rval;}
  	// user-context holen
  	if(error_processing_routine(ctx, errhp, OCIAttrGet((dvoid*)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid *)&usrhp, (ub4 *)0, (ub4)OCI_ATTR_SESSION, errhp))){return rval;};

	// assign memory for scan context
	if(error_processing_routine(ctx, errhp, OCIMemoryAlloc((dvoid *)usrhp, errhp,(dvoid **)&scan_context,OCI_DURATION_STATEMENT,(ub4)(sizeof(cpppt_scan_context)),OCI_MEMORY_CLEARED))){return rval;};
	//scan_context->rid_field = NULL;
	scan_context->rid_field_string = NULL;
	scan_context->rid_pos = NULL;
	scan_context->rid_count = NULL;


	/**
	 * Do something
	 */

	// start und stop auswerten --> CppPTeq(,) = 1 / 0
	error_processing_routine(ctx,errhp,OCINumberToInt(errhp, start,sizeof(strtVal), OCI_NUMBER_SIGNED, (dvoid*)&strtVal));
	error_processing_routine(ctx,errhp,OCINumberToInt(errhp, stop,sizeof(stopVal), OCI_NUMBER_SIGNED, (dvoid *)&stopVal));
	if(! ((strtVal == 1 && stopVal == 1) || (strtVal == 0 && stopVal == 0))){
		// hier Fehler (ist eigentlich scheißegal, hauptsache der operator wird angegeben)
	}

	OCICollGetElem(envhp, errhp, indexInfo->IndexCols, 0, &exists, (dvoid**)&colInfo, &elemind);
	indexSchema = (char*)OCIStringPtr(envhp, indexInfo->IndexSchema);
	indexName = (char*)OCIStringPtr(envhp, indexInfo->IndexName);
	predicateName = (char*)OCIStringPtr(envhp, indexPredInfo->ObjectName);

	/**
	 * Interface
	 * - indexName
	 * - indexSchema
	 * - char * Operation
	 * - char * cmpVal
	 * - char ** returned rowids
	 */

#ifdef SPECIAL_INTERFACE_SPEED_TEST
	// für die Geschwindigkeitsmessung wird nur eine konstante rowid zurückgegeben
	// ist in dem Fall für die Tabelle "out100"
	count_rowids = 1;// temporär! offset-test
	rowid_field = "AAADVsAAEAAA/CQAAj"; // manipulation für offset-test
#else
	count_rowids = itf_ODCIIndexStart(indexName, indexSchema, predicateName , cmpVal, &rowid_field);

	f = fopen("/home/a/workspace/CppTree/log_odciindexstart.log","w");
	if(f){
		fprintf(f, "indexName == %s\n", indexName);
		fprintf(f, "indexSchema == %s\n", indexSchema);
		fprintf(f, "predicateName == %s\n", predicateName);
		fprintf(f, "cmpVal == %s\n", cmpVal);

		fprintf(f, "count_rowids == %d\n", count_rowids);
		fprintf(f, "rowid_field == %s\n", rowid_field);
		fclose(f);
	}

	if(rowid_field != NULL && count_rowids > 0){
		rowid_field[count_rowids * 18] = 0;
	}else{
		rowid_field = "";
		count_rowids = 0;
	}
#endif


	OCIStringAssignText(envhp, errhp, (const oratext*)rowid_field, count_rowids * 18, &scan_context->rid_field_string);

	// C-Speicher wieder freigeben
	free(rowid_field);

	// Werte in den Context schreiben
	error_processing_routine(ctx,errhp,OCIRawAssignBytes(envhp, errhp, (ub1*)&count_rowids, sizeof(count_rowids), &(scan_context->rid_count)));
	error_processing_routine(ctx,errhp,OCIRawAssignBytes(envhp, errhp, (ub1*)&pos_rowids, sizeof(pos_rowids), &(scan_context->rid_pos)));

	/************************************/
	/* Set index context to be returned */
	/************************************/
	/* generate a key */
	error_processing_routine(ctx, errhp, OCIContextGenerateKey((dvoid *)usrhp, errhp, &key));
	/* set the memory address of the struct to be saved in the context */
	/* key wird mit dem struct scan_context verbunden */
	error_processing_routine(ctx, errhp, OCIContextSetValue((dvoid *)usrhp, errhp,OCI_DURATION_STATEMENT,(ub1*) &key, (ub1)sizeof(key), (dvoid *)scan_context));
	/* set the key as the member of "sctx" */
	error_processing_routine(ctx, errhp, OCIRawAssignBytes(envhp, errhp, (ub1 *)&key, (ub4)sizeof(key), &(sctx->sctx_qxiqtim)));

	sctx_ind->atomic_qxiqtin = OCI_IND_NOTNULL;
	sctx_ind->scind_qxiqtin = OCI_IND_NOTNULL;

	return rval;
}

// OCINumber * ODCIIndexAppx(
//	OCIExtProcContext * ctx,
//
//	idx_impl_type           *sctx,
//	idx_impl_type_ind       *sctx_ind,
//
//	ODCIIndexInfo * indexInfo,
//	ODCIIndexInfo_ind * indexInfo_ind,
//	ODCIPredInfo * indexPredInfo,
//	ODCIPredInfo_ind * indexPredInfo_ind,
//	ODCIQueryInfo * indexQueryInfo,
//	ODCIQueryInfo_ind * indexQueryInfo_ind,
//	OCINumber * start,
//	short start_ind,
//	OCINumber * stop,
//	short stop_ind,
//	char * cmpVal,
//	short cmpVal_ind,
//	ODCIEnv * indexEnv,
//	ODCIEnv_ind * indexEnv_ind
//	){
//
//	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
//	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
//	OCIError *errhp = (OCIError *) 0;         /* error handle */
//	OCISession * usrhp; /* user handle -> scheint ein session-handle zu sein */
//
//	// neu
//	cpppt_scan_context * scan_context; // Scan Context für später
//	ub4 key; // scan context key value
//
//	int strtVal;
//	int stopVal;
//
//	// dann ggf. noch error messages
////	int errnum = 29400;
////	char errmsg[512];
////	size_t errmsg_len;
//
//	// SQL-Statement, das wohl mit übergeben wird
//	//char select_statement[2000];
//
//
//	boolean      exists;
//	ODCIColInfo  *colInfo;
////	ODCIObject   *odciObject;
//	dvoid *elemind = (dvoid *)0;
////	dvoid *elem = (dvoid *)0;
//
////	char * strArray[300]; //!
////	int strArrayPos = 0;
////	int count_elements = 0;
////	OCIIter * iterator;
////	int i = 0;
////	sword status;
////	boolean eoc;
////	char strCount[20];
//	char * indexName;
//	char * indexSchema;
//	char * predicateName;
//	char * rowid_field = (char*)0;
//	int treshold;
//
//	int count_rowids = 0;
//	int pos_rowids = 0;
//
//	FILE * f;
//
//	/**
//	 * Initialsierung
//	 */
//
//	OCINumber * rval = (OCINumber*) 0;
//	int retval = (int)ODCI_SUCCESS;
//	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));
//	// context holen
//	if(error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){return(rval);}
//	// ret-val kopieren und initialisieren
//  	if(error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){return rval;}
//  	// user-context holen
//  	if(error_processing_routine(ctx, errhp, OCIAttrGet((dvoid*)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid *)&usrhp, (ub4 *)0, (ub4)OCI_ATTR_SESSION, errhp))){return rval;};
//
//	// assign memory for scan context
//	if(error_processing_routine(ctx, errhp, OCIMemoryAlloc((dvoid *)usrhp, errhp,(dvoid **)&scan_context,OCI_DURATION_STATEMENT,(ub4)(sizeof(cpppt_scan_context)),OCI_MEMORY_CLEARED))){return rval;};
//	//scan_context->rid_field = NULL;
//	scan_context->rid_field_string = NULL;
//	scan_context->rid_pos = NULL;
//	scan_context->rid_count = NULL;
//
//
//	/**
//	 * Do something
//	 */
//
//	// start und stop auswerten --> CppPTeq(,) = 1 / 0
//	error_processing_routine(ctx,errhp,OCINumberToInt(errhp, start,sizeof(strtVal), OCI_NUMBER_SIGNED, (dvoid *)&strtVal));
//	error_processing_routine(ctx,errhp,OCINumberToInt(errhp, stop,sizeof(stopVal), OCI_NUMBER_SIGNED, (dvoid *)&stopVal));
//	if(! ((strtVal == 1 && stopVal == 1) || (strtVal == 0 && stopVal == 0))){
//		// hier Fehler (ist eigentlich scheißegal, hauptsache der operator wird angegeben)
//	}
//
//	OCICollGetElem(envhp, errhp, indexInfo->IndexCols, 0, &exists, (dvoid**)&colInfo, &elemind);
//	indexSchema = (char*)OCIStringPtr(envhp, indexInfo->IndexSchema);
//	indexName = (char*)OCIStringPtr(envhp, indexInfo->IndexName);
//	predicateName = (char*)OCIStringPtr(envhp, indexPredInfo->ObjectName);
//
//	/**
//	 * Interface
//	 * - indexName
//	 * - indexSchema
//	 * - char * Operation
//	 * - char * cmpVal
//	 * - char ** returned rowids
//	 */
//
//#ifdef SPECIAL_INTERFACE_SPEED_TEST
//	// für die Geschwindigkeitsmessung wird nur eine konstante rowid zurückgegeben
//	// ist in dem Fall für die Tabelle "out100"
//	count_rowids = 1;// temporär! offset-test
//	rowid_field = "AAADVsAAEAAA/CQAAj"; // manipulation für offset-test
//#else
//	count_rowids = itf_ODCIIndexStart(indexName, indexSchema, predicateName , cmpVal, &rowid_field, treshold);
//
//	f = fopen("/home/a/workspace/CppTree/log_odciindexstart.log","w");
//	if(f){
//		fprintf(f, "indexName == %s\n", indexName);
//		fprintf(f, "indexSchema == %s\n", indexSchema);
//		fprintf(f, "predicateName == %s\n", predicateName);
//		fprintf(f, "cmpVal == %s\n", cmpVal);
//
//		fprintf(f, "count_rowids == %d\n", count_rowids);
//		fprintf(f, "rowid_field == %s\n", rowid_field);
//		fclose(f);
//	}
//
//	if(rowid_field != NULL && count_rowids > 0){
//		rowid_field[count_rowids * 18] = 0;
//	}else{
//		rowid_field = "";
//		count_rowids = 0;
//	}
//#endif
//
//
//	OCIStringAssignText(envhp, errhp,(const oratext*) rowid_field, count_rowids * 18, &scan_context->rid_field_string);
//
//	// C-Speicher wieder freigeben
//	free(rowid_field);
//
//	// Werte in den Context schreiben
//	error_processing_routine(ctx,errhp,OCIRawAssignBytes(envhp, errhp, (ub1*)&count_rowids, sizeof(count_rowids), &(scan_context->rid_count)));
//	error_processing_routine(ctx,errhp,OCIRawAssignBytes(envhp, errhp, (ub1*)&pos_rowids, sizeof(pos_rowids), &(scan_context->rid_pos)));
//
//	/************************************/
//	/* Set index context to be returned */
//	/************************************/
//	/* generate a key */
//	error_processing_routine(ctx, errhp, OCIContextGenerateKey((dvoid *)usrhp, errhp, &key));
//	/* set the memory address of the struct to be saved in the context */
//	/* key wird mit dem struct scan_context verbunden */
//	error_processing_routine(ctx, errhp, OCIContextSetValue((dvoid *)usrhp, errhp,OCI_DURATION_STATEMENT,(ub1*) &key, (ub1)sizeof(key), (dvoid *)scan_context));
//	/* set the key as the member of "sctx" */
//	error_processing_routine(ctx, errhp, OCIRawAssignBytes(envhp, errhp, (ub1 *)&key, (ub4)sizeof(key), &(sctx->sctx_qxiqtim)));
//
//	sctx_ind->atomic_qxiqtin = OCI_IND_NOTNULL;
//	sctx_ind->scind_qxiqtin = OCI_IND_NOTNULL;
//
//	return rval;
//}


 OCINumber * ODCIIndexFetch(
	// aus dem Beispiel
	OCIExtProcContext *ctx,
	idx_impl_type     *self,
	idx_impl_type_ind *self_ind,
	OCINumber         *nrows,
	short             nrows_ind,
	OCIArray          **rids,
	short             *rids_ind,
	ODCIEnv           *env,
	dvoid             *env_ind

	){

	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */
	OCISession * usrhp;

//	char * errbuf = "Abbruch der ODCIIndexFetch-Routine per Exception!";
	/**
	 * Init return value
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;


	/**
	 * User variables
	 */
	int nrows_int;
	int sctx_count, sctx_pos;
	ub1* key;
	ub4 keylen;
	cpppt_scan_context * scan_context;

	/* rowid collection */
	OCIArray *ridarrp = *rids;
	OCIString *ridstr = (OCIString *)0;

	char rowid[19];
	// variablen für die Schleifen
	int cPos=0,maxPos=0,count=0;

//	ub1* rowid_field_ptr;
	char * rowid_field;

	FILE * f;

	/**
	 * Init
	 */

	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));

	/* Get oci handles */
	if (error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){return(rval);}
  	if (error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){return rval;}
  	// user-context holen
  	if(error_processing_routine(ctx, errhp, OCIAttrGet((dvoid*)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid *)&usrhp, (ub4 *)0, (ub4)OCI_ATTR_SESSION, errhp))){return rval;};


	/**
	 * Do something
	 */

	// retrieve context from key
	key = OCIRawPtr(envhp, self->sctx_qxiqtim);
	keylen = OCIRawSize(envhp, self->sctx_qxiqtim);

	// context holen
	OCIContextGetValue((dvoid*)usrhp, errhp, key, (ub1)keylen, (dvoid**)&scan_context);

	// nrows auslesen
	OCINumberToInt(errhp, nrows, sizeof(nrows_int), OCI_NUMBER_SIGNED, (dvoid *)&nrows_int);
	rowid_field = (char*)OCIStringPtr(envhp, scan_context->rid_field_string);

	// Zahlen aus dem Context-Struct auslesen
	sctx_count = (int)*(OCIRawPtr(envhp, scan_context->rid_count));
	sctx_pos = (int)*(OCIRawPtr(envhp, scan_context->rid_pos));

	// in der Hoffnung, daß die Adresse noch da ist, wird das rowid-Feld ausgelesen
	rowid[18] = 0;
	count = 0;
	cPos = sctx_pos/* * 18 */;
	maxPos = (sctx_count * 18)-1;

	f = fopen("/home/a/workspace/CppTree/log_odciindexfetch.log","w");
	if(f){
		fprintf(f, "rowid_field == %s\n", rowid_field);

		fprintf(f, "sctx_count == %d\n", sctx_count);
		fprintf(f, "sctx_pos == %d\n", sctx_pos);
		fprintf(f, "cPos == %d\n", cPos);
		fprintf(f, "maxPos == %d\n", maxPos);
		fclose(f);
	}

	while(count < nrows_int){
		if(cPos > maxPos){
			short col_ind = OCI_IND_NULL;
			/* have to create dummy oci string */
			OCIStringAssignText(envhp, errhp, (text *)"dummy",(ub2)5, &ridstr);
			/* append null element to collection */
        	OCICollAppend(envhp, errhp,(dvoid *)ridstr,(dvoid *)&col_ind,(OCIColl *)ridarrp);
        	break;
		}else{
			memcpy(rowid,(const char*)&(rowid_field[cPos]), 18);
			OCIStringAssignText(envhp, errhp, (text *)rowid,(ub2)18, (OCIString **)&ridstr);
			OCICollAppend(envhp, errhp, (dvoid *)ridstr,(dvoid *)0 /* hier kein Indicator */, (OCIColl *)ridarrp);
			cPos += 18;
			++count;
		}
	}
	// jetzt Position rückspeichern
	error_processing_routine(ctx,errhp,OCIRawAssignBytes(envhp, errhp, (ub1*)&cPos, sizeof(cPos), &(scan_context->rid_pos)));

	// OCIString freigeben
	OCIStringResize(envhp, errhp, (ub4)0, &ridstr);

	// NULL-Indicator auf "nicht null" setzen
	*rids_ind = OCI_IND_NOTNULL;

	return rval;
}


// Hier weiter... --> Methode registrieren etc.
 OCINumber * ODCIIndexClose(
	OCIExtProcContext *ctx,
	idx_impl_type     *self,
	idx_impl_type_ind *self_ind,
	ODCIEnv           *env,
	dvoid             *env_ind
){
	OCIEnv *envhp = (OCIEnv *) 0;             /* env. handle */
	OCISvcCtx *svchp = (OCISvcCtx *) 0;       /* service handle */
	OCIError *errhp = (OCIError *) 0;         /* error handle */
	OCISession * usrhp;

	/**
	 * User variables
	 */
//	char * errbuf = "Abbruch der ODCIIndexClose-Routine per Exception!";

	ub1* key;
	ub4 keylen;
	cpppt_scan_context * scan_context;

//	FILE * f;

	/**
	 * Initialsierung
	 */

	OCINumber * rval = (OCINumber*) 0;
	int retval = (int)ODCI_SUCCESS;

	rval = (OCINumber *)OCIExtProcAllocCallMemory(ctx, sizeof(OCINumber));
	if(error_processing_routine(ctx, errhp, OCIExtProcGetEnv(ctx, &envhp, &svchp, &errhp))){return(rval);}
  	if(error_processing_routine(ctx, errhp, OCINumberFromInt(errhp, (dvoid *)&retval,sizeof(retval),OCI_NUMBER_SIGNED, rval))){return rval;}
  	// user-context holen
  	if(error_processing_routine(ctx, errhp, OCIAttrGet((dvoid*)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid *)&usrhp, (ub4 *)0, (ub4)OCI_ATTR_SESSION, errhp))){return rval;};

	/**
	 * Do something
	 */

	// retrieve context from key
	key = OCIRawPtr(envhp, self->sctx_qxiqtim);
	keylen = OCIRawSize(envhp, self->sctx_qxiqtim);

	// context holen
	OCIContextGetValue((dvoid*)usrhp, errhp, key, (ub1)keylen, (dvoid**)&scan_context);

	// Speicher zurückgeben (sowas wie ein "free()")
	OCIStringResize(envhp, errhp, 0, &scan_context->rid_field_string);

	// jetzt Speicher freigeben für Scan Context
	OCIMemoryFree((dvoid *)usrhp, errhp, (dvoid *)scan_context);

	// das wars
	return rval;
}


/*---------------------------------------------------------------------------
					 TABLE FUNCTION
                     PRIVATE TYPES AND CONSTANTS
  Teile des Programmcodes sind der ODCI-Online-Hilfe entnommen.
  ---------------------------------------------------------------------------

Die Doku für die Tablefunction scheint einem anderen C-Dialekt anzugehören.
Die Namen sind wesentlich klarer, kein old-style-C mehr.

*/

/* The struct holding the user's stored context */

struct StoredCtx
{
	OCIString * rid_field_string;
//	OCIRaw * rid_pos;
//	OCIRaw * rid_count;
	int i_rid_pos;
	int i_rid_count;
};
typedef struct StoredCtx StoredCtx;

/* OCI Handles */

struct Handles_t
{
  OCIExtProcContext* extProcCtx;
  OCIEnv* envhp;
  OCISvcCtx* svchp;
  OCIError* errhp;
  OCISession* usrhp;
};
typedef struct Handles_t Handles_t;

/********************** SQL Types C representation **********************/

/* Table function's implementation type */

struct CppPTreeJoinImpl
{
  OCIRaw* key;
};
typedef struct CppPTreeJoinImpl CppPTreeJoinImpl;

struct CppPTreeJoinImpl_ind
{
  short _atomic;
  short key;
};
typedef struct CppPTreeJoinImpl_ind CppPTreeJoinImpl_ind;

/* Table function's output collection element type */

struct JoinType
{
  OCIString* leftRowID;
  OCIString* rightRowID;
};
typedef struct JoinType JoinType;

struct JoinType_ind
{
  short _atomic;
  short leftRowID;
  short rightRowID;
};
typedef struct JoinType_ind JoinType_ind;

/* Table function's output collection type */

typedef OCITable JoinTypeSet;

/*--------------------------------------------------------------------------*/
/* Static Functions */
/*--------------------------------------------------------------------------*/

static int GetHandles(OCIExtProcContext* extProcCtx, Handles_t* handles);

static StoredCtx* GetStoredCtx(
	Handles_t* handles,
	CppPTreeJoinImpl* self,
	CppPTreeJoinImpl_ind* self_ind);

static int checkerr(Handles_t* handles, sword status);


/**
 * Initialisiert und führt den Join aus.
 * Schreibt das Ergebnis so weg, daß TableFetch nur noch kopieren muß.
 */
 int ODCITableStart(
	OCIExtProcContext*     extProcCtx,
	CppPTreeJoinImpl*      self,
	CppPTreeJoinImpl_ind*  self_ind,
	OCIString*             schemaName,
	short                  schemaName_ind,
	OCIString*             leftIndexName,
	short                  leftIndexName_ind,
	OCIString*             rightIndexName,
	short                  rightIndexName_ind){

	Handles_t handles;
	StoredCtx * storedCtx;

	ub4 key;

	char * cSchemaName;
	char * cLeftIndexName;
	char * cRightIndexName;
	char * rowid_field = (char*)0;
	int count_rowids = 0;
	int pos_rowids = 0;
//    FILE * f;

	if(GetHandles(extProcCtx, &handles)) return OCI_ERROR;

	/* Allocate memory to hold the stored context */
	if(checkerr(&handles, OCIMemoryAlloc((dvoid*) handles.usrhp, handles.errhp,
                                        (dvoid**) &storedCtx,
                                        OCI_DURATION_STATEMENT,
                                        (ub4) sizeof(StoredCtx),
                                        OCI_MEMORY_CLEARED)))
    return ODCI_ERROR;


    // schreibe hier alles wie beim Select einfach in ein char*-Array rein
    //  --> wird dann als OCIString gespeichert
    // count gibt die doppelte Größe an, also 2x18
    // der Rückgabewert ist eine OCITable, also einfach eine OCICollection
    // Elemente vom Typ "JoinType" werden einfach angefügt

    // 1. Argumente zur Überprüfung herausschreiben

	//keine Ahnung, warum das nicht funktioniert...
	cSchemaName = (char*)schemaName;//OCIStringPtr(handles.envhp, schemaName);
	cLeftIndexName = (char*)leftIndexName;//OCIStringPtr(handles.envhp, leftIndexName);
	cRightIndexName = (char*)rightIndexName;//OCIStringPtr(handles.envhp, rightIndexName);

    // hier Join ausführen
    count_rowids = itf_ODCITableStart(cSchemaName, cLeftIndexName, cRightIndexName, &rowid_field);
    pos_rowids = 0;

    /*
	f = fopen("D:/oracle/express_edition/oradata/idx_data/log_odcitablestart.log","w");
	if(f){
		fprintf(f, "ODCITableStart\n");
		fprintf(f, "schemaName == %s \n", cSchemaName);
		fprintf(f, "leftIndex == %s \n", cLeftIndexName);
		fprintf(f, "rightIndex == %s \n", cRightIndexName);
		fprintf(f, "count_rowids == %d\n", count_rowids);
		fprintf(f, "rowid_field == %s\n", rowid_field);
		fclose(f);
	}
*/
	OCIStringAssignText(handles.envhp, handles.errhp,(const oratext*) rowid_field, count_rowids * 18 * 2, &storedCtx->rid_field_string);

	// C-Speicher wieder freigeben
	free(rowid_field);

	// Werte in den Context schreiben
//	checkerr(&handles, OCIRawAssignBytes(handles.envhp, handles.errhp, (ub1*)&count_rowids, sizeof(count_rowids), &(storedCtx->rid_count)));
//	checkerr(&handles, OCIRawAssignBytes(handles.envhp, handles.errhp, (ub1*)&pos_rowids, sizeof(pos_rowids), &(storedCtx->rid_pos)));
	// es ist offenbar garnicht notwendig, die werte in OCI-Objekte zu schreiben...
	storedCtx->i_rid_count = count_rowids;
	storedCtx->i_rid_pos = pos_rowids;



	/* generate a key */
	if (checkerr(&handles, OCIContextGenerateKey((dvoid*) handles.usrhp,
                                               handles.errhp, &key)))
	return ODCI_ERROR;

	/* associate the key value with the stored context address */
	if (checkerr(&handles, OCIContextSetValue((dvoid*)handles.usrhp,
                                            handles.errhp,
                                            OCI_DURATION_STATEMENT,
                                            (ub1*) &key, (ub1) sizeof(key),
                                            (dvoid*) storedCtx)))
	return ODCI_ERROR;

	/* stored the key in the scan context */
	if (checkerr(&handles, OCIRawAssignBytes(handles.envhp, handles.errhp,
                                           (ub1*) &key, (ub4) sizeof(key),
                                           &(self->key))))
	return ODCI_ERROR;

	/* set indicators of the scan context */
	self_ind->_atomic = OCI_IND_NOTNULL;
	self_ind->key = OCI_IND_NOTNULL;


	return ODCI_SUCCESS;
}



/***********************************************************************/

/* Callout for ODCITableFetch */

 int ODCITableFetch(OCIExtProcContext* extProcCtx,
					CppPTreeJoinImpl*      self,
					CppPTreeJoinImpl_ind*  self_ind,
					OCINumber*             nrows,
					short                  nrows_ind,
					JoinTypeSet**          outSet,
					short*                 outSet_ind)
{
	Handles_t handles;                   /* OCI hanldes */
	StoredCtx* storedCtx;                /* Stored context pointer */
	int nrowsval = 0;                        /* number of rows to return */
	/*FILE * f;*/
	char * rowid_field = (char*)0;
//	ub1* rowid_field_ptr;
//	int sctx_count = 0;
//	int sctx_pos = 0;

	int cPos=0;
	int maxPos=0;
	int count=0;
	char rowid[100];
	// variablen für die Schleifen


	/* Get OCI handles */
	if (GetHandles(extProcCtx, &handles)) return ODCI_ERROR;

	/* Get the stored context */
	storedCtx=GetStoredCtx(&handles,self,self_ind);
	if (!storedCtx) return ODCI_ERROR;

	/* get value of nrows */
	if (checkerr(&handles, OCINumberToInt(handles.errhp, nrows, sizeof(nrowsval),
							OCI_NUMBER_SIGNED, (dvoid *)&nrowsval)))
	return ODCI_ERROR;

	// ScanContext oben schon geholt
	rowid_field = (char*)OCIStringPtr(handles.envhp, storedCtx->rid_field_string);

//	// Zahlen aus dem Context-Struct auslesen
//	sctx_count = (int)*(OCIRawPtr(handles.envhp, storedCtx->rid_count));
//	sctx_pos = (int)*(OCIRawPtr(handles.envhp, storedCtx->rid_pos));

	rowid[18] = 0;
	count = 0;
//	//cPos = sctx_pos /* * 18 */;
	cPos = storedCtx->i_rid_pos;
//	//maxPos = (sctx_count * 18 * 2)-1; // -1, weil 0-indiziert
	maxPos = (storedCtx->i_rid_count * 18 * 2)-1; // -1, weil 0-indiziert

	/*
	f = fopen("/home/a/workspace/CppTree/log_odcitablefetch.log","w");
	if(f){
		fprintf(f, "ODCITableFetch\n");
		fprintf(f, "nrowsval == %d\n", nrowsval);
		fprintf(f, "rowid_field == %s\n", rowid_field);
		fprintf(f, "cPos == %d\n", cPos);
		fprintf(f, "maxPos == %d\n", maxPos);
		fprintf(f, "sctx_count == %d\n", sctx_count);
		fprintf(f, "sctx_pos == %d\n", sctx_pos);
		fprintf(f, "storedCtx->i_rid_count == %d\n", storedCtx->i_rid_count);
		fprintf(f, "storedCtx->i_rid_pos == %d\n", storedCtx->i_rid_pos);
		//fclose(f);
	}
	*/
	/* set collection indicator to not null */
	*outSet_ind=OCI_IND_NULL;

	while(count < nrowsval && cPos <= maxPos){

		JoinType elem;
		JoinType_ind elem_ind;

		if(cPos > maxPos){
			elem_ind._atomic = OCI_IND_NULL;
			elem_ind.leftRowID = OCI_IND_NULL;
			elem_ind.rightRowID = OCI_IND_NULL;

			elem.leftRowID = NULL;
			elem.rightRowID = NULL;

			/* append null element to collection */
        	if(checkerr(&handles, OCICollAppend(handles.envhp, handles.errhp, &elem, &elem_ind, (OCIColl *)*outSet)))
				return ODCI_ERROR;
			*outSet_ind=OCI_IND_NULL;
        	break;
		}else{
			elem_ind._atomic = OCI_IND_NOTNULL;
			elem_ind.leftRowID = OCI_IND_NOTNULL;
			elem_ind.rightRowID = OCI_IND_NOTNULL;

			elem.leftRowID = NULL;
			elem.rightRowID = NULL;

			memcpy(rowid,(const char*)&(rowid_field[cPos]), 18);
			cPos += 18;
			if(checkerr(&handles, OCIStringAssignText(handles.envhp, handles.errhp, (text *)rowid,(ub2)18, (OCIString **)&elem.leftRowID)))
				return ODCI_ERROR;
			memcpy(rowid,(const char*)&(rowid_field[cPos]), 18);
			cPos += 18;
			if(checkerr(&handles, OCIStringAssignText(handles.envhp, handles.errhp, (text *)rowid,(ub2)18, (OCIString **)&elem.rightRowID)))
				return ODCI_ERROR;
			if(checkerr(&handles, OCICollAppend(handles.envhp, handles.errhp, &elem, &elem_ind, (OCIColl *)*outSet)))
				return ODCI_ERROR;
			++count;

			/*
			if(f)fprintf(f, "loop>>cPos == %d\n", cPos);
			if(f)fprintf(f, "loop>>count == %d\n", count);
			 */
		}

		/* set collection indicator to not null */
		*outSet_ind=OCI_IND_NOTNULL;
	}
	// jetzt Position rückspeichern
//	if(checkerr(&handles,
//		OCIRawAssignBytes(handles.envhp, handles.errhp, (ub1*)&cPos, 4 /*sizeof(cPos)*/, &(storedCtx->rid_pos))))
//		return ODCI_ERROR;
	storedCtx->i_rid_pos = cPos;

	/*
	if(f)fprintf(f,"cPos == %d \n", cPos);
	if(f)fclose(f);
	*/
	return ODCI_SUCCESS;
}

/***********************************************************************/

/* Callout for ODCITableClose */

 int ODCITableClose(OCIExtProcContext* extProcCtx,
							CppPTreeJoinImpl* self,
							CppPTreeJoinImpl_ind* self_ind)
{
	Handles_t handles;                   /* OCI hanldes */
	StoredCtx* storedCtx;                /* Stored context pointer */
	/*FILE * f;*/

	/* Get OCI handles */
	if (GetHandles(extProcCtx, &handles))return ODCI_ERROR;

	/* Get the stored context */
	storedCtx=GetStoredCtx(&handles,self,self_ind);
	if (!storedCtx) return ODCI_ERROR;

	/*
	f = fopen("D:/oracle/express_edition/oradata/idx_data/log_odcitableclose.log","w");
	if(f){
		fprintf(f, "ODCITableClose\n");
		fclose(f);
	}
	*/
	// Speicher zurückgeben (sowas wie ein "free()")
	if(checkerr(&handles, OCIStringResize(handles.envhp, handles.errhp, 0, &storedCtx->rid_field_string)))
		return ODCI_ERROR;

	/* Free the memory for the stored context */
	if (checkerr(&handles, OCIMemoryFree((dvoid*) handles.usrhp, handles.errhp, (dvoid*) storedCtx)))
		return ODCI_ERROR;

	return ODCI_SUCCESS;
}


/***********************************************************************/
/* komplett aus der Hilfe übernommen */
/* Get the stored context using the key in the scan context */

static StoredCtx* GetStoredCtx(
	Handles_t* handles,
	CppPTreeJoinImpl* self,
	CppPTreeJoinImpl_ind* self_ind)
{
  StoredCtx *storedCtx;           /* Stored context pointer */
  ub1 *key;                       /* key to retrieve context */
  ub4 keylen;                     /* length of key */

  /* return NULL if the PL/SQL context is NULL */
  if (self_ind->_atomic == OCI_IND_NULL) return NULL;

  /* Get the key */
  key = OCIRawPtr(handles->envhp, self->key);
  keylen = OCIRawSize(handles->envhp, self->key);

  /* Retrieve stored context using the key */
  if (checkerr(handles, OCIContextGetValue((dvoid*) handles->usrhp,
                                           handles->errhp,
                                           key, (ub1) keylen,
                                           (dvoid**) &storedCtx)))
    return NULL;

  return storedCtx;
}

/***********************************************************************/

/* Get OCI handles using the ext-proc context */

static int GetHandles(OCIExtProcContext* extProcCtx, Handles_t* handles)
{
  /* store the ext-proc context in the handles struct */
  handles->extProcCtx=extProcCtx;

  /* Get OCI handles */
  if (checkerr(handles, OCIExtProcGetEnv(extProcCtx, &handles->envhp,
                          &handles->svchp, &handles->errhp)))
    return -1;

  /* get the user handle */
  if (checkerr(handles, OCIAttrGet((dvoid*)handles->svchp,
                                   (ub4)OCI_HTYPE_SVCCTX,
                                   (dvoid*)&handles->usrhp,
                                   (ub4*) 0, (ub4)OCI_ATTR_SESSION,
                                   handles->errhp)))
    return -1;

  return 0;
}

/***********************************************************************/

/* Check the error status and throw exception if necessary */

static int checkerr(Handles_t* handles, sword status)
{
  text errbuf[512];     /* error message buffer */
  sb4 errcode;          /* OCI error code */

  switch (status)
  {
  case OCI_SUCCESS:
  case OCI_SUCCESS_WITH_INFO:
    return 0;
  case OCI_ERROR:
    OCIErrorGet ((dvoid*) handles->errhp, (ub4) 1, (text *) NULL, &errcode,
                 errbuf, (ub4) sizeof(errbuf), (ub4) OCI_HTYPE_ERROR);
    sprintf((char*)errbuf, "OCI ERROR code %d",errcode);
    break;
  default:
    sprintf((char*)errbuf, "Warning - error status %d",status);
    break;
  }

  OCIExtProcRaiseExcpWithMsg(handles->extProcCtx, 29400, errbuf,
    strlen((char*)errbuf));

  return -1;
}

