#include "Container_simple.hpp"


/**
 * Erzeugt einen neuen Container mit
 * - name, schema, modus (N,W,R,D)
 */
Container_simple::Container_simple(string p_name, string p_schema, char p_modus): isLoaded(false), modus(p_modus){
	container_idxname = p_name;
	container_idxschema = p_schema;
	if(global_var_use_odci){
		container_file_name = ODCI_DATA_SUBDIR + "container_" + container_idxname + "_" + container_idxschema + ".file";
		container_indexfile_name = ODCI_DATA_SUBDIR + "containerindex_" + container_idxname + "_" + container_idxschema + ".file";
	}else{
		container_file_name = DATA_SUBDIR + "container_" + container_idxname + "_" + container_idxschema + ".file";
		container_indexfile_name = DATA_SUBDIR + "containerindex_" + container_idxname + "_" + container_idxschema + ".file";
	}

	switch (modus){
		case 'N':
			filecreate(container_file_name);
			filecreate(container_indexfile_name);
			break;
		case 'W':
			checkCreateFile(); // member
			break;
		case 'R':
			checkCreateFile(); // member
			// index laden --> wird nur beim Lesen geladen, ansonsten immer geschrieben
			break;
		case 'D':
			// file löschen!
			if(remove(container_file_name.c_str()) == -1){
				perror( "Could not delete container file"  );
				// na egal, wird bei bedarf eh überschrieben :-)
			}
			if(remove(container_indexfile_name.c_str()) == -1){
				perror( "Could not delete container index file"  );
				// na egal, wird bei bedarf eh überschrieben :-)
			}
			return;
			break;
		default:
			cerr << "Container_simple::Container_simple(,,) switch default (das kann ja nicht sein... :@ )" << endl;
			exit(-1);

	}
	openContainerFile();

	// layz durch isLoaded
	// file ist offen; wenn nicht neues File, dann altes lesen
	//if('W' == modus){
	//	readContainer();
	//}
}

Container_simple::~Container_simple(){
/*	cerr << "~Container_simple()..." << endl;
	save();
	cerr << "~Container_simple() end" << endl;
*/
}

/**
 * wenn die files nicht existieren werden sie angelegt
 *
 * */
void Container_simple::checkCreateFile(){
	FILE * f = fopen(container_file_name.c_str(), "r");
	FILE * fi = fopen(container_indexfile_name.c_str(), "r");
	if(!f){
		f = fopen(container_file_name.c_str(), "w");
		fi = fopen(container_indexfile_name.c_str(), "w");
	}
	if(f) fclose(f);
	if(fi) fclose(fi);
}

/**
 * Öffnet die Container-Datei
 *
 */
void Container_simple::openContainerFile(){
	container_file.open(container_file_name.c_str(), ios::in | ios::out | ios::binary);
	if(!container_file.is_open()){
		cerr << "containerfile not open (das ist ein schwerwiegender Fehler)" << endl;
		exit(-1);
	}
	container_indexfile.open(container_indexfile_name.c_str(), ios::in | ios::out | ios::binary);
	if(!container_indexfile.is_open()){
		cerr << "containerindexfile not open (das ist ein schwerwiegender Fehler)" << endl;
		exit(-1);
	}
}

/**
 * Gibt die Dateigröße des Containers zurück
 */
int Container_simple::getContainerFileSize(){
	container_file.seekg(0, ios::end);
	return container_file.tellg();
}
/**
 * Gibt die Dateigröße des Indexfiles zurück
 */
int Container_simple::getContainerIndexFileSize(){
	container_indexfile.seekg(0, ios::end);
	return container_indexfile.tellg();
}

/**
 * Fügt ein Paar <key, TID> in den Container ein
 *
 */
void Container_simple::insert(KEY_TYPE key, string& p_TID){

	//assert(p_TID.length() == CONTAINER_TID_SIZE);
	if(!isLoaded){readContainer();isLoaded = true;}

	ContainerPair containerPair(key, p_TID);
	container.insert(containerPair);
}

/**
 * Löscht alle Einträge mit 'key'
 */
void Container_simple::erase(KEY_TYPE key){
	if(!isLoaded){readContainer();isLoaded = true;}
	container.erase(key);
}

/**
 * Selektives löschen. Nur wenn die TID auch übereinstimmt wird gelöscht.
 */
void Container_simple::erase(KEY_TYPE key, string& p_TID){
	if(!isLoaded){readContainer();isLoaded = true;}
	ContainerBlockIteratorPair it_pair = container.equal_range(key);
	for(ContainerBlockIterator it = it_pair.first; it != it_pair.second; ++it){
		if(it->second == p_TID){
			container.erase(it);
			return;
		}
	}
}

/**
 * Existiert noch ein Schlüssel?
 */
bool Container_simple::find(KEY_TYPE key){ // wenn ein Schlüssel vorhanden ist, dann true
	if(!isLoaded){readContainer();isLoaded = true;}
	return container.end() != container.find(key);

}

/**
 *  Holt alle rowids für einen Schlüssel
 */
void Container_simple::get(StringVector& sv, KEY_TYPE key){
	if(modus == 'R' && !isLoaded){
		// lesemodus --> checken, ob der index geladen ist, dann Zugriff über den Index
		// --> kurzen block holen
		if(containerindex.size() == 0){
			// nicht geladen
			readContainerIndex();
		}

		// Anfrage an Index, wo die Daten sind
		ContainerBlockIndexIterator cibit = containerindex.lower_bound(key);
		POS_TYPE pos = cibit->second;

		// jetzt nur den Block einlesen
		readContainer(pos);


	}else{
		if(!isLoaded){readContainer();isLoaded = true;}
		ContainerBlockIteratorPair ret = container.equal_range(key);
		for(ContainerBlockIterator it = ret.first;it!=ret.second; ++it){
			sv.push_back((*it).second);
		}
	}
}

/**
 * holt eine Range von ... bis aus dem Container
 */
void Container_simple::getRange(StringVector& sv, KEY_TYPE key_from, KEY_TYPE key_to){
	if(!isLoaded){readContainer();isLoaded = true;}
	//cerr << "getRange(.., " << key_from << ", " << key_to << ")" << endl;
	if(key_from == key_to){
		get(sv, key_from);
		return;
	}
	if(key_from > key_to){
		swap(key_from, key_to);
	}
	ContainerBlockIterator it_from = container.lower_bound(key_from);
	ContainerBlockIterator it_to = container.upper_bound(key_to);
	for(ContainerBlockIterator it = it_from;it!=it_to; ++it){
		//cerr << ".";
		sv.push_back((*it).second);
	}
}

/**
 * Für die Pattern-Suche --> da kommt ein Vector mit vielen Ranges zurück (natürlich sortiert...)
 */
void Container_simple::getRange(StringVector& sv, KeyPairVector& kpv){
	if(!isLoaded){readContainer();isLoaded = true;}
	//cerr << "Container_simple::getRange(sv, kpv)";
	KEY_TYPE key_from;
	KEY_TYPE key_to;
	ContainerBlockIterator it_from;
	ContainerBlockIterator it_to;
	for(KeyPairVector::iterator it = kpv.begin(); it != kpv.end(); ++it){
		key_from = (*it).first;
		key_to   = (*it).second;
		if(key_from == key_to){
			get(sv, key_from);
		}else{
			it_from = container.lower_bound(key_from);
			it_to   = container.upper_bound(key_to);
			for(ContainerBlockIterator inner_it = it_from;inner_it!=it_to; ++inner_it){
				//cerr << ".";
				sv.push_back((*inner_it).second);
			}
		}
	}
	//cerr << "Container_simple::getRange(sv, kpv) END";
}



int Container_simple::getNumberOfDistinctKeys(){
	if(!isLoaded){readContainer();isLoaded = true;}
	KEY_TYPE lastKey = PTREE_MIN -1;
	KEY_TYPE curKey = 0;
	int count = 0;

	for(ContainerBlockIterator it=container.begin(); it!=container.end();++it){
		curKey = (*it).first;
		if(curKey != lastKey) ++count;
		lastKey = curKey;
	}
	return count;
}

/**
 * ersetzt alle Pairs mit 'oldKey' durch 'newKey'
 */
void Container_simple::updateKey(KEY_TYPE oldKey, KEY_TYPE newKey){
	if(modus=='R'){cerr << "Fehler: falscher Modus!" << endl;exit(-1);return;}
	if(!isLoaded){readContainer();isLoaded = true;}
	ContainerBlockIteratorPair ret(container.equal_range(oldKey));
	// alte Elemente in den Vector kopieren
	vector<ContainerPair> temp_vector (ret.first, ret.second);
	// aus mmap löschen
	container.erase(oldKey);

	// jetzt wieder alle mit dem neuen Key einfügen
	for(vector<ContainerPair>::iterator it = temp_vector.begin(); it!=temp_vector.end();++it){
		ContainerPair temp_pair = (*it);
		temp_pair.first = newKey;
		container.insert(temp_pair);
	}
}


//  // soll sich um den massenhaften update der Keys kümmern
/**
 * Kopier die ContainerPaare in einen neuen Container und tauscht währenddessen die Keys aus.
 * Nutzt aus, daß sowohl der Container als auch die KeyListe sortiert sind und die Anfänge immer übereinstimmen.
 * Die Eingabecontainer werden stetig geleert, wodurch der Platz auch wieder freigegeben werden sollte.
 *
 * map_alterkeys muß für _alle_ keys die neuen Werte enthalten; also genau so, wie es die
 *
 */
void Container_simple::updateKeys(AlterKeysMap& map_alterkeys){
	if(modus=='R'){cerr << "Fehler: falscher Modus!" << endl;exit(-1);return;}
	if(!isLoaded){readContainer();isLoaded = true;}
	ContainerBlock newContainer;
	while(!container.empty()){
		ContainerPair cp = *(container.begin());
		if(cp.first != map_alterkeys.begin()->first){
			map_alterkeys.erase(map_alterkeys.begin());
		}
		cp.first = map_alterkeys.begin()->second;
		newContainer.insert(newContainer.end(), cp);
		container.erase(container.begin());
	}

	// amp_alterkeys wird im Index gelöscht (wurde dort auch angefordert)
	//map_alterkeys.clear();
	// the swap trick :-)
	//AlterKeysMap(*map_alterkeys).swap(*map_alterkeys);

	newContainer.swap(container); // quasi copy, soll nur schneller sein...
}

/**
 * Holt zu einem vorhandenen Key den nächstkleineren.
 * Zu einem nichtvorhandenen Key den größten, der kleiner ist.
 * 0, wenn der Key kleiner als der kleinste ist
 * (wird nicht gebraucht)
 */
KEY_TYPE Container_simple::getPreviousKey(KEY_TYPE key){
	if(!isLoaded){readContainer();isLoaded = true;}
	//if(container.size() == 0){
	if(container.empty()){
		// sind keine Keys vorhanden --> key ist auf jeden fall der kleinste
		return 0;
	}

	// bekomme entweder it auf ersten Key oder it auf nächgrößeren zurück
	ContainerBlockIterator it = container.lower_bound(key);

	if(it == container.end()){
		// key ist größer als der größte Key
		--it;
		return (*it).first;
	}

	if(key == (*it).first){
		// key ist vorhanden
		if(it == container.begin()){
			//key ist der kleinste key
			return 0;
		}
		// lower_bound hat den anfang des Bereichs geliefert
		// gebe also den nächstkleineren zurück, da it != begin()
		--it;
		return (*it).first;
	}

	// hier bin ich also beim nächstgrößerern --> nächstkleineren holen
	if(it == container.begin()){
		// bin am Anfang --> key ist also kleiner als der kleinste
		return 0;
	}else{
		// bin irgendwo beim ersten nächstgrößeren --> gebe nächstkleineren zurück
		--it;
		return (*it).first;
	}
}

/**
 * Holt zu einem vorhandenen Key den nächstkleineren.
 * Zu einem nichtvorhandenen Key den größten, der kleiner ist.
 * 0, wenn der Key kleiner als der kleinste ist
 * (nicht gebraucht)
 */
KEY_TYPE Container_simple::getNextKey(KEY_TYPE key){
	if(!isLoaded){readContainer();isLoaded = true;}
	if(container.empty()){
		// sind keine Keys vorhanden --> key ist auf jeden fall der kleinste
		return 0;
	}

	// bekomme entweder it auf ersten Key oder it auf nächgrößeren zurück
	ContainerBlockIterator it = container.lower_bound(key);

	if(it == container.end()){
		// key ist größer als der größte Key
		return 0;
	}

	if(key == (*it).first){
		// key ist vorhanden
		// schaue mal nach dem Nachfolger...
		KEY_TYPE key_next = key+1;
		ContainerBlockIterator it_next = container.lower_bound(key_next);
		if(it_next == container.end()){
			// einen Nachfolger gibt's also nicht...
			return 0;
		}else{
			// das muß der Nachfolger sein
			return (*it_next).first;
		}
	}
	return 0;
}

///**
// * Gibt den Container auf cout aus.
// */
//void Container_simple::output_container(){
//	if(!isLoaded){readContainer();isLoaded = true;}
//	for(ContainerBlockIterator it = container.begin(); it != container.end(); ++it){
//		cout << "<" << (*it).first << ", " << (*it).second << ">" << endl;
//	}
//}

/**
 * Schreibt den Container in ein Array (char*)
 */
char * Container_simple::containerToCharArray(ContainerBlock& cb){
	if(!isLoaded){readContainer();isLoaded = true;}
	//cerr << "Container_simple::containerToCharArray() start" << endl;
	if(cb.empty()){
		return NULL;
	}
	char * array = new char[cb.size() * CONTAINER_PAIRSIZE];
	int pos = 0;
	KEY_TYPE mInt = 0;
	for(ContainerBlockIterator it = container.begin(); it != container.end(); ++it){
		//cerr << "pos == " << pos << endl;
		mInt = (*it).first;
		memcpy((void*)(array+pos), (void*)&mInt, sizeof(KEY_TYPE));
		pos += sizeof(KEY_TYPE); // 4
		memcpy((void*)(array+pos), (void*)(it->second.c_str()), CONTAINER_TID_SIZE);
		pos += CONTAINER_TID_SIZE;
	}
	//cerr << "Container_simple::containerToCharArray() end" << endl;
	return array;
}


/**
 * Schreibt den Container ins File rein
 */
bool Container_simple::writeContainer(){
	//cerr << "Container_simple::writeContainer() start" << endl;

	// Index
	// größe pro EIntrag: 8+4 Bytes (12)
	// alle 2048 Schlüsselpaare ein Eintrag
	// container scannen, dann einträge in index schreiben --> plain als array
	int indexArraySize = (int)container.size() / (int)2048 + (container.size() % 2048 > 0 ? 1 : 0);
	indexArraySize *= 12;
	//cerr << "indexArraySize == " << indexArraySize << endl;
	char * indexArray = new char[indexArraySize];
	char * pointer = indexArray;
	int counter = 0;
	KEY_TYPE lastkey = PTREE_NULLKEY;
	//cerr << "start" << endl;
	for(ContainerBlockIterator it = container.begin(); it != container.end(); ++it){
		if(counter % 2048 == 0){
			KEY_TYPE key = it->first;
			POS_TYPE pos = counter * 26;
			memcpy(pointer, (char*)&key, sizeof(KEY_TYPE));
			pointer += sizeof(KEY_TYPE);
			memcpy(pointer, (char*)&pos, sizeof(POS_TYPE));
			pointer += sizeof(POS_TYPE);
			//lastkey = key;
		}
		++counter;
	}
	// jetzt den Index in ein charArray speichern
	container_indexfile.close();
	container_indexfile.open(container_indexfile_name.c_str(), ios::trunc | ios::out | ios::binary);
	container_indexfile.seekp(0, ios::beg );
	container_indexfile.write(indexArray,indexArraySize); // sicher ist sicher...
	container_indexfile.flush();
	container_indexfile.close();
	container_indexfile.open(container_indexfile_name.c_str(), ios::in | ios::out | ios::binary);
	delete [] indexArray;


	char * array = containerToCharArray(container);
	if(array != NULL){
		container_file.close();
		container_file.open(container_file_name.c_str(), ios::trunc | ios::out | ios::binary);
		container_file.seekp(0, ios::beg );
		container_file.write(array,container.size()*(CONTAINER_PAIRSIZE)); // sicher ist sicher...
		container_file.flush();
		container_file.close();
		container_file.open(container_file_name.c_str(), ios::in | ios::out | ios::binary);
		//free(array);
		delete [] array;
	}
	//cerr << "Container_simple::writeContainer() end" << endl;
	return true;
}

/**
 * Liest den Inhalt des Arrays (char*) in den ContainerBlock cb ein
 *
 */
void Container_simple::charArrayToContainerBlock(ContainerBlock& cb, char * charArray, int size){
		//int countPairs = size / CONTAINER_PAIRSIZE;

		KEY_TYPE key = PTREE_NULLKEY;
		char data[CONTAINER_TID_SIZE];
		int pos = 0;
		ContainerPair containerPair;
		int count = 0;

		// Bedingung hierfür ist, daß die leeren Positionen mit Nullen gefüllt sind
		while(pos < size){
			memcpy((void*)&key, (void*)(charArray+pos), sizeof(KEY_TYPE));
			//if(key==0) break; // kann weg! => hindert nur
			containerPair.first = key;
			pos += sizeof(KEY_TYPE); // 4
			memcpy((char*)&data, (char*)(charArray+pos), CONTAINER_TID_SIZE /* 16 */);
			containerPair.second = string((char*)&data,CONTAINER_TID_SIZE /* 16 */); // neuen String gleich von hier erzeugen
			cb.insert(containerPair); // an den Zeiger anfügen
			pos += CONTAINER_TID_SIZE;
			++count;
		}
		//cerr << "count == " << count << endl;
}


/**
 * Liest den Container aus dem File
 * - die optionale Startposition gibt an, von wo aus ein Block aus 2048 rowid-key-Paaren gelesen werden soll
 *
 */
void Container_simple::readContainer(int startPos){
	if(startPos == -1){
		int container_filesize = getContainerFileSize();
		//cerr << "container_filesize == " << container_filesize << endl;
		if(container_filesize == 0) {
			return;
		}

		char * array = (char*)malloc(container_filesize);
		container_file.seekg(0,ios::beg);
		container_file.read(array, container_filesize);
		//cerr << "container_file.gcount() == " <<  container_file.gcount() << endl;

		container.clear(); // vorher lieber alles löschen
		charArrayToContainerBlock(container, array, container_filesize);
		free(array);
	}else{
		int container_filesize = getContainerFileSize() - startPos;
		//cerr << "container_filesize == " << container_filesize << endl;
		if(container_filesize < 0) {
			return;
		}
		if(container_filesize > (2048*(26))){
			container_filesize = (2048*(26));
		}

		char * array = (char*)malloc(container_filesize);
		container_file.seekg(startPos,ios::beg);
		container_file.read(array, container_filesize);
		//cerr << "container_file.gcount() == " <<  container_file.gcount() << endl;

		container.clear(); // vorher lieber alles löschen
		charArrayToContainerBlock(container, array, container_filesize);
		// die gesuchte rowid ist jetzt in dem eingelesenen Block drin
		free(array);
	}
}

/**
 * Liest den Index aus dem IndexFile
 */
void Container_simple::readContainerIndex(){
	int index_filesize = getContainerIndexFileSize();
	if(index_filesize == 0) return;
	char * array = (char*)malloc(index_filesize);
	char * pointer = array;
	container_indexfile.seekg(0, ios::beg);
	container_indexfile.read(array, index_filesize);
	containerindex.clear();

	int indizes = index_filesize / (sizeof(KEY_TYPE) + sizeof(POS_TYPE));
	KEY_TYPE key = PTREE_NULLKEY;
	POS_TYPE pos = PTREE_NULLPOS;

	for(int i=0; i<indizes;++i){
		memcpy((char*)&key,pointer, sizeof(KEY_TYPE));
		pointer += sizeof(KEY_TYPE);
		memcpy((char*)&pos,pointer, sizeof(POS_TYPE));
		pointer += sizeof(POS_TYPE);
		ContainerIndexPair cip(key,pos);
		containerindex.insert(cip);
	}

	free(array);
}

/*
int main(){

	Container_simple myCont(string("mytestcontainer"));
	//int r = 0;
	for(int i=1;i<=5;++i){
		myCont.insert(i,"0123456789abcdef");
		myCont.insert(i,"1123456789abcdef");
	}
	myCont.output_container();

	cout << "updateKey()" << endl;
	myCont.updateKey(2,8);

	myCont.output_container();

	cerr << "myCont.getPreviousKey(5) == " << myCont.getPreviousKey(5) << endl;
	cerr << "myCont.getNextKey(5)     == " << myCont.getNextKey(5) << endl;

	StringVector sv;
	myCont.getRange(sv,3,7);
	for(StringVector::iterator it=sv.begin();it!=sv.end();++it){
		cout << (*it) << endl;
	}

	if(true){
		// updateKeys(AlterKeysMap& map_alterkeys){
		AlterKeysMap map_alterkeys;
		map_alterkeys.insert(KeyPair(1,111));
		map_alterkeys.insert(KeyPair(3,333));
		map_alterkeys.insert(KeyPair(4,444));
		map_alterkeys.insert(KeyPair(5,555));
		map_alterkeys.insert(KeyPair(8,888));

		myCont.updateKeys(map_alterkeys);
	}

	myCont.output_container();

//	myCont.save();

//	myCont.load();

//	myCont.save();

	return 0;
}
*/

