/*
 * Decompiled with CFR 0.152.
 */
package seth.seth.eval;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import seth.seth.eval.Entity;
import seth.seth.eval.EvaluateNER;
import seth.seth.eval.Performance;

public class EvaluateWei {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            EvaluateWei.printErrorMessage();
        }
        String goldstandardFile = args[0];
        String predictFile = args[1];
        Map<Integer, List<Entity>> predictMap = EvaluateNER.readPredictions(predictFile);
        Map<Integer, List<Entity>> goldstandardMap = EvaluateWei.readGoldStandard(goldstandardFile);
        HashSet<Integer> allPmids = new HashSet<Integer>(goldstandardMap.keySet());
        for (int i : goldstandardMap.keySet()) {
            allPmids.add(i);
        }
        Performance performance = new Performance();
        Iterator i$ = allPmids.iterator();
        while (i$.hasNext()) {
            int pmid = (Integer)i$.next();
            List<Entity> predicted = predictMap.get(pmid);
            List<Entity> goldstandard = goldstandardMap.get(pmid);
            if (predicted != null) {
                for (Entity entity : predicted) {
                    if (goldstandard.contains(entity)) {
                        performance.addTP();
                        goldstandard.remove(entity);
                        continue;
                    }
                    performance.addFP();
                    System.out.println("FP" + pmid + " " + entity);
                }
            }
            performance.addFN(goldstandard.size());
            for (Entity entity : goldstandard) {
                System.out.println("FN" + pmid + " " + entity);
            }
        }
        performance.calculate();
        DecimalFormat df = new DecimalFormat("0.000");
        System.err.println("TP = " + performance.getTP() + "; FP=" + performance.getFP() + "; FN=" + performance.getFN());
        System.err.println("Precision " + df.format(performance.getPrecision()));
        System.err.println("Recall " + df.format(performance.getRecall()));
        System.err.println("F1 " + df.format(performance.getF1()));
    }

    public static Map<Integer, List<Entity>> readGoldStandard(String goldFolder) throws IOException {
        System.out.println("Reading goldstandard annotations from " + goldFolder);
        HashMap<Integer, List<Entity>> entityMap = new HashMap<Integer, List<Entity>>();
        Pattern p = Pattern.compile("[1-9][0-9]+\t");
        BufferedReader br = new BufferedReader(new FileReader(goldFolder));
        while (br.ready()) {
            String line = br.readLine();
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            int pmid = Integer.parseInt(m.group().trim());
            String[] array = line.split("\t");
            if (array.length != 6) {
                throw new RuntimeException("larifari");
            }
            Entity entity = new Entity("IDx", "SNP", Integer.parseInt(array[1]), Integer.parseInt(array[2]), array[3], "goldstandard");
            if (entityMap.containsKey(pmid)) {
                ((List)entityMap.get(pmid)).add(entity);
                continue;
            }
            ArrayList<Entity> tmpList = new ArrayList<Entity>();
            tmpList.add(entity);
            entityMap.put(pmid, tmpList);
        }
        return entityMap;
    }

    private static void printErrorMessage() {
        System.err.println("ERROR: Invalid number of input parameters. Execution requires two input parameters.");
        System.err.println("PARAMETERS:  goldstandard SETH-prediction");
        System.exit(1);
    }
}

