/*
 * Decompiled with CFR 0.152.
 */
package seth.seth.eval;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import seth.seth.eval.Entity;
import seth.seth.eval.Performance;

public class EvaluateNER {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            EvaluateNER.printErrorMessage();
        }
        String predictFile = args[0];
        String yearFile = args[1];
        String goldFolder = args[2];
        Map<Integer, List<Entity>> predictMap = EvaluateNER.readPredictions(predictFile);
        Map<Integer, Integer> yearMap = EvaluateNER.readYearFile(yearFile);
        Map<Integer, List<Entity>> goldstandardMap = EvaluateNER.readGoldStandard(goldFolder);
        HashMap<Integer, Performance> mfPerformance = new HashMap<Integer, Performance>(21);
        HashMap<Integer, Performance> sethPerformance = new HashMap<Integer, Performance>(21);
        HashMap<Integer, Performance> regexPerformance = new HashMap<Integer, Performance>(21);
        HashMap<Integer, Performance> dbSNPPerformance = new HashMap<Integer, Performance>(21);
        for (int year : yearMap.values()) {
            mfPerformance.put(year, new Performance());
            sethPerformance.put(year, new Performance());
            regexPerformance.put(year, new Performance());
            dbSNPPerformance.put(year, new Performance());
        }
        Performance performance = new Performance();
        for (int pmid : goldstandardMap.keySet()) {
            List<Entity> predicted = predictMap.get(pmid);
            List<Entity> goldstandard = goldstandardMap.get(pmid);
            if (predicted != null) {
                for (Entity entity : predicted) {
                    if (goldstandard.contains(entity)) {
                        performance.addTP();
                        if (entity.getTool().equals("MF")) {
                            ((Performance)mfPerformance.get(yearMap.get(pmid))).addTP();
                        } else if (entity.getTool().equals("SETH")) {
                            ((Performance)sethPerformance.get(yearMap.get(pmid))).addTP();
                        } else if (entity.getTool().equals("REGEX")) {
                            ((Performance)regexPerformance.get(yearMap.get(pmid))).addTP();
                        } else if (entity.getTool().equals("DBSNP")) {
                            ((Performance)dbSNPPerformance.get(yearMap.get(pmid))).addTP();
                        } else {
                            throw new RuntimeException("Unknown tool " + entity.getTool());
                        }
                        goldstandard.remove(entity);
                        continue;
                    }
                    performance.addFP();
                    System.out.println("FP" + pmid + " " + entity);
                    if (entity.getTool().equals("MF")) {
                        ((Performance)mfPerformance.get(yearMap.get(pmid))).addFP();
                        continue;
                    }
                    if (entity.getTool().equals("SETH")) {
                        ((Performance)sethPerformance.get(yearMap.get(pmid))).addFP();
                        continue;
                    }
                    if (entity.getTool().equals("REGEX")) {
                        ((Performance)regexPerformance.get(yearMap.get(pmid))).addFP();
                        continue;
                    }
                    if (entity.getTool().equals("DBSNP")) {
                        ((Performance)dbSNPPerformance.get(yearMap.get(pmid))).addFP();
                        continue;
                    }
                    throw new RuntimeException("Unknown tool " + entity.getTool());
                }
            }
            performance.addFN(goldstandard.size());
            for (Entity entity : goldstandard) {
                System.out.println("FN" + pmid + " " + entity);
            }
        }
        performance.calculate();
        DecimalFormat df = new DecimalFormat("0.000");
        System.err.println("Precision " + df.format(performance.getPrecision()));
        System.err.println("Recall " + df.format(performance.getRecall()));
        System.err.println("F1 " + df.format(performance.getF1()));
        ArrayList years = new ArrayList(mfPerformance.keySet());
        Collections.sort(years);
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File("result.tsv")));
        Iterator i$ = years.iterator();
        while (i$.hasNext()) {
            int year = (Integer)i$.next();
            bw.append(year + "\t" + ((Performance)mfPerformance.get(year)).getTP() + "\t" + "MF\n");
            bw.append(year + "\t" + ((Performance)sethPerformance.get(year)).getTP() + "\t" + "SETH\n");
            bw.append(year + "\t" + ((Performance)regexPerformance.get(year)).getTP() + "\t" + "REGEX\n");
            bw.append(year + "\t" + ((Performance)dbSNPPerformance.get(year)).getTP() + "\t" + "DBSNP\n");
        }
        bw.close();
    }

    private static Map<Integer, Integer> readYearFile(String file) throws IOException {
        HashMap<Integer, Integer> result2 = new HashMap<Integer, Integer>();
        BufferedReader br = new BufferedReader(new FileReader(new File(file)));
        while (br.ready()) {
            Object[] array = br.readLine().split("\t");
            if (array.length != 2) {
                throw new RuntimeException("Error in" + Arrays.toString(array));
            }
            int year = Integer.parseInt(array[0]);
            int pmid = Integer.parseInt(array[1]);
            if (result2.containsKey(pmid)) {
                throw new RuntimeException("Duplicate pmid " + pmid);
            }
            result2.put(pmid, year);
        }
        System.out.println(result2.size() + " year mappings loaded");
        return result2;
    }

    public static Map<Integer, List<Entity>> readPredictions(String corpusResult) throws IOException {
        System.out.println("Reading predictions from " + corpusResult);
        HashMap<Integer, List<Entity>> entityMap = new HashMap<Integer, List<Entity>>();
        BufferedReader br = new BufferedReader(new FileReader(new File(corpusResult)));
        while (br.ready()) {
            String[] array = br.readLine().split("\t");
            int pmid = Integer.parseInt(array[0]);
            Entity entity = new Entity("", "SNP", Integer.parseInt(array[1]), Integer.parseInt(array[2]), array[3], array[4]);
            if (entityMap.containsKey(pmid)) {
                ((List)entityMap.get(pmid)).add(entity);
                continue;
            }
            ArrayList<Entity> tmpList = new ArrayList<Entity>();
            tmpList.add(entity);
            entityMap.put(pmid, tmpList);
        }
        int sum2 = 0;
        Iterator i$ = entityMap.keySet().iterator();
        while (i$.hasNext()) {
            int pmid = (Integer)i$.next();
            sum2 += ((List)entityMap.get(pmid)).size();
        }
        System.out.println(entityMap.size() + " articles with " + sum2 + " predictions loaded");
        return entityMap;
    }

    public static Map<Integer, List<Entity>> readGoldStandard(String goldFolder) throws IOException {
        System.out.println("Reading goldstandard annotations from " + goldFolder);
        File folder = new File(goldFolder);
        if (folder.isFile()) {
            throw new RuntimeException("Provide folder");
        }
        HashMap<Integer, List<Entity>> entityMap = new HashMap<Integer, List<Entity>>();
        for (File file : folder.listFiles()) {
            if (!file.getName().endsWith("ann")) continue;
            int pmid = Integer.parseInt(file.getName().substring(0, file.getName().indexOf(".")));
            BufferedReader br = new BufferedReader(new FileReader(file));
            while (br.ready()) {
                String line = br.readLine();
                String[] array = line.split("\t");
                String[] annotation = array[1].split(" ");
                if (!annotation[0].equals("SNP") && !annotation[0].equals("mutation")) continue;
                Entity entity = new Entity(array[0], annotation[0], Integer.parseInt(annotation[1]), Integer.parseInt(annotation[2]), array[2], "goldstandard");
                if (entityMap.containsKey(pmid)) {
                    ((List)entityMap.get(pmid)).add(entity);
                    continue;
                }
                ArrayList<Entity> tmpList = new ArrayList<Entity>();
                tmpList.add(entity);
                entityMap.put(pmid, tmpList);
            }
            if (entityMap.containsKey(pmid)) continue;
            entityMap.put(pmid, new ArrayList());
        }
        int sum2 = 0;
        Iterator i$ = entityMap.keySet().iterator();
        while (i$.hasNext()) {
            int pmid = (Integer)i$.next();
            sum2 += ((List)entityMap.get(pmid)).size();
        }
        System.out.println(entityMap.size() + " articles with " + sum2 + " annotations loaded");
        return entityMap;
    }

    private static void printErrorMessage() {
        System.err.println("ERROR: Invalid number of input parameters. Execution requires three input parameters.");
        System.err.println("PARAMETERS:  goldFolder SETH-prediction yearMapping");
        System.exit(1);
    }
}

