/*
 * Decompiled with CFR 0.152.
 */
package seth.seth.eval;

import de.hu.berlin.wbi.objects.MutationMention;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import seth.SETH;

public class ApplyNerToVerspoor {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            ApplyNerToVerspoor.printErrorMessage();
        }
        File inFolder = new File(args[0]);
        String regexFile = args[1];
        String outFile = args[2];
        SETH seth = new SETH(regexFile, true, true);
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outFile)));
        for (File file : inFolder.listFiles()) {
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(file));
            while (br.ready()) {
                sb.append(br.readLine());
                sb.append("\n");
            }
            br.close();
            List<MutationMention> mentionList = seth.findMutations(sb.toString());
            for (MutationMention mm : mentionList) {
                String id = file.getName().substring(0, file.getName().indexOf("."));
                bw.append(id + "\t" + mm.getStart() + "\t" + mm.getEnd() + "\t" + mm.getText() + "\t" + (Object)((Object)mm.getTool()) + "\n");
            }
        }
        bw.close();
    }

    private static void printErrorMessage() {
        System.err.println("ERROR: Invalid number of input parameters. Execution requires three  input parameters.");
        System.err.println("PARAMETERS:  corpusFolder regexFile outputFile");
        System.exit(1);
    }
}

