/*
 * Decompiled with CFR 0.152.
 */
package seth.seth.eval;

import de.hu.berlin.wbi.objects.MutationMention;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import seth.SETH;

public class ApplyNERToWei {
    private static Pattern titlePattern = Pattern.compile("^[1-9][0-9]+\\|t\\|.*");
    private static Pattern abstractPattern = Pattern.compile("^[1-9][0-9]+\\|a\\|.*");
    private static Pattern pmidPattern = Pattern.compile("^[1-9][0-9]+");

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            ApplyNERToWei.printErrorMessage();
        }
        String inFile = args[0];
        String regexFile = args[1];
        String outFile = args[2];
        SETH seth = new SETH(regexFile, false, true);
        BufferedReader br = new BufferedReader(new FileReader(inFile));
        String title = null;
        String abstr = null;
        int pmid = 0;
        BufferedWriter bw = new BufferedWriter(new FileWriter(outFile));
        while (br.ready()) {
            String line = br.readLine();
            if (titlePattern.matcher(line).matches()) {
                title = line;
                continue;
            }
            if (abstractPattern.matcher(line).matches()) {
                abstr = line;
                continue;
            }
            if (!line.trim().matches("")) continue;
            Matcher m = pmidPattern.matcher(title);
            m.find();
            pmid = Integer.parseInt(m.group());
            if (!abstr.contains(m.group())) {
                throw new RuntimeException();
            }
            title = title.substring(m.group().length() + 3);
            abstr = abstr.substring(m.group().length() + 3);
            List<MutationMention> titleMutations = seth.findMutations(title);
            List<MutationMention> abstrMutations = seth.findMutations(abstr);
            for (MutationMention mm : titleMutations) {
                bw.append(pmid + "\t" + mm.getStart() + "\t" + mm.getEnd() + "\t" + mm.getText() + "\t" + (Object)((Object)mm.getTool()) + "\n");
            }
            for (MutationMention mm : abstrMutations) {
                bw.append(pmid + "\t" + (title.length() + mm.getStart() + 1) + "\t" + (title.length() + mm.getEnd() + 1) + "\t" + mm.getText() + "\t" + (Object)((Object)mm.getTool()) + "\n");
            }
            title = null;
            abstr = null;
            pmid = 0;
        }
        bw.close();
    }

    private static void printErrorMessage() {
        System.err.println("ERROR: Invalid number of input parameters. Execution requires three  input parameters.");
        System.err.println("PARAMETERS:  corpusFile regexFile outputFile");
        System.exit(1);
    }
}

