/*
 * Decompiled with CFR 0.152.
 */
package seth.seth.eval;

import de.hu.berlin.wbi.objects.MutationMention;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import seth.SETH;

public class ApplyNER {
    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            ApplyNER.printErrorMessage();
        }
        String corpusFile = args[0];
        String regexFile = args[1];
        boolean mutationFinderFormat = Boolean.parseBoolean(args[2]);
        String annotationOutput = args[3];
        SETH seth = new SETH(regexFile, true, !mutationFinderFormat);
        File file = new File(corpusFile);
        if (!file.isFile()) {
            throw new RuntimeException("Provide corpus-file, instead of folder");
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(annotationOutput)));
        while (br.ready()) {
            String line = br.readLine();
            int firstTabIndex = line.indexOf("\t");
            String pmid = line.substring(0, firstTabIndex);
            String text2 = line.substring(firstTabIndex + 1);
            if (mutationFinderFormat) {
                bw.append(pmid);
            }
            List<MutationMention> mutations = seth.findMutations(text2);
            for (MutationMention mutation2 : mutations) {
                if (mutationFinderFormat) {
                    bw.append("\t" + mutation2.getWtResidue() + mutation2.getPosition() + mutation2.getMutResidue());
                    continue;
                }
                if (mutation2.getTool().equals((Object)MutationMention.Tool.SETH)) {
                    bw.append(pmid + "\t" + mutation2.getStart() + "\t" + mutation2.getEnd() + "\t" + mutation2.getText() + "\t" + "SETH");
                    bw.append("\n");
                    continue;
                }
                if (mutation2.getTool().equals((Object)MutationMention.Tool.MUTATIONFINDER)) {
                    bw.append(pmid + "\t" + mutation2.getStart() + "\t" + mutation2.getEnd() + "\t" + mutation2.getText() + "\t" + "MF");
                    bw.append("\n");
                    continue;
                }
                if (mutation2.getTool().equals((Object)MutationMention.Tool.REGEX)) {
                    bw.append(pmid + "\t" + mutation2.getStart() + "\t" + mutation2.getEnd() + "\t" + mutation2.getText() + "\t" + "REGEX");
                    bw.append("\n");
                    continue;
                }
                if (mutation2.getTool().equals((Object)MutationMention.Tool.DBSNP)) continue;
                throw new RuntimeException();
            }
            if (!mutationFinderFormat) continue;
            bw.append("\n");
        }
        br.close();
        bw.close();
        System.out.println("Seth finished");
    }

    private static void printErrorMessage() {
        System.err.println("ERROR: Invalid number of input parameters. Execution requires four input parameters.");
        System.err.println("PARAMETERS:  corpusFile regexFile format outputFile");
        System.exit(1);
    }
}

