/*
 * Decompiled with CFR 0.152.
 */
package seth;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import de.hu.berlin.wbi.objects.MutationMention;
import de.hu.berlin.wbi.objects.UniprotFeature;
import de.hu.berlin.wbi.objects.dbSNP;
import de.hu.berlin.wbi.objects.dbSNPNormalized;
import edu.uchsc.ccp.nlp.ei.mutation.Mutation;
import edu.uchsc.ccp.nlp.ei.mutation.MutationException;
import edu.uchsc.ccp.nlp.ei.mutation.MutationFinder;
import edu.uchsc.ccp.nlp.ei.mutation.PointMutation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import seth.OldNomenclature;
import seth.dbSNPRecognizer;
import seth.ner.wrapper.SETHNER;
import seth.ner.wrapper.Type;

public class SETH {
    private final SETHNER seth;
    private final MutationFinder mf;
    private final OldNomenclature bl;
    private final dbSNPRecognizer snpRecognizer;

    public SETH(String regexFile, boolean exactGrammar, boolean oldNomenclature) {
        this.mf = new MutationFinder(regexFile);
        this.seth = new SETHNER(exactGrammar);
        this.snpRecognizer = new dbSNPRecognizer();
        this.bl = oldNomenclature ? new OldNomenclature() : null;
    }

    public List<MutationMention> findMutations(String text2) {
        HashSet<MutationMention> mutations = new HashSet<MutationMention>();
        mutations.addAll(this.seth.extractMutations(text2));
        mutations.addAll(this.snpRecognizer.extractMutations(text2));
        if (this.bl != null) {
            mutations.addAll(this.bl.extractMutations(text2));
        }
        try {
            Map<Mutation, Set<int[]>> map2 = this.mf.extractMutations(text2);
            for (Mutation mutation2 : map2.keySet()) {
                PointMutation pm = (PointMutation)mutation2;
                for (int[] location : map2.get(mutation2)) {
                    String originalMatch = text2.substring(location[0], location[1]);
                    MutationMention tmpMutation = new MutationMention(location[0], location[1], originalMatch, null, pm.getPosition(), String.valueOf(pm.getWtResidue()), String.valueOf(pm.getMutResidue()), Type.SUBSTITUTION, MutationMention.Tool.MUTATIONFINDER);
                    tmpMutation.setPatternId(pm.getId());
                    mutations.add(tmpMutation);
                }
            }
        }
        catch (MutationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        ArrayList<MutationMention> result2 = new ArrayList<MutationMention>(mutations.size());
        for (MutationMention mm : mutations) {
            boolean contained = false;
            for (MutationMention m : result2) {
                boolean equal = false;
                try {
                    equal = mm.getPosition().equals(m.getPosition()) && mm.getMutResidue().equals(m.getMutResidue()) && mm.getWtResidue().equals(m.getWtResidue());
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
                if (mm.getStart() == m.getStart() && mm.getEnd() == m.getEnd()) {
                    if (mm.getTool() == MutationMention.Tool.SETH && m.getTool() == MutationMention.Tool.DBSNP) {
                        contained = true;
                        break;
                    }
                    if (m.getTool() != MutationMention.Tool.SETH || mm.getTool() != MutationMention.Tool.DBSNP) continue;
                    result2.remove(m);
                    break;
                }
                if (mm.getStart() >= m.getStart() && mm.getEnd() <= m.getEnd() && equal) {
                    contained = true;
                    break;
                }
                if (m.getStart() < mm.getStart() || m.getEnd() > mm.getEnd() || !equal) continue;
                result2.remove(m);
                break;
            }
            if (contained) continue;
            result2.add(mm);
        }
        return result2;
    }

    public static void main(String[] args) throws SQLException, IOException {
        String text2 = "p.A123T and Val158Met";
        SETH seth = new SETH("resources/mutations.txt", true, true);
        List<MutationMention> mutations = seth.findMutations(text2);
        try {
            for (MutationMention mutation2 : mutations) {
                System.out.println(mutation2.toNormalized());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Properties property = new Properties();
        property.loadFromXML(new FileInputStream(new File("myProperty.xml")));
        DatabaseConnection mysql = new DatabaseConnection(property);
        mysql.connect();
        dbSNP.init(mysql, property.getProperty("database.PSM"), property.getProperty("database.hgvs_view"));
        UniprotFeature.init(mysql, property.getProperty("database.uniprot"));
        int gene = 1312;
        List<dbSNP> potentialSNPs = dbSNP.getSNP(gene);
        List<UniprotFeature> features = UniprotFeature.getFeatures(gene);
        for (MutationMention mutation3 : mutations) {
            System.out.println(mutation3);
            mutation3.normalizeSNP(potentialSNPs, features, false);
            List<dbSNPNormalized> normalized = mutation3.getNormalized();
            for (dbSNPNormalized snp : normalized) {
                System.out.println(mutation3 + " --- rs" + snp.getRsID());
            }
        }
    }
}

