/*
 * Decompiled with CFR 0.152.
 */
package seth;

import de.hu.berlin.wbi.objects.MutationMention;
import edu.uchsc.ccp.nlp.ei.mutation.MutationFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import seth.ner.wrapper.Type;

public class OldNomenclature {
    private static final String prefix = "(^|[\\s\\(\\)\\[\\'\"/,])";
    private static final String suffix = "(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))";
    private static final Pattern dnaDeletionPattern = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>(?<pos>[+-]?[1-9][0-9]*(?:\\s?[+-_]\\s?[1-9][0-9]*)?)\\s?(del)\\s?(?<wt>([ATGC]|[0-9])+))(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))");
    private static final Pattern ivsPattern = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>(?<pos>IVS[-]?[1-9][0-9]*\\s?[+-]\\s?[1-9][0-9]*)\\s?(?<wt>[ATGC])\\s?(?:-{0,2}>|\u2192|/|\\\\)\\s?(?<mut>[ATGC]))(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))");
    private static final Pattern protDeletionPattern = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>(?<wt>[CISQMNPKDTFAGHLRWVEYBZJX])(?<pos>[1-9][0-9]*)del)(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))");
    private static final Pattern protDeletionPatternLong = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>(?<wt>CYS|ILE|SER|GLN|MET|ASN|PRO|LYS|ASP|THR|PHE|ALA|GLY|HIS|LEU|ARG|TRP|VAL|GLU|TYR)(?<pos>[1-9][0-9]*)del)(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))", 2);
    private static final Pattern codonDeletionPattern = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>([dD]elta|\u0394)(?<wt>[CISQMNPKDTFAGHLRWVEYBZJX])(?<pos>[1-9][0-9]*))(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))");
    private static final Pattern codonDeletionPattern2 = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>([dD]elta|\u0394)(?<wt>CYS|ILE|SER|GLN|MET|ASN|PRO|LYS|ASP|THR|PHE|ALA|GLY|HIS|LEU|ARG|TRP|VAL|GLU|TYR)(?<pos>[1-9][0-9]*))(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))", 2);
    private static final Pattern dnaInsertionPattern = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>(?<pos>[+-]?[1-9][0-9]*(?:\\s?[+-_]\\s?[1-9][0-9]*)?)\\s?(ins)\\s?(?<mut>([ATGC]|[0-9])+))(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))");
    private static final Pattern frameshiftPattern = Pattern.compile("(^|[\\s\\(\\)\\[\\'\"/,])(?<group>(?<wt>[CISQMNPKDTFAGHLRWVEYBZJX])(?<pos>[1-9][0-9]*)(fs)(?<mut>X[0-9]*)?)(?=([\\.,\\s\\)\\(\\]\\'\":;\\-/]|$))");

    public List<MutationMention> extractMutations(String text2) {
        MutationMention mm;
        int start;
        MutationMention mm2;
        int end;
        int start2;
        ArrayList<MutationMention> result2 = new ArrayList<MutationMention>();
        Matcher m = dnaDeletionPattern.matcher(text2);
        while (m.find()) {
            start2 = m.start(2);
            end = m.start(2) + m.group("group").length();
            mm2 = new MutationMention(start2, end, text2.substring(start2, end), "c.", m.group("pos"), m.group("wt"), null, Type.DELETION, MutationMention.Tool.REGEX);
            result2.add(mm2);
        }
        m = protDeletionPattern.matcher(text2);
        while (m.find()) {
            start2 = m.start(2);
            end = m.start(2) + m.group("group").length();
            mm2 = new MutationMention(start2, end, text2.substring(start2, end), "p.", m.group("pos"), m.group("wt"), null, Type.DELETION, MutationMention.Tool.REGEX);
            result2.add(mm2);
        }
        m = protDeletionPatternLong.matcher(text2);
        while (m.find()) {
            Map<String, String> map2 = MutationFinder.populateAminoAcidThreeToOneLookupMap();
            start = m.start(2);
            int end2 = m.start(2) + m.group("group").length();
            mm = new MutationMention(start, end2, text2.substring(start, end2), "p.", m.group("pos"), map2.get(m.group("wt").toUpperCase()), null, Type.DELETION, MutationMention.Tool.REGEX);
            result2.add(mm);
        }
        m = codonDeletionPattern.matcher(text2);
        while (m.find()) {
            int start3 = m.start(2);
            end = m.start(2) + m.group("group").length();
            MutationMention mm3 = new MutationMention(start3, end, text2.substring(start3, end), "p.", m.group("pos"), m.group("wt"), null, Type.DELETION, MutationMention.Tool.REGEX);
            result2.add(mm3);
        }
        m = codonDeletionPattern2.matcher(text2);
        while (m.find()) {
            Map<String, String> map3 = MutationFinder.populateAminoAcidThreeToOneLookupMap();
            start = m.start(2);
            int end3 = m.start(2) + m.group("group").length();
            mm = new MutationMention(start, end3, text2.substring(start, end3), "p.", m.group("pos"), map3.get(m.group("wt").toUpperCase()), null, Type.DELETION, MutationMention.Tool.REGEX);
            result2.add(mm);
        }
        m = ivsPattern.matcher(text2);
        while (m.find()) {
            int start4 = m.start(2);
            end = m.start(2) + m.group("group").length();
            MutationMention mm4 = new MutationMention(start4, end, text2.substring(start4, end), "p.", m.group("pos"), m.group("wt"), m.group("mut"), Type.SUBSTITUTION, MutationMention.Tool.REGEX);
            result2.add(mm4);
        }
        m = dnaInsertionPattern.matcher(text2);
        while (m.find()) {
            int start5 = m.start(2);
            end = m.start(2) + m.group("group").length();
            MutationMention mm5 = new MutationMention(start5, end, text2.substring(start5, end), "c.", m.group("pos"), null, m.group("mut"), Type.INSERTION, MutationMention.Tool.REGEX);
            result2.add(mm5);
        }
        m = frameshiftPattern.matcher(text2);
        while (m.find()) {
            int start6 = m.start(2);
            end = m.start(2) + m.group("group").length();
            MutationMention mm6 = new MutationMention(start6, end, text2.substring(start6, end), "c.", m.group("pos"), m.group("wt"), m.group("mut"), Type.FRAMESHIFT, MutationMention.Tool.REGEX);
            result2.add(mm6);
        }
        return result2;
    }
}

