/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import scala.actors.threadpool.AbstractExecutorService;
import scala.actors.threadpool.AtomicInteger;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.Callable;
import scala.actors.threadpool.ExecutionException;
import scala.actors.threadpool.ExecutorService;
import scala.actors.threadpool.Future;
import scala.actors.threadpool.LinkedBlockingQueue;
import scala.actors.threadpool.SynchronousQueue;
import scala.actors.threadpool.ThreadFactory;
import scala.actors.threadpool.ThreadPoolExecutor;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.TimeoutException;

public class Executors {
    public static ExecutorService newFixedThreadPool(int n) {
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    }

    public static ExecutorService newFixedThreadPool(int n, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()));
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new FinalizableDelegatedExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), threadFactory));
    }

    public static ExecutorService newCachedThreadPool() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), threadFactory);
    }

    public static ExecutorService unconfigurableExecutorService(ExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        return new DelegatedExecutorService(executorService);
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DefaultThreadFactory();
    }

    public static ThreadFactory privilegedThreadFactory() {
        return new PrivilegedThreadFactory();
    }

    public static Callable callable(Runnable runnable, Object object) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(runnable, object);
    }

    public static Callable callable(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(runnable, null);
    }

    public static Callable callable(final PrivilegedAction privilegedAction) {
        if (privilegedAction == null) {
            throw new NullPointerException();
        }
        return new Callable(){

            public Object call() {
                return privilegedAction.run();
            }
        };
    }

    public static Callable callable(final PrivilegedExceptionAction privilegedExceptionAction) {
        if (privilegedExceptionAction == null) {
            throw new NullPointerException();
        }
        return new Callable(){

            public Object call() throws Exception {
                return privilegedExceptionAction.run();
            }
        };
    }

    public static Callable privilegedCallable(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallable(callable);
    }

    public static Callable privilegedCallableUsingCurrentClassLoader(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        return new PrivilegedCallableUsingCurrentClassLoader(callable);
    }

    private Executors() {
    }

    static class FinalizableDelegatedExecutorService
    extends DelegatedExecutorService {
        FinalizableDelegatedExecutorService(ExecutorService executorService) {
            super(executorService);
        }

        protected void finalize() {
            super.shutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executorService) {
            this.e = executorService;
        }

        @Override
        public void execute(Runnable runnable) {
            this.e.execute(runnable);
        }

        @Override
        public void shutdown() {
            this.e.shutdown();
        }

        @Override
        public List shutdownNow() {
            return this.e.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.e.awaitTermination(l, timeUnit);
        }

        @Override
        public Future submit(Runnable runnable) {
            return this.e.submit(runnable);
        }

        @Override
        public Future submit(Callable callable) {
            return this.e.submit(callable);
        }

        @Override
        public Future submit(Runnable runnable, Object object) {
            return this.e.submit(runnable, object);
        }

        @Override
        public List<Future> invokeAll(Collection collection) throws InterruptedException {
            return this.e.invokeAll(collection);
        }

        @Override
        public List<Future> invokeAll(Collection collection, long l, TimeUnit timeUnit) throws InterruptedException {
            return this.e.invokeAll(collection, l, timeUnit);
        }

        @Override
        public Object invokeAny(Collection collection) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(collection);
        }

        @Override
        public Object invokeAny(Collection collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(collection, l, timeUnit);
        }
    }

    static class PrivilegedThreadFactory
    extends DefaultThreadFactory {
        private final ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        private final AccessControlContext acc = AccessController.getContext();

        PrivilegedThreadFactory() {
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Thread newThread(final Runnable runnable) {
            return super.newThread(new Runnable(){

                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(PrivilegedThreadFactory.this.ccl);
                            runnable.run();
                            return null;
                        }
                    }, PrivilegedThreadFactory.this.acc);
                }
            });
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable runnable) {
            Thread thread2 = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread2.isDaemon()) {
                thread2.setDaemon(false);
            }
            if (thread2.getPriority() != 5) {
                thread2.setPriority(5);
            }
            return thread2;
        }
    }

    static final class PrivilegedCallableUsingCurrentClassLoader
    implements Callable {
        private final ClassLoader ccl;
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        PrivilegedCallableUsingCurrentClassLoader(Callable callable) {
            this.task = callable;
            this.ccl = Thread.currentThread().getContextClassLoader();
            this.acc = AccessController.getContext();
            this.acc.checkPermission(new RuntimePermission("getContextClassLoader"));
            this.acc.checkPermission(new RuntimePermission("setContextClassLoader"));
        }

        public Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ClassLoader classLoader = null;
                    Thread thread2 = Thread.currentThread();
                    try {
                        ClassLoader classLoader2 = thread2.getContextClassLoader();
                        if (PrivilegedCallableUsingCurrentClassLoader.this.ccl != classLoader2) {
                            thread2.setContextClassLoader(PrivilegedCallableUsingCurrentClassLoader.this.ccl);
                            classLoader = classLoader2;
                        }
                        PrivilegedCallableUsingCurrentClassLoader.this.result = PrivilegedCallableUsingCurrentClassLoader.this.task.call();
                        if (classLoader != null) {
                            thread2.setContextClassLoader(classLoader);
                        }
                    }
                    catch (Exception exception) {
                        PrivilegedCallableUsingCurrentClassLoader.this.exception = exception;
                    }
                    finally {
                        if (classLoader != null) {
                            thread2.setContextClassLoader(classLoader);
                        }
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }

    static final class PrivilegedCallable
    implements Callable {
        private final AccessControlContext acc;
        private final Callable task;
        private Object result;
        private Exception exception;

        PrivilegedCallable(Callable callable) {
            this.task = callable;
            this.acc = AccessController.getContext();
        }

        public Object call() throws Exception {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PrivilegedCallable.this.result = PrivilegedCallable.this.task.call();
                    }
                    catch (Exception exception) {
                        PrivilegedCallable.this.exception = exception;
                    }
                    return null;
                }
            }, this.acc);
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }

    static final class RunnableAdapter
    implements Callable {
        final Runnable task;
        final Object result;

        RunnableAdapter(Runnable runnable, Object object) {
            this.task = runnable;
            this.result = object;
        }

        public Object call() {
            this.task.run();
            return this.result;
        }
    }
}

