/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockJUnit4ClassRunner
extends ParentRunner<FrameworkMethod> {
    public BlockJUnit4ClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        EachTestNotifier eachNotifier = this.makeNotifier(method, notifier);
        if (method.getAnnotation(Ignore.class) != null) {
            eachNotifier.fireTestIgnored();
            return;
        }
        eachNotifier.fireTestStarted();
        try {
            this.methodBlock(method).evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    @Override
    protected Description describeChild(FrameworkMethod method) {
        return Description.createTestDescription(this.getTestClass().getJavaClass(), this.testName(method), method.getAnnotations());
    }

    @Override
    protected List<FrameworkMethod> getChildren() {
        return this.computeTestMethods();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.validateConstructor(errors);
        this.validateInstanceMethods(errors);
        this.validateFields(errors);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
        this.validateZeroArgConstructor(errors);
    }

    protected void validateOnlyOneConstructor(List<Throwable> errors) {
        if (!this.hasOneConstructor()) {
            String gripe = "Test class should have exactly one public constructor";
            errors.add(new Exception(gripe));
        }
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
        if (this.hasOneConstructor() && this.getTestClass().getOnlyConstructor().getParameterTypes().length != 0) {
            String gripe = "Test class should have exactly one public zero-argument constructor";
            errors.add(new Exception(gripe));
        }
    }

    private boolean hasOneConstructor() {
        return this.getTestClass().getJavaClass().getConstructors().length == 1;
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (this.computeTestMethods().size() == 0) {
            errors.add(new Exception("No runnable methods"));
        }
    }

    private void validateFields(List<Throwable> errors) {
        for (FrameworkField each : this.ruleFields()) {
            this.validateRuleField(each.getField(), errors);
        }
    }

    private void validateRuleField(Field field2, List<Throwable> errors) {
        if (!MethodRule.class.isAssignableFrom(field2.getType())) {
            errors.add(new Exception("Field " + field2.getName() + " must implement MethodRule"));
        }
        if (!Modifier.isPublic(field2.getModifiers())) {
            errors.add(new Exception("Field " + field2.getName() + " must be public"));
        }
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
    }

    protected String testName(FrameworkMethod method) {
        return method.getName();
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object test2;
        try {
            test2 = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return BlockJUnit4ClassRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, test2);
        statement = this.possiblyExpectingExceptions(method, test2, statement);
        statement = this.withPotentialTimeout(method, test2, statement);
        statement = this.withBefores(method, test2, statement);
        statement = this.withAfters(method, test2, statement);
        statement = this.withRules(method, test2, statement);
        return statement;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test2) {
        return new InvokeMethod(method, test2);
    }

    @Deprecated
    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test2, Statement next2) {
        Test annotation = method.getAnnotation(Test.class);
        return this.expectsException(annotation) ? new ExpectException(next2, this.getExpectedException(annotation)) : next2;
    }

    @Deprecated
    protected Statement withPotentialTimeout(FrameworkMethod method, Object test2, Statement next2) {
        long timeout = this.getTimeout(method.getAnnotation(Test.class));
        return timeout > 0L ? new FailOnTimeout(next2, timeout) : next2;
    }

    @Deprecated
    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List<FrameworkMethod> befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
    }

    @Deprecated
    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List<FrameworkMethod> afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
    }

    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        Statement result2 = statement;
        for (MethodRule each : this.rules(target)) {
            result2 = each.apply(result2, method, target);
        }
        return result2;
    }

    protected List<MethodRule> rules(Object test2) {
        ArrayList<MethodRule> results = new ArrayList<MethodRule>();
        for (FrameworkField each : this.ruleFields()) {
            results.add(this.createRule(test2, each));
        }
        return results;
    }

    private List<FrameworkField> ruleFields() {
        return this.getTestClass().getAnnotatedFields(Rule.class);
    }

    private MethodRule createRule(Object test2, FrameworkField each) {
        try {
            return (MethodRule)each.get(test2);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("How did getFields return a field we couldn't access?");
        }
    }

    private EachTestNotifier makeNotifier(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        return new EachTestNotifier(notifier, description);
    }

    private Class<? extends Throwable> getExpectedException(Test annotation) {
        if (annotation == null || annotation.expected() == Test.None.class) {
            return null;
        }
        return annotation.expected();
    }

    private boolean expectsException(Test annotation) {
        return this.getExpectedException(annotation) != null;
    }

    private long getTimeout(Test annotation) {
        if (annotation == null) {
            return 0L;
        }
        return annotation.timeout();
    }
}

