/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit38ClassRunner
extends Runner
implements Filterable,
Sortable {
    private Test fTest;

    public JUnit38ClassRunner(Class<?> klass) {
        this(new TestSuite((Class<? extends TestCase>)klass.asSubclass(TestCase.class)));
    }

    public JUnit38ClassRunner(Test test2) {
        this.setTest(test2);
    }

    @Override
    public void run(RunNotifier notifier) {
        TestResult result2 = new TestResult();
        result2.addListener(this.createAdaptingListener(notifier));
        this.getTest().run(result2);
    }

    public TestListener createAdaptingListener(RunNotifier notifier) {
        return new OldTestClassAdaptingListener(notifier);
    }

    @Override
    public Description getDescription() {
        return JUnit38ClassRunner.makeDescription(this.getTest());
    }

    private static Description makeDescription(Test test2) {
        if (test2 instanceof TestCase) {
            TestCase tc = (TestCase)test2;
            return Description.createTestDescription(tc.getClass(), tc.getName());
        }
        if (test2 instanceof TestSuite) {
            TestSuite ts = (TestSuite)test2;
            String name = ts.getName() == null ? JUnit38ClassRunner.createSuiteDescription(ts) : ts.getName();
            Description description = Description.createSuiteDescription(name, new Annotation[0]);
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                Description made = JUnit38ClassRunner.makeDescription(ts.testAt(i));
                description.addChild(made);
            }
            return description;
        }
        if (test2 instanceof Describable) {
            Describable adapter = (Describable)((Object)test2);
            return adapter.getDescription();
        }
        if (test2 instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test2;
            return JUnit38ClassRunner.makeDescription(decorator.getTest());
        }
        return Description.createSuiteDescription(test2.getClass());
    }

    private static String createSuiteDescription(TestSuite ts) {
        int count2 = ts.countTestCases();
        String example = count2 == 0 ? "" : String.format(" [example: %s]", ts.testAt(0));
        return String.format("TestSuite with %s tests%s", count2, example);
    }

    @Override
    public void filter(Filter filter2) throws NoTestsRemainException {
        if (this.getTest() instanceof Filterable) {
            Filterable adapter = (Filterable)((Object)this.getTest());
            adapter.filter(filter2);
        } else if (this.getTest() instanceof TestSuite) {
            TestSuite suite = (TestSuite)this.getTest();
            TestSuite filtered = new TestSuite(suite.getName());
            int n = suite.testCount();
            for (int i = 0; i < n; ++i) {
                Test test2 = suite.testAt(i);
                if (!filter2.shouldRun(JUnit38ClassRunner.makeDescription(test2))) continue;
                filtered.addTest(test2);
            }
            this.setTest(filtered);
        }
    }

    @Override
    public void sort(Sorter sorter) {
        if (this.getTest() instanceof Sortable) {
            Sortable adapter = (Sortable)((Object)this.getTest());
            adapter.sort(sorter);
        }
    }

    private void setTest(Test test2) {
        this.fTest = test2;
    }

    private Test getTest() {
        return this.fTest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier fNotifier;

        private OldTestClassAdaptingListener(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        @Override
        public void endTest(Test test2) {
            this.fNotifier.fireTestFinished(this.asDescription(test2));
        }

        @Override
        public void startTest(Test test2) {
            this.fNotifier.fireTestStarted(this.asDescription(test2));
        }

        @Override
        public void addError(Test test2, Throwable t) {
            Failure failure2 = new Failure(this.asDescription(test2), t);
            this.fNotifier.fireTestFailure(failure2);
        }

        private Description asDescription(Test test2) {
            if (test2 instanceof Describable) {
                Describable facade = (Describable)((Object)test2);
                return facade.getDescription();
            }
            return Description.createTestDescription(this.getEffectiveClass(test2), this.getName(test2));
        }

        private Class<? extends Test> getEffectiveClass(Test test2) {
            return test2.getClass();
        }

        private String getName(Test test2) {
            if (test2 instanceof TestCase) {
                return ((TestCase)test2).getName();
            }
            return test2.toString();
        }

        @Override
        public void addFailure(Test test2, AssertionFailedError t) {
            this.addError(test2, (Throwable)((Object)t));
        }
    }
}

