/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class ReferenceableDataSource
implements Referenceable,
Serializable,
ObjectFactory {
    private static final long serialVersionUID = 1872877359127597176L;
    private static final Class[] STRING_ARG = new Class[]{"".getClass()};
    private static final Class[] INT_ARG = new Class[]{Integer.TYPE};
    private static final Class[] BOOLEAN_ARG = new Class[]{Boolean.TYPE};
    private String description;
    private String dataSourceName;
    private String databaseName;
    private String shortDatabaseName;
    private String password;
    private String user;
    private int loginTimeout;
    private transient PrintWriter printer;

    public ReferenceableDataSource() {
        this.update();
    }

    public final synchronized void setDatabaseName(String string2) {
        this.databaseName = string2;
        if (string2 != null && string2.indexOf(";") >= 0) {
            String[] stringArray = string2.split(";");
            this.shortDatabaseName = stringArray[0];
        } else {
            this.shortDatabaseName = string2;
        }
        this.update();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    protected String getShortDatabaseName() {
        return this.shortDatabaseName;
    }

    public final void setDataSourceName(String string2) {
        this.dataSourceName = string2;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDescription(String string2) {
        this.description = string2;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setUser(String string2) {
        this.user = string2;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String string2) {
        this.password = string2;
    }

    public final String getPassword() {
        return this.password;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printer = printWriter;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        String string2 = reference.getClassName();
        Object obj = Class.forName(string2).newInstance();
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Method method;
            RefAddr refAddr = enumeration.nextElement();
            String string3 = refAddr.getType();
            String string4 = (String)refAddr.getContent();
            String string5 = "set" + string3.substring(0, 1).toUpperCase(Locale.ENGLISH) + string3.substring(1);
            try {
                method = obj.getClass().getMethod(string5, STRING_ARG);
                object2 = string4;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = obj.getClass().getMethod(string5, INT_ARG);
                    object2 = Integer.valueOf(string4);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    method = obj.getClass().getMethod(string5, BOOLEAN_ARG);
                    object2 = Boolean.valueOf(string4);
                }
            }
            method.invoke(obj, object2);
        }
        return obj;
    }

    public final Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "org.apache.derby.jdbc.ReferenceableDataSource", null);
        Method[] methodArray = this.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            String string2;
            Method method = methodArray[i];
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || (string2 = method.getName()).length() < 5 || !string2.startsWith("get") || !Integer.TYPE.equals(clazz = method.getReturnType()) && !STRING_ARG[0].equals(clazz) && !Boolean.TYPE.equals(clazz)) continue;
            String string3 = string2.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(string2.substring(4));
            try {
                Object object = method.invoke((Object)this, null);
                if (object == null) continue;
                reference.add(new StringRefAddr(string3, object.toString()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return reference;
    }

    void update() {
    }

    Connection getConnection(String string2, String string3, boolean bl) throws SQLException {
        return null;
    }
}

