/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.jdbc.Driver30;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class EmbeddedXADataSource
extends EmbeddedDataSource
implements XADataSource {
    private static final long serialVersionUID = -5715798975598379738L;
    private transient ResourceAdapter ra;

    public final XAConnection getXAConnection() throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(null, null, false);
        }
        return this.createXAConnection(this.ra, this.getUser(), this.getPassword(), false);
    }

    public final XAConnection getXAConnection(String string2, String string3) throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(string2, string3, true);
        }
        return this.createXAConnection(this.ra, string2, string3, true);
    }

    void update() {
        this.ra = null;
        super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupResourceAdapter(String string2, String string3, boolean bl) throws SQLException {
        EmbeddedXADataSource embeddedXADataSource = this;
        synchronized (embeddedXADataSource) {
            if (this.ra == null || !this.ra.isActive()) {
                this.ra = null;
                String string4 = this.getShortDatabaseName();
                if (string4 != null) {
                    Database database = null;
                    if (Monitor.getMonitor() != null) {
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", string4);
                    }
                    if (database == null) {
                        if (bl) {
                            this.getConnection(string2, string3).close();
                        } else {
                            this.getConnection().close();
                        }
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", string4);
                    }
                    if (database != null) {
                        this.ra = (ResourceAdapter)database.getResourceAdapter();
                    }
                }
                if (this.ra == null) {
                    throw new SQLException(MessageService.getTextMessage("I024"), "08006", 45000);
                }
                this.findDriver();
                if (this.driver == null) {
                    throw new SQLException(MessageService.getTextMessage("I025"), "08006", 45000);
                }
            }
        }
    }

    protected XAConnection createXAConnection(ResourceAdapter resourceAdapter, String string2, String string3, boolean bl) throws SQLException {
        return ((Driver30)this.findDriver()).getNewXAConnection(this, resourceAdapter, string2, string3, bl);
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }
}

