/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.AutoloadedDriver;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.InternalDriver;
import org.apache.derby.jdbc.ReferenceableDataSource;

public class EmbeddedDataSource
extends ReferenceableDataSource
implements DataSource {
    private static final long serialVersionUID = -4945135214995641181L;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String connectionAttributes;
    private boolean attributesAsPassword;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    transient InternalDriver driver;
    private transient String jdbcurl;

    public boolean equals(Object object) {
        if (object instanceof EmbeddedDataSource) {
            EmbeddedDataSource embeddedDataSource = (EmbeddedDataSource)object;
            boolean bl = true;
            if (this.databaseName != null) {
                if (!this.databaseName.equals(embeddedDataSource.databaseName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.databaseName != null) {
                bl = false;
            }
            if (this.dataSourceName != null) {
                if (!this.dataSourceName.equals(embeddedDataSource.dataSourceName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.dataSourceName != null) {
                bl = false;
            }
            if (this.description != null) {
                if (!this.description.equals(embeddedDataSource.description)) {
                    bl = false;
                }
            } else if (embeddedDataSource.description != null) {
                bl = false;
            }
            if (this.createDatabase != null) {
                if (!this.createDatabase.equals(embeddedDataSource.createDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.createDatabase != null) {
                bl = false;
            }
            if (this.shutdownDatabase != null) {
                if (!this.shutdownDatabase.equals(embeddedDataSource.shutdownDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.shutdownDatabase != null) {
                bl = false;
            }
            if (this.connectionAttributes != null) {
                if (!this.connectionAttributes.equals(embeddedDataSource.connectionAttributes)) {
                    bl = false;
                }
            } else if (embeddedDataSource.connectionAttributes != null) {
                bl = false;
            }
            if (this.loginTimeout != embeddedDataSource.loginTimeout) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public final void setCreateDatabase(String string2) {
        this.createDatabase = string2 != null && string2.toLowerCase(Locale.ENGLISH).equals("create") ? string2 : null;
    }

    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    public final void setShutdownDatabase(String string2) {
        this.shutdownDatabase = string2 != null && string2.equalsIgnoreCase("shutdown") ? string2 : null;
    }

    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public final void setConnectionAttributes(String string2) {
        this.connectionAttributes = string2;
        this.update();
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public final void setAttributesAsPassword(boolean bl) {
        this.attributesAsPassword = bl;
        this.update();
    }

    public final boolean getAttributesAsPassword() {
        return this.attributesAsPassword;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword(), false);
    }

    public Connection getConnection(String string2, String string3) throws SQLException {
        return this.getConnection(string2, string3, true);
    }

    final Connection getConnection(String string2, String string3, boolean bl) throws SQLException {
        Object object;
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (!(bl && this.attributesAsPassword || string3 == null)) {
            properties.put("password", string3);
        }
        if (this.createDatabase != null) {
            properties.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            properties.put("shutdown", "true");
        }
        String string4 = this.jdbcurl;
        if (this.attributesAsPassword && bl && string3 != null) {
            object = new StringBuffer(string4.length() + string3.length() + 1);
            ((StringBuffer)object).append(string4);
            ((StringBuffer)object).append(';');
            ((StringBuffer)object).append(string3);
            string4 = ((StringBuffer)object).toString();
        }
        if ((object = this.findDriver().connect(string4, properties)) == null) {
            throw Util.generateCsSQLException("XCY00.S", (Object)"databaseName", this.getDatabaseName());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalDriver findDriver() throws SQLException {
        String string2 = this.jdbcurl;
        EmbeddedDataSource embeddedDataSource = this;
        synchronized (embeddedDataSource) {
            if (this.driver == null || !this.driver.acceptsURL(string2)) {
                new EmbeddedDriver();
                Driver driver = DriverManager.getDriver(string2);
                this.driver = driver instanceof AutoloadedDriver ? (InternalDriver)((Object)AutoloadedDriver.getDriverModule()) : (InternalDriver)((Object)driver);
            }
        }
        return this.driver;
    }

    void update() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("jdbc:derby:");
        String string2 = this.getDatabaseName();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = " ";
        }
        stringBuffer.append(string2);
        String string3 = this.getConnectionAttributes();
        if (string3 != null && (string3 = string3.trim()).length() != 0) {
            stringBuffer.append(';');
            stringBuffer.append(this.connectionAttributes);
        }
        this.jdbcurl = stringBuffer.toString();
    }
}

