/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.jdbc.EmbedXAConnection;
import org.apache.derby.jdbc.EmbeddedDataSource;

final class EmbedXAConnection40
extends EmbedXAConnection
implements XAConnection {
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();

    EmbedXAConnection40(EmbeddedDataSource embeddedDataSource, ResourceAdapter resourceAdapter, String string2, String string3, boolean bl) throws SQLException {
        super(embeddedDataSource, resourceAdapter, string2, string3, bl);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        if (statementEventListener == null) {
            return;
        }
        this.statementEventListeners.remove(statementEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (!this.isActive) {
            return;
        }
        if (statementEventListener == null) {
            return;
        }
        this.statementEventListeners.add(statementEventListener);
    }

    @Override
    public void onStatementClose(PreparedStatement preparedStatement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementClosed(statementEvent);
            }
        }
    }

    @Override
    public void onStatementErrorOccurred(PreparedStatement preparedStatement, SQLException sQLException) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement, sQLException);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementErrorOccurred(statementEvent);
            }
        }
    }
}

