/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.EmbedPooledConnection;
import org.apache.derby.jdbc.EmbedXAResource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.XAStatementControl;

class EmbedXAConnection
extends EmbedPooledConnection
implements XAConnection {
    private EmbedXAResource xaRes;

    EmbedXAConnection(EmbeddedDataSource embeddedDataSource, ResourceAdapter resourceAdapter, String string2, String string3, boolean bl) throws SQLException {
        super(embeddedDataSource, string2, string3, bl);
        this.xaRes = new EmbedXAResource(this, resourceAdapter);
    }

    public boolean isInGlobalTransaction() {
        return this.isGlobal();
    }

    private boolean isGlobal() {
        return this.xaRes.getCurrentXid() != null;
    }

    public final synchronized XAResource getXAResource() throws SQLException {
        this.checkActive();
        return this.xaRes;
    }

    public void checkAutoCommit(boolean bl) throws SQLException {
        if (bl && this.isGlobal()) {
            throw Util.generateCsSQLException("XJ056.S");
        }
        super.checkAutoCommit(bl);
    }

    public int checkHoldCursors(int n, boolean bl) throws SQLException {
        if (n == 1 && this.isGlobal()) {
            if (!bl) {
                throw Util.generateCsSQLException("XJ05C.S");
            }
            n = 2;
        }
        return super.checkHoldCursors(n, bl);
    }

    public void checkSavepoint() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S");
        }
        super.checkSavepoint();
    }

    public void checkRollback() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S");
        }
        super.checkRollback();
    }

    public void checkCommit() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ057.S");
        }
        super.checkCommit();
    }

    public void checkClose() throws SQLException {
        if (!this.isGlobal()) {
            super.checkClose();
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        if (!this.isGlobal()) {
            connection = super.getConnection();
        } else {
            if (this.currentConnectionHandle != null) {
                throw Util.generateCsSQLException("XJ059.S");
            }
            connection = this.getNewCurrentConnectionHandle();
        }
        this.currentConnectionHandle.syncState();
        return connection;
    }

    public Statement wrapStatement(Statement statement) throws SQLException {
        XAStatementControl xAStatementControl = new XAStatementControl(this, statement);
        return xAStatementControl.applicationStatement;
    }

    public PreparedStatement wrapStatement(PreparedStatement preparedStatement, String string2, Object object) throws SQLException {
        preparedStatement = super.wrapStatement(preparedStatement, string2, object);
        XAStatementControl xAStatementControl = new XAStatementControl(this, preparedStatement, string2, object);
        return (PreparedStatement)((Object)xAStatementControl.applicationStatement);
    }

    public CallableStatement wrapStatement(CallableStatement callableStatement, String string2) throws SQLException {
        callableStatement = super.wrapStatement(callableStatement, string2);
        XAStatementControl xAStatementControl = new XAStatementControl(this, callableStatement, string2);
        return (CallableStatement)((Object)xAStatementControl.applicationStatement);
    }

    public EngineConnection getRealConnection() throws SQLException {
        EngineConnection engineConnection = super.getRealConnection();
        if (engineConnection != null) {
            return engineConnection;
        }
        this.openRealConnection();
        this.currentConnectionHandle.setState(true);
        return this.realConnection;
    }
}

