/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.apache.derby.jdbc.EmbedPooledConnection;
import org.apache.derby.jdbc.ReferenceableDataSource;

class EmbedPooledConnection40
extends EmbedPooledConnection {
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();

    EmbedPooledConnection40(ReferenceableDataSource referenceableDataSource, String string2, String string3, boolean bl) throws SQLException {
        super(referenceableDataSource, string2, string3, bl);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        if (statementEventListener == null) {
            return;
        }
        this.statementEventListeners.remove(statementEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (!this.isActive) {
            return;
        }
        if (statementEventListener == null) {
            return;
        }
        this.statementEventListeners.add(statementEventListener);
    }

    @Override
    public void onStatementClose(PreparedStatement preparedStatement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementClosed(statementEvent);
            }
        }
    }

    @Override
    public void onStatementErrorOccurred(PreparedStatement preparedStatement, SQLException sQLException) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement, sQLException);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementErrorOccurred(statementEvent);
            }
        }
    }
}

