/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.sysinfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.sysinfo.ZipInfoProperties;

public final class Main {
    private static final String MESSAGE_FILE = "org.apache.derby.loc.sysinfoMessages";
    private static final LocalizedResource LOCALIZED_RESOURCE = new LocalizedResource(null, null, "org.apache.derby.loc.sysinfoMessages");
    private static boolean setPause = false;
    private static boolean setLicense = false;
    private static boolean cptester = false;
    private static final String sep = "------------------------------------------------------";
    private static final String javaSep = Main.getTextMessage("SIF01.L");
    private static final String jbmsSep = Main.getTextMessage("SIF01.M");
    private static final String licSep = Main.getTextMessage("SIF01.N");
    private static final String locSep = Main.getTextMessage("SIF01.P");
    private static final String curLoc = Main.getTextMessage("SIF01.T");
    private static final String failureTag = Main.getTextMessage("SIF01.J");
    private static final String EMBEDDED = "embedded";
    private static final String TOOLS = "tools";
    private static final String NET = "server";
    private static final String CLIENT = "client";
    private static final String MAINUSAGESTRING = "java org.apache.derby.tools.sysinfo -cp";
    private static final String USAGESTRINGPARTA = "java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ tools ] [";
    private static final String USAGESTRINGPARTB = ".class ] ]";
    private static final String[] infoNames = new String[]{"org/apache/derby/info/DBMS.properties", "org/apache/derby/info/tools.properties", "org/apache/derby/info/net.properties", "org/apache/derby/info/dnc.properties"};

    public static void main(String[] stringArray) {
        LocalizedResource.getInstance().init();
        LocalizedOutput localizedOutput = LocalizedResource.OutputWriter();
        Main.parseArgs(stringArray);
        if (cptester) {
            Main.getClasspathInfo(stringArray, localizedOutput);
        } else {
            Main.getMainInfo(localizedOutput, setPause);
        }
    }

    public static void getMainInfo(PrintWriter printWriter, boolean bl) {
        printWriter.println(javaSep);
        Main.reportJavaInfo(printWriter);
        printWriter.println(jbmsSep);
        Main.reportDerby(printWriter);
        printWriter.println(sep);
        try {
            Main.reportLocales(printWriter);
        }
        catch (Exception exception) {
            printWriter.println(Main.getTextMessage("SIF01.Q"));
            printWriter.println(Main.getTextMessage("SIF01.B"));
        }
        if (bl) {
            Main.pause();
        }
    }

    private static void parseArgs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-pause")) {
                setPause = true;
            }
            if (!stringArray[i].equals("-cp")) continue;
            cptester = true;
        }
    }

    private static void pause() {
        try {
            System.out.print(Main.getTextMessage("SIF01.C"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void reportDerby(PrintWriter printWriter) {
        String string2 = null;
        try {
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.class.path");
                }
            });
        }
        catch (SecurityException securityException) {
            printWriter.println(Main.getTextMessage("SIF01.U", securityException.getMessage()));
            string2 = null;
        }
        ZipInfoProperties[] zipInfoPropertiesArray = Main.getAllInfo(string2);
        if (zipInfoPropertiesArray != null) {
            for (int i = 0; i < zipInfoPropertiesArray.length; ++i) {
                String string3 = "[" + zipInfoPropertiesArray[i].getLocation() + "] " + zipInfoPropertiesArray[i].getVersionBuildInfo();
                printWriter.println(string3);
            }
        } else {
            printWriter.println(Main.getTextMessage("SIF01.D"));
        }
    }

    private static void reportJavaInfo(PrintWriter printWriter) {
        printWriter.println(Main.getTextMessage("SIF02.A", Main.getJavaProperty("java.version")));
        printWriter.println(Main.getTextMessage("SIF02.B", Main.getJavaProperty("java.vendor")));
        printWriter.println(Main.getTextMessage("SIF02.C", Main.getJavaProperty("java.home")));
        printWriter.println(Main.getTextMessage("SIF02.D", Main.getJavaProperty("java.class.path")));
        printWriter.println(Main.getTextMessage("SIF02.E", Main.getJavaProperty("os.name")));
        printWriter.println(Main.getTextMessage("SIF02.F", Main.getJavaProperty("os.arch")));
        printWriter.println(Main.getTextMessage("SIF02.G", Main.getJavaProperty("os.version")));
        printWriter.println(Main.getTextMessage("SIF02.H", Main.getJavaProperty("user.name")));
        printWriter.println(Main.getTextMessage("SIF02.I", Main.getJavaProperty("user.home")));
        printWriter.println(Main.getTextMessage("SIF02.J", Main.getJavaProperty("user.dir")));
        printWriter.println("java.specification.name: " + Main.getJavaProperty("java.specification.name"));
        printWriter.println("java.specification.version: " + Main.getJavaProperty("java.specification.version"));
        Main.printPropertyIfNotNull(printWriter, "java.runtime.version");
        Main.printPropertyIfNotNull(printWriter, "java.fullversion");
    }

    private static void printPropertyIfNotNull(PrintWriter printWriter, String string2) {
        String string3 = Main.getJavaProperty(string2, true);
        if (string3 != null) {
            printWriter.println(string2 + ": " + string3);
        }
    }

    private static String getJavaProperty(String string2) {
        return Main.getJavaProperty(string2, false);
    }

    private static String getJavaProperty(final String string2, boolean bl) {
        final String string3 = bl ? null : Main.getTextMessage("SIF01.H");
        try {
            String string4 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string2, string3);
                }
            });
            return string4;
        }
        catch (SecurityException securityException) {
            return Main.getTextMessage("SIF01.I", securityException);
        }
    }

    private static String getCanonicalPath(final File file) throws IOException {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return file.getCanonicalPath();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
        catch (SecurityException securityException) {
            return Main.getTextMessage("SIF01.I", securityException);
        }
    }

    private static void getClasspathInfo(String[] stringArray, PrintWriter printWriter) {
        Main.useMe(stringArray, printWriter);
    }

    private static void reportLocales(PrintWriter printWriter) {
        boolean bl = true;
        printWriter.println(locSep);
        Locale[] localeArray = Locale.getAvailableLocales();
        Object[] objectArray = new String[localeArray.length];
        for (int i = 0; i < localeArray.length; ++i) {
            objectArray[i] = localeArray[i].toString();
        }
        Arrays.sort(objectArray);
        Properties properties = new Properties();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = "/org/apache/derby/info/locale_" + (String)objectArray[i] + ".properties";
            final Properties properties2 = properties;
            final String string3 = string2;
            try {
                InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        InputStream inputStream = properties2.getClass().getResourceAsStream(string3);
                        return inputStream;
                    }
                });
                if (inputStream == null) continue;
                try {
                    Object object;
                    properties.clear();
                    properties.load(inputStream);
                    if (bl) {
                        object = null;
                        object = Locale.getDefault();
                        printWriter.println(Main.getTextMessage("SIF01.T") + "  [" + ((Locale)object).getDisplayLanguage() + "/" + ((Locale)object).getDisplayCountry() + " [" + object + "]]");
                        bl = false;
                    }
                    object = properties.getProperty("derby.locale.external.name");
                    object = ((String)object).substring(((String)object).indexOf("[") + 1);
                    object = ((String)object).substring(0, ((String)object).indexOf("]"));
                    printWriter.println(Main.getTextMessage("SIF01.R", object));
                    int n = Integer.parseInt(properties.getProperty("derby.locale.version.major"));
                    int n2 = Integer.parseInt(properties.getProperty("derby.locale.version.minor"));
                    int n3 = Integer.parseInt(properties.getProperty("derby.locale.version.maint"));
                    String string4 = properties.getProperty("derby.locale.build.number");
                    String string5 = ProductVersionHolder.fullVersionString(n, n2, n3, false, string4);
                    printWriter.println(Main.getTextMessage("SIF01.S", string5));
                }
                catch (IOException iOException) {
                    printWriter.println("Could not get locale properties from : " + inputStream);
                }
                continue;
            }
            catch (Throwable throwable) {
                printWriter.println("Could not load resource: " + string2);
                printWriter.println("Exception: " + throwable);
            }
        }
        printWriter.println(sep);
    }

    static void useMe(String[] stringArray, PrintWriter printWriter) {
        int n;
        PrintWriter printWriter2 = printWriter;
        if (printWriter2 == null) {
            printWriter2 = new PrintWriter(System.out);
        }
        if ((n = stringArray.length) == 1) {
            try {
                Main.tryAllClasspaths(printWriter2);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                Main.trySomeClasspaths(stringArray, printWriter2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void tryAllClasspaths(PrintWriter printWriter) throws Throwable {
        printWriter.println(Main.getTextMessage("SIF08.B"));
        printWriter.println(Main.getTextMessage("SIF08.C", "java org.apache.derby.tools.sysinfo -cp args"));
        StringBuffer stringBuffer = new StringBuffer(Main.getTextMessage("SIF08.D") + Main.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf());
        Main.tryCoreClasspath(stringBuffer, stringBuffer2);
        Main.tryNetClasspath(stringBuffer, stringBuffer2);
        Main.tryClientClasspath(stringBuffer, stringBuffer2);
        Main.tryUtilsClasspath(stringBuffer, stringBuffer2);
        printWriter.println(stringBuffer.toString());
        if (!stringBuffer2.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf())) {
            printWriter.println(stringBuffer2.toString());
        } else {
            printWriter.println(Main.getTextMessage("SIF08.F"));
        }
        printWriter.flush();
    }

    private static void trySomeClasspaths(String[] stringArray, PrintWriter printWriter) throws Throwable {
        String string2;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(Main.getTextMessage("SIF08.D") + Main.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf());
        if (Main.argumentsContain(stringArray, EMBEDDED)) {
            Main.tryCoreClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, NET)) {
            Main.tryNetClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, CLIENT)) {
            Main.tryClientClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (Main.argumentsContain(stringArray, TOOLS) || Main.argumentsContain(stringArray, "utils")) {
            Main.tryUtilsClasspath(stringBuffer, stringBuffer2);
            bl = true;
        }
        if (!(string2 = Main.argumentMatches(stringArray, ".class")).equals("")) {
            Main.tryMyClasspath(Main.argumentMatches(stringArray, ".class"), Main.getTextMessage("SIF08.H", string2), stringBuffer, stringBuffer2);
            bl = true;
        }
        if (bl) {
            printWriter.println(stringBuffer.toString());
            if (!stringBuffer2.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E") + Main.crLf())) {
                printWriter.println(stringBuffer2.toString());
            } else {
                printWriter.println(Main.getTextMessage("SIF08.F"));
            }
        } else {
            printWriter.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
        }
        printWriter.flush();
    }

    private static void tryCoreClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryNetClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), stringBuffer, stringBuffer2);
        Main.tryMyClasspath("org.apache.derby.drda.NetworkServerControl", Main.getTextMessage("SIF08.I", "derbynet.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryClientClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.jdbc.ClientDriver", Main.getTextMessage("SIF08.L", "derbyclient.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryUtilsClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Main.tryMyClasspath("org.apache.derby.tools.ij", Main.getTextMessage("SIF08.Q", "derbytools.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryMyClasspath(String string2, String string3, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            Class<?> clazz = Class.forName(string2);
            String string4 = Main.getFileWhichLoadedClass(clazz);
            stringBuffer.append(Main.found(string2, string3, string4));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(Main.notFound(string2, string3));
        }
    }

    private static void tryAsResource(String string2, String string3, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        try {
            InputStream inputStream = string2.getClass().getResourceAsStream(string2);
            inputStream.close();
            String string4 = Main.getFileWhichLoadedClass(string2.getClass());
            stringBuffer.append(Main.found(string2, string3, string4));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(Main.notFound(string2, string3));
        }
    }

    private static String found(String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(Main.crLf());
        stringBuffer.append("   " + string3);
        stringBuffer.append(Main.crLf());
        if (string4 != null) {
            stringBuffer.append("   ").append(string4).append(Main.crLf());
        }
        stringBuffer.append(Main.crLf());
        return stringBuffer.toString();
    }

    private static String notFound(String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(Main.crLf());
        stringBuffer.append("   " + string3);
        stringBuffer.append(Main.crLf());
        stringBuffer.append("    " + Main.getTextMessage("SIF08.U", string2));
        stringBuffer.append(Main.crLf());
        stringBuffer.append(Main.crLf());
        return stringBuffer.toString();
    }

    private static String crLf() {
        return System.getProperty("line.separator");
    }

    private static String lookForMainArg(String[] stringArray, PrintWriter printWriter) {
        int n = stringArray.length;
        String[] stringArray2 = new String[]{EMBEDDED};
        int n2 = 0;
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].toUpperCase(Locale.ENGLISH).equals(stringArray2[j].toUpperCase(Locale.ENGLISH))) continue;
                ++n2;
                string2 = stringArray2[j];
            }
        }
        if (n2 > 1 || n2 < 1) {
            printWriter.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
            return "";
        }
        return string2;
    }

    private static boolean argumentsContain(String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private static String argumentMatches(String[] stringArray, String string2) {
        String string3 = "";
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].endsWith(string2)) continue;
            string3 = stringArray[i].substring(0, stringArray[i].length() - 6);
        }
        return string3;
    }

    public static ZipInfoProperties[] getAllInfo(String string2) {
        Object object;
        ZipInfoProperties[] zipInfoPropertiesArray = Main.loadZipFromResource();
        if (zipInfoPropertiesArray == null) {
            zipInfoPropertiesArray = new ZipInfoProperties[1];
            object = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(TOOLS));
            ((ZipInfoProperties)object).setLocation(Main.getFileWhichLoadedClass(new Main().getClass()));
            zipInfoPropertiesArray[0] = object;
        }
        try {
            if (string2 != null) {
                object = Main.parseClasspath(string2);
                Vector<ZipInfoProperties> vector = new Vector<ZipInfoProperties>();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    ZipInfoProperties zipInfoProperties = null;
                    try {
                        zipInfoProperties = Main.checkForInfo((String)object[i]);
                    }
                    catch (SecurityException securityException) {
                        zipInfoProperties = new ZipInfoProperties(null);
                        zipInfoProperties.setLocation(Main.getTextMessage("SIF03.C", securityException.getMessage()));
                    }
                    if (zipInfoProperties == null) continue;
                    vector.addElement(zipInfoProperties);
                }
                if (vector.size() > 0) {
                    Object[] objectArray = new ZipInfoProperties[vector.size()];
                    vector.copyInto(objectArray);
                    return Main.mergeZips(zipInfoPropertiesArray, (ZipInfoProperties[])objectArray);
                }
            }
            return Main.mergeZips(zipInfoPropertiesArray, null);
        }
        catch (SecurityException securityException) {
            ZipInfoProperties[] zipInfoPropertiesArray2 = new ZipInfoProperties[]{new ZipInfoProperties(null)};
            zipInfoPropertiesArray2[0].setLocation(Main.getTextMessage("SIF03.C", securityException.getMessage()));
            return zipInfoPropertiesArray2;
        }
    }

    private static ZipInfoProperties[] loadZipFromResource() {
        ArrayList<ZipInfoProperties> arrayList = new ArrayList<ZipInfoProperties>();
        for (int i = 0; i < infoNames.length; ++i) {
            final String string2 = "/".concat(infoNames[i]);
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InputStream inputStream = new Main().getClass().getResourceAsStream(string2);
                    return inputStream;
                }
            });
            if (inputStream == null) continue;
            ZipInfoProperties zipInfoProperties = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream));
            URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = new Main().getClass().getResource(string2);
                    return uRL;
                }
            });
            zipInfoProperties.setLocation(Main.formatURL(uRL));
            arrayList.add(zipInfoProperties);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        ZipInfoProperties[] zipInfoPropertiesArray = new ZipInfoProperties[arrayList.size()];
        arrayList.toArray(zipInfoPropertiesArray);
        return zipInfoPropertiesArray;
    }

    private static String[] parseClasspath(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static ZipInfoProperties checkForInfo(final String string2) {
        return (ZipInfoProperties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = new File(string2);
                if (!file.exists()) {
                    return null;
                }
                if (file.isDirectory()) {
                    ZipInfoProperties zipInfoProperties = Main.checkDirectory(string2);
                    return zipInfoProperties;
                }
                if (file.isFile()) {
                    ZipInfoProperties zipInfoProperties = Main.checkFile(string2);
                    return zipInfoProperties;
                }
                return null;
            }
        });
    }

    private static ZipInfoProperties checkDirectory(String string2) {
        Object object;
        boolean bl = false;
        File file = null;
        for (int i = 0; i < infoNames.length; ++i) {
            object = infoNames[i].replace('/', File.separatorChar);
            file = new File(string2, (String)object);
            if (!file.exists()) continue;
            bl = true;
            break;
        }
        if (!bl || file == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(fileInputStream));
            ((ZipInfoProperties)object).setLocation(Main.getCanonicalPath(new File(string2)).replace('/', File.separatorChar));
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ZipInfoProperties checkFile(String string2) {
        try {
            ZipFile zipFile = new ZipFile(string2);
            ZipEntry zipEntry = null;
            for (int i = 0; i < infoNames.length && (zipEntry = zipFile.getEntry(infoNames[i])) == null; ++i) {
            }
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            if (inputStream == null) {
                return null;
            }
            ZipInfoProperties zipInfoProperties = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream));
            zipInfoProperties.setLocation(Main.getCanonicalPath(new File(string2)).replace('/', File.separatorChar));
            return zipInfoProperties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getTextMessage(String string2) {
        return Main.getCompleteMessage(string2, new Object[0]);
    }

    public static String getTextMessage(String string2, Object object) {
        return Main.getCompleteMessage(string2, new Object[]{object});
    }

    public static String getTextMessage(String string2, Object object, Object object2) {
        return Main.getCompleteMessage(string2, new Object[]{object, object2});
    }

    public static String getTextMessage(String string2, Object object, Object object2, Object object3) {
        return Main.getCompleteMessage(string2, new Object[]{object, object2, object3});
    }

    public static String getTextMessage(String string2, Object object, Object object2, Object object3, Object object4) {
        return Main.getCompleteMessage(string2, new Object[]{object, object2, object3, object4});
    }

    public static String getCompleteMessage(String string2, Object[] objectArray) {
        return LOCALIZED_RESOURCE.getTextMessage(string2, objectArray);
    }

    private static String getFileWhichLoadedClass(final Class clazz) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codeSource = null;
                try {
                    codeSource = clazz.getProtectionDomain().getCodeSource();
                }
                catch (SecurityException securityException) {
                    return Main.getTextMessage("SIF01.V", clazz.getName(), securityException.getMessage());
                }
                if (codeSource == null) {
                    return null;
                }
                URL uRL = codeSource.getLocation();
                try {
                    return URLDecoder.decode(uRL.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return unsupportedEncodingException.getMessage();
                }
            }
        });
    }

    private static ZipInfoProperties[] mergeZips(ZipInfoProperties[] zipInfoPropertiesArray, ZipInfoProperties[] zipInfoPropertiesArray2) {
        int n;
        int n2;
        Vector<ZipInfoProperties> vector = new Vector<ZipInfoProperties>();
        boolean bl = false;
        for (n2 = 0; n2 < zipInfoPropertiesArray.length; ++n2) {
            if (zipInfoPropertiesArray[n2] != null && zipInfoPropertiesArray.length > 1) {
                for (n = n2 + 1; n < zipInfoPropertiesArray.length; ++n) {
                    if (!zipInfoPropertiesArray[n2].getLocation().equals(zipInfoPropertiesArray[n].getLocation())) continue;
                    zipInfoPropertiesArray[n] = null;
                }
            }
            if (zipInfoPropertiesArray[n2] == null) continue;
            vector.addElement(zipInfoPropertiesArray[n2]);
        }
        if (zipInfoPropertiesArray2 != null) {
            for (n2 = 0; n2 < zipInfoPropertiesArray2.length; ++n2) {
                for (n = 0; n < vector.size(); ++n) {
                    ZipInfoProperties zipInfoProperties = (ZipInfoProperties)vector.get(n);
                    if (!zipInfoPropertiesArray2[n2].getLocation().equals(zipInfoProperties.getLocation())) continue;
                    bl = true;
                }
                if (!bl) {
                    vector.addElement(zipInfoPropertiesArray2[n2]);
                }
                bl = false;
            }
        }
        Object[] objectArray = new ZipInfoProperties[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static String formatURL(URL uRL) {
        String string2;
        try {
            string2 = URLDecoder.decode(uRL.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        if (string2.startsWith("jar:")) {
            string2 = string2.substring(4);
        }
        if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        if (string2.indexOf("!") > -1) {
            string2 = string2.substring(0, string2.indexOf("!"));
        }
        if (string2.indexOf("/org/apache/derby") > -1) {
            string2 = string2.substring(0, string2.indexOf("/org/apache/derby"));
        }
        if (string2.charAt(0) == '/' && Character.isLetter(string2.charAt(1)) && string2.charAt(2) == ':' && string2.charAt(2) == '/') {
            string2 = string2.substring(1);
        }
        String string3 = "";
        try {
            string3 = Main.getCanonicalPath(new File(string2)).replace('/', File.separatorChar);
        }
        catch (IOException iOException) {
            string3 = iOException.getMessage();
        }
        return string3;
    }
}

