/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.impl.store.access.conglomerate.GenericConglomerate;
import org.apache.derby.impl.store.access.conglomerate.GenericConglomerateController;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerateScratchSpace;
import org.apache.derby.impl.store.access.heap.HeapCompressScan;
import org.apache.derby.impl.store.access.heap.HeapController;
import org.apache.derby.impl.store.access.heap.HeapCostController;
import org.apache.derby.impl.store.access.heap.HeapScan;
import org.apache.derby.impl.store.access.heap.OpenHeap;

public class Heap
extends GenericConglomerate
implements Conglomerate,
StaticCompiledOpenConglomInfo {
    protected int conglom_format_id;
    private ContainerKey id;
    int[] format_ids;
    protected int[] collation_ids;
    private boolean hasCollatedTypes;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(Heap.class);
    private static final int CONTAINER_KEY_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(ContainerKey.class);

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.id) {
            n += CONTAINER_KEY_MEMORY_USAGE;
        }
        if (null != this.format_ids) {
            n += this.format_ids.length * ClassSize.getIntSize();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(Transaction transaction, int n, long l, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n2, int n3) throws StandardException {
        long l2;
        if (properties != null) {
            int n4;
            String string2 = properties.getProperty("derby.storage.minimumRecordSize");
            int n5 = n4 = string2 == null ? 12 : Integer.parseInt(string2);
            if (n4 < 12) {
                properties.put("derby.storage.minimumRecordSize", Integer.toString(12));
            }
        }
        if ((l2 = transaction.addContainer(n, l, 0, properties, n3)) < 0L) {
            throw StandardException.newException("XSCH0.S");
        }
        this.id = new ContainerKey(n, l2);
        if (dataValueDescriptorArray == null || dataValueDescriptorArray.length == 0) {
            throw StandardException.newException("XSCH4.S");
        }
        this.format_ids = ConglomerateUtil.createFormatIds(dataValueDescriptorArray);
        this.conglom_format_id = n2;
        this.collation_ids = ConglomerateUtil.createCollationIds(this.format_ids.length, nArray);
        this.hasCollatedTypes = Heap.hasCollatedColumns(this.collation_ids);
        ContainerHandle containerHandle = null;
        Page page = null;
        try {
            containerHandle = transaction.openContainer(this.id, null, 4 | (this.isTemporary() ? 2048 : 0));
            Object[] objectArray = new DataValueDescriptor[]{this};
            page = containerHandle.getPage(1L);
            page.insertAtSlot(0, objectArray, null, null, (byte)8, 100);
            page.unlatch();
            page = null;
            containerHandle.setEstimatedRowCount(0L, 0);
        }
        finally {
            if (containerHandle != null) {
                containerHandle.close();
            }
            if (page != null) {
                page.unlatch();
            }
        }
    }

    public void boot_create(long l, DataValueDescriptor[] dataValueDescriptorArray) {
        this.id = new ContainerKey(0L, l);
        this.format_ids = ConglomerateUtil.createFormatIds(dataValueDescriptorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(TransactionManager transactionManager, int n, Storable storable, int n2) throws StandardException {
        ContainerHandle containerHandle = null;
        Page page = null;
        Transaction transaction = transactionManager.getRawStoreXact();
        try {
            containerHandle = transaction.openContainer(this.id, transaction.newLockingPolicy(2, 5, true), 4 | (this.isTemporary() ? 2048 : 0));
            if (n != this.format_ids.length) {
                throw StandardException.newException("XSCH5.S", (Object)new Long(n), (Object)new Long(this.format_ids.length));
            }
            int[] nArray = this.format_ids;
            this.format_ids = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, this.format_ids, 0, nArray.length);
            this.format_ids[nArray.length] = storable.getTypeFormatId();
            int[] nArray2 = this.collation_ids;
            this.collation_ids = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, this.collation_ids, 0, nArray2.length);
            this.collation_ids[nArray2.length] = n2;
            Object[] objectArray = new DataValueDescriptor[]{this};
            page = containerHandle.getPage(1L);
            page.updateAtSlot(0, objectArray, null);
            page.unlatch();
            page = null;
        }
        finally {
            if (containerHandle != null) {
                containerHandle.close();
            }
            if (page != null) {
                page.unlatch();
            }
        }
    }

    public void drop(TransactionManager transactionManager) throws StandardException {
        transactionManager.getRawStoreXact().dropContainer(this.id);
    }

    public boolean fetchMaxOnBTree(TransactionManager transactionManager, Transaction transaction, long l, int n, int n2, LockingPolicy lockingPolicy, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public final ContainerKey getId() {
        return this.id;
    }

    public final long getContainerid() {
        return this.id.getContainerId();
    }

    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo() throws StandardException {
        return new OpenConglomerateScratchSpace(this.format_ids, this.collation_ids, this.hasCollatedTypes);
    }

    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(TransactionController transactionController, long l) throws StandardException {
        return this;
    }

    public boolean isTemporary() {
        return this.id.getSegmentId() == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long load(TransactionManager transactionManager, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        long l = 0L;
        HeapController heapController = new HeapController();
        try {
            l = heapController.load(transactionManager, this, bl, rowLocationRetRowSource);
        }
        finally {
            heapController.close();
        }
        return l;
    }

    public ConglomerateController open(TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, LockingPolicy lockingPolicy, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        OpenHeap openHeap = new OpenHeap();
        if (openHeap.init(null, this, this.format_ids, this.collation_ids, transactionManager, transaction, bl, n, n2, lockingPolicy, dynamicCompiledOpenConglomInfo) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()).toString());
        }
        HeapController heapController = new HeapController();
        heapController.init(openHeap);
        return heapController;
    }

    public ScanManager openScan(TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, LockingPolicy lockingPolicy, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        if (!RowUtil.isRowEmpty(dataValueDescriptorArray) || !RowUtil.isRowEmpty(dataValueDescriptorArray2)) {
            throw StandardException.newException("XSCH8.S");
        }
        OpenHeap openHeap = new OpenHeap();
        if (openHeap.init(null, this, this.format_ids, this.collation_ids, transactionManager, transaction, bl, n, n2, lockingPolicy, dynamicCompiledOpenConglomInfo) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
        }
        HeapScan heapScan = new HeapScan();
        heapScan.init(openHeap, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5);
        return heapScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeConglomerate(TransactionManager transactionManager, Transaction transaction) throws StandardException {
        OpenHeap openHeap = null;
        GenericConglomerateController genericConglomerateController = null;
        TransactionController transactionController = null;
        try {
            openHeap = new OpenHeap();
            if (openHeap.init(null, this, this.format_ids, this.collation_ids, transactionManager, transaction, false, 4, 6, null, null) == null) {
                throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
            }
            OpenHeap openHeap2 = new OpenHeap();
            transactionController = (TransactionManager)transactionManager.startNestedUserTransaction(false, true);
            if (openHeap2.init(null, this, this.format_ids, this.collation_ids, (TransactionManager)transactionController, transactionController.getRawStoreXact(), true, 4, 6, transactionController.getRawStoreXact().newLockingPolicy(1, 4, true), null) == null) {
                throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()).toString());
            }
            genericConglomerateController = new HeapController();
            genericConglomerateController.init(openHeap2);
            Page page = openHeap2.getContainer().getFirstPage();
            boolean bl = false;
            while (page != null) {
                long l = page.getPageNumber();
                bl = ((HeapController)genericConglomerateController).purgeCommittedDeletes(page);
                if (bl) {
                    page = null;
                    openHeap2.getXactMgr().commitNoSync(1);
                    genericConglomerateController.closeForEndTransaction(false);
                    openHeap2.reopen();
                } else {
                    page.unlatch();
                    page = null;
                }
                page = openHeap2.getContainer().getNextPage(l);
            }
        }
        finally {
            if (openHeap != null) {
                openHeap.close();
            }
            if (genericConglomerateController != null) {
                genericConglomerateController.close();
            }
            if (transactionController != null) {
                transactionController.commitNoSync(1);
                transactionController.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressConglomerate(TransactionManager transactionManager, Transaction transaction) throws StandardException {
        OpenHeap openHeap = null;
        HeapController heapController = null;
        try {
            openHeap = new OpenHeap();
            if (openHeap.init(null, this, this.format_ids, this.collation_ids, transactionManager, transaction, false, 4, 7, transaction.newLockingPolicy(2, 4, true), null) == null) {
                throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
            }
            heapController = new HeapController();
            heapController.init(openHeap);
            openHeap.getContainer().compressContainer();
        }
        finally {
            if (openHeap != null) {
                openHeap.close();
            }
        }
    }

    public ScanManager defragmentConglomerate(TransactionManager transactionManager, Transaction transaction, boolean bl, int n, int n2, LockingPolicy lockingPolicy, int n3) throws StandardException {
        OpenHeap openHeap = new OpenHeap();
        if (openHeap.init(null, this, this.format_ids, this.collation_ids, transactionManager, transaction, bl, n, n2, transaction.newLockingPolicy(1, 4, true), null) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
        }
        HeapCompressScan heapCompressScan = new HeapCompressScan();
        heapCompressScan.init(openHeap, null, null, 0, null, null, 0);
        return heapCompressScan;
    }

    public StoreCostController openStoreCost(TransactionManager transactionManager, Transaction transaction) throws StandardException {
        OpenHeap openHeap = new OpenHeap();
        if (openHeap.init(null, this, this.format_ids, this.collation_ids, transactionManager, transaction, false, 8, 7, null, null) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
        }
        HeapCostController heapCostController = new HeapCostController();
        heapCostController.init(openHeap);
        return heapCostController;
    }

    public String toString() {
        return this.id == null ? "null" : this.id.toString();
    }

    public DataValueDescriptor getConglom() {
        return this;
    }

    public int getTypeFormatId() {
        return 467;
    }

    public boolean isNull() {
        return this.id == null;
    }

    public void restoreToNull() {
        this.id = null;
    }

    protected void writeExternal_v10_2(ObjectOutput objectOutput) throws IOException {
        FormatIdUtil.writeFormatIdInteger(objectOutput, this.conglom_format_id);
        objectOutput.writeInt((int)this.id.getSegmentId());
        objectOutput.writeLong(this.id.getContainerId());
        objectOutput.writeInt(this.format_ids.length);
        ConglomerateUtil.writeFormatIdArray(this.format_ids, objectOutput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeExternal_v10_2(objectOutput);
        if (this.conglom_format_id == 467) {
            ConglomerateUtil.writeCollationIdArray(this.collation_ids, objectOutput);
        }
    }

    private final void localReadExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.conglom_format_id = FormatIdUtil.readFormatIdInteger(objectInput);
        int n = objectInput.readInt();
        long l = objectInput.readLong();
        this.id = new ContainerKey(n, l);
        int n2 = objectInput.readInt();
        this.format_ids = ConglomerateUtil.readFormatIdArray(n2, objectInput);
        this.collation_ids = new int[this.format_ids.length];
        for (int i = 0; i < this.format_ids.length; ++i) {
            this.collation_ids[i] = 0;
        }
        if (this.conglom_format_id == 467) {
            this.hasCollatedTypes = ConglomerateUtil.readCollationIdArray(this.collation_ids, objectInput);
        } else if (this.conglom_format_id != 91) {
            // empty if block
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.localReadExternal(objectInput);
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        this.localReadExternal(arrayInputStream);
    }
}

