/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.impl.store.access.conglomerate.GenericConglomerate;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerateScratchSpace;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;

public abstract class BTree
extends GenericConglomerate {
    public static final long ROOTPAGEID = 1L;
    public static final String PROPERTY_MAX_ROWS_PER_PAGE_PARAMETER = null;
    public static final String PROPERTY_ALLOWDUPLICATES = "allowDuplicates";
    public static final String PROPERTY_NKEYFIELDS = "nKeyFields";
    public static final String PROPERTY_NUNIQUECOLUMNS = "nUniqueColumns";
    public static final String PROPERTY_PARENTLINKS = "maintainParentLinks";
    public static final String PROPERTY_UNIQUE_WITH_DUPLICATE_NULLS = "uniqueWithDuplicateNulls";
    protected ContainerKey id;
    protected int nKeyFields;
    int nUniqueColumns;
    boolean allowDuplicates;
    boolean maintainParentLinks;
    boolean uniqueWithDuplicateNulls = false;
    static int maxRowsPerPage = Integer.MAX_VALUE;
    protected int conglom_format_id;
    protected int[] format_ids;
    protected boolean[] ascDescInfo;
    protected int[] collation_ids;
    protected boolean hasCollatedTypes;

    protected abstract BTreeLockingPolicy getBtreeLockingPolicy(Transaction var1, int var2, int var3, int var4, ConglomerateController var5, OpenBTree var6) throws StandardException;

    public abstract ConglomerateController lockTable(TransactionManager var1, int var2, int var3, int var4) throws StandardException;

    final DataValueDescriptor[] createBranchTemplate(Transaction transaction, DataValueDescriptor dataValueDescriptor) throws StandardException {
        return TemplateRow.newBranchRow(transaction, this.format_ids, this.collation_ids, dataValueDescriptor);
    }

    public final DataValueDescriptor[] createTemplate(Transaction transaction) throws StandardException {
        return TemplateRow.newRow(transaction, null, this.format_ids, this.collation_ids);
    }

    public final boolean isUnique() {
        return this.nKeyFields != this.nUniqueColumns;
    }

    public void setUniqueWithDuplicateNulls(boolean bl) {
        this.uniqueWithDuplicateNulls = bl;
    }

    public boolean isUniqueWithDuplicateNulls() {
        return this.uniqueWithDuplicateNulls;
    }

    public void addColumn(TransactionManager transactionManager, int n, Storable storable, int n2) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public final ContainerKey getId() {
        return this.id;
    }

    public void create(Transaction transaction, int n, long l, DataValueDescriptor[] dataValueDescriptorArray, Properties properties, int n2, int n3) throws StandardException {
        if (properties == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NKEYFIELDS);
        }
        this.allowDuplicates = Boolean.valueOf(properties.getProperty(PROPERTY_ALLOWDUPLICATES, "false"));
        String string2 = properties.getProperty(PROPERTY_NKEYFIELDS);
        if (string2 == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NKEYFIELDS);
        }
        this.nKeyFields = Integer.parseInt(string2);
        string2 = properties.getProperty(PROPERTY_NUNIQUECOLUMNS);
        if (string2 == null) {
            throw StandardException.newException("XSCB2.S", PROPERTY_NUNIQUECOLUMNS);
        }
        this.nUniqueColumns = Integer.parseInt(string2);
        string2 = properties.getProperty(PROPERTY_UNIQUE_WITH_DUPLICATE_NULLS, "false");
        this.uniqueWithDuplicateNulls = new Boolean(string2);
        this.maintainParentLinks = Boolean.valueOf(properties.getProperty(PROPERTY_PARENTLINKS, "true"));
        this.format_ids = ConglomerateUtil.createFormatIds(dataValueDescriptorArray);
        this.conglom_format_id = n2;
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        properties.put("derby.storage.reusableRecordId", "true");
        long l2 = transaction.addContainer(n, l, 0, properties, n3);
        if (l2 <= 0L) {
            throw StandardException.newException("XSCB0.S");
        }
        this.id = new ContainerKey(n, l2);
    }

    public abstract void drop(TransactionManager var1) throws StandardException;

    public abstract long load(TransactionManager var1, boolean var2, RowLocationRetRowSource var3) throws StandardException;

    public long getContainerid() {
        return this.id.getContainerId();
    }

    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo() throws StandardException {
        return new OpenConglomerateScratchSpace(this.format_ids, this.collation_ids, this.hasCollatedTypes);
    }

    public boolean isTemporary() {
        return this.id.getSegmentId() == -1L;
    }

    public abstract ConglomerateController open(TransactionManager var1, Transaction var2, boolean var3, int var4, int var5, LockingPolicy var6, StaticCompiledOpenConglomInfo var7, DynamicCompiledOpenConglomInfo var8) throws StandardException;

    public boolean isNull() {
        return this.id == null;
    }

    public void restoreToNull() {
        this.id = null;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.conglom_format_id = FormatIdUtil.readFormatIdInteger(objectInput);
        long l = objectInput.readLong();
        int n = objectInput.readInt();
        this.nKeyFields = objectInput.readInt();
        this.nUniqueColumns = objectInput.readInt();
        this.allowDuplicates = objectInput.readBoolean();
        this.maintainParentLinks = objectInput.readBoolean();
        this.format_ids = ConglomerateUtil.readFormatIdArray(this.nKeyFields, objectInput);
        this.id = new ContainerKey(n, l);
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        this.conglom_format_id = FormatIdUtil.readFormatIdInteger(arrayInputStream);
        long l = arrayInputStream.readLong();
        int n = arrayInputStream.readInt();
        this.nKeyFields = arrayInputStream.readInt();
        this.nUniqueColumns = arrayInputStream.readInt();
        this.allowDuplicates = arrayInputStream.readBoolean();
        this.maintainParentLinks = arrayInputStream.readBoolean();
        this.format_ids = ConglomerateUtil.readFormatIdArray(this.nKeyFields, arrayInputStream);
        this.id = new ContainerKey(n, l);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatIdUtil.writeFormatIdInteger(objectOutput, this.conglom_format_id);
        objectOutput.writeLong(this.id.getContainerId());
        objectOutput.writeInt((int)this.id.getSegmentId());
        objectOutput.writeInt(this.nKeyFields);
        objectOutput.writeInt(this.nUniqueColumns);
        objectOutput.writeBoolean(this.allowDuplicates);
        objectOutput.writeBoolean(this.maintainParentLinks);
        ConglomerateUtil.writeFormatIdArray(this.format_ids, objectOutput);
    }

    public String toString() {
        return super.toString();
    }
}

