/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealSortStatistics
extends RealNoPutResultSetStatistics {
    public int rowsInput;
    public int rowsReturned;
    public boolean eliminateDuplicates;
    public boolean inSortedOrder;
    public ResultSetStatistics childResultSetStatistics;
    public FormatableProperties sortProperties;

    public RealSortStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, int n5, int n6, boolean bl, boolean bl2, Properties properties, double d, double d2, ResultSetStatistics resultSetStatistics) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.rowsInput = n5;
        this.rowsReturned = n6;
        this.eliminateDuplicates = bl;
        this.inSortedOrder = bl2;
        this.childResultSetStatistics = resultSetStatistics;
        this.sortProperties = new FormatableProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.sortProperties.put(string2, properties.get(string2));
        }
    }

    public String getStatementExecutionPlanText(int n) {
        this.initFormatInfo(n);
        String string2 = this.inSortedOrder ? "" : this.indent + MessageService.getTextMessage("43X40.U") + ": \n" + PropertyUtil.sortProperties(this.sortProperties, this.subIndent);
        return this.indent + MessageService.getTextMessage("43Y06.U") + ":\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X21.U") + " = " + this.rowsInput + "\n" + this.indent + MessageService.getTextMessage("43X81.U") + " = " + this.rowsReturned + "\n" + this.indent + MessageService.getTextMessage("43Y07.U") + " = " + this.eliminateDuplicates + "\n" + this.indent + MessageService.getTextMessage("43X43.U") + " = " + this.inSortedOrder + "\n" + string2 + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X05.U") + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    public String getScanStatisticsText(String string2, int n) {
        return this.childResultSetStatistics.getScanStatisticsText(string2, n);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.childResultSetStatistics);
        return vector;
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43Y08.U");
    }

    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.childResultSetStatistics != null) {
            ++n;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    public String getRSXplainType() {
        return "SORT";
    }

    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, null, null, (UUID)object2, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, new Integer(this.rowsInput), new Integer(this.rowsSeen), null, new Integer(this.rowsFiltered), new Integer(this.rowsReturned), null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }

    public Object getSortPropsDescriptor(Object object) {
        FormatableProperties formatableProperties = this.sortProperties;
        XPLAINSortPropsDescriptor xPLAINSortPropsDescriptor = new XPLAINSortPropsDescriptor((UUID)object, null, null, null, null, null, XPLAINUtil.getYesNoCharFromBoolean(this.eliminateDuplicates), XPLAINUtil.getYesNoCharFromBoolean(this.inSortedOrder), null);
        return XPLAINUtil.extractSortProps(xPLAINSortPropsDescriptor, formatableProperties);
    }
}

