/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.IFastPath;
import org.apache.derby.vti.IQualifyable;
import org.apache.derby.vti.Pushable;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTIEnvironment;

class VTIResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
VTIEnvironment {
    public int rowsReturned;
    public String javaClassName;
    private boolean next;
    private ClassInspector classInspector;
    private GeneratedMethod row;
    private GeneratedMethod constructor;
    private PreparedStatement userPS;
    private ResultSet userVTI;
    private ExecRow allocatedRow;
    private FormatableBitSet referencedColumns;
    private boolean version2;
    private boolean reuseablePs;
    private boolean isTarget;
    private FormatableHashtable compileTimeConstants;
    private int ctcNumber;
    private boolean pushedProjection;
    private IFastPath fastPath;
    private Qualifier[][] pushedQualifiers;
    private boolean[] runtimeNullableColumn;
    private boolean isDerbyStyleTableFunction;
    private final TypeDescriptor returnType;
    private DataTypeDescriptor[] returnColumnTypes;
    private String[] vtiProjection;
    private Restriction vtiRestriction;
    private int scanIsolationLevel = 0;

    VTIResultSet(Activation activation, GeneratedMethod generatedMethod, int n, GeneratedMethod generatedMethod2, String string2, Qualifier[][] qualifierArray, int n2, boolean bl, boolean bl2, int n3, boolean bl3, int n4, double d, double d2, boolean bl4, int n5, int n6, int n7) throws StandardException {
        super(activation, n, d, d2);
        this.row = generatedMethod;
        this.constructor = generatedMethod2;
        this.javaClassName = string2;
        this.version2 = bl;
        this.reuseablePs = bl2;
        this.isTarget = bl3;
        this.pushedQualifiers = qualifierArray;
        this.scanIsolationLevel = n4;
        this.isDerbyStyleTableFunction = bl4;
        this.returnType = n5 == -1 ? null : (TypeDescriptor)activation.getPreparedStatement().getSavedObject(n5);
        this.vtiProjection = n6 == -1 ? null : (String[])activation.getPreparedStatement().getSavedObject(n6);
        Restriction restriction = this.vtiRestriction = n7 == -1 ? null : (Restriction)activation.getPreparedStatement().getSavedObject(n7);
        if (n2 != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n2);
        }
        this.ctcNumber = n3;
        this.compileTimeConstants = (FormatableHashtable)activation.getPreparedStatement().getSavedObject(n3);
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        ++this.numOpens;
        try {
            if (this.version2) {
                Object object;
                this.userPS = (PreparedStatement)this.constructor.invoke(this.activation);
                if (this.userPS instanceof Pushable) {
                    object = (Pushable)((Object)this.userPS);
                    if (this.referencedColumns != null) {
                        this.pushedProjection = object.pushProjection(this, this.getProjectedColList());
                    }
                }
                if (this.userPS instanceof IQualifyable) {
                    object = (IQualifyable)((Object)this.userPS);
                    object.setQualifiers(this, this.pushedQualifiers);
                }
                IFastPath iFastPath = this.fastPath = this.userPS instanceof IFastPath ? (IFastPath)((Object)this.userPS) : null;
                if (this.isTarget && this.userPS instanceof DeferModification && this.activation.getConstantAction() instanceof UpdatableVTIConstantAction) {
                    object = (UpdatableVTIConstantAction)this.activation.getConstantAction();
                    ((DeferModification)((Object)this.userPS)).modificationNotify(((UpdatableVTIConstantAction)object).statementType, ((UpdatableVTIConstantAction)object).deferred);
                }
                if (this.fastPath == null || !this.fastPath.executeAsFastPath()) {
                    this.userVTI = this.userPS.executeQuery();
                }
                if (this.isTarget) {
                    this.activation.setTargetVTI(this.userVTI);
                }
            } else {
                this.userVTI = (ResultSet)this.constructor.invoke(this.activation);
                if (this.userVTI instanceof RestrictedVTI) {
                    RestrictedVTI restrictedVTI = (RestrictedVTI)((Object)this.userVTI);
                    restrictedVTI.initScan(this.vtiProjection, this.cloneRestriction(this.activation));
                }
            }
            this.setNullableColumnList();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private Restriction cloneRestriction(Activation activation) throws StandardException {
        if (this.vtiRestriction == null) {
            return null;
        }
        return this.cloneRestriction(activation, this.vtiRestriction);
    }

    private Restriction cloneRestriction(Activation activation, Restriction restriction) throws StandardException {
        if (restriction instanceof Restriction.AND) {
            Restriction.AND aND = (Restriction.AND)restriction;
            return new Restriction.AND(this.cloneRestriction(activation, aND.getLeftChild()), this.cloneRestriction(activation, aND.getRightChild()));
        }
        if (restriction instanceof Restriction.OR) {
            Restriction.OR oR = (Restriction.OR)restriction;
            return new Restriction.OR(this.cloneRestriction(activation, oR.getLeftChild()), this.cloneRestriction(activation, oR.getRightChild()));
        }
        if (restriction instanceof Restriction.ColumnQualifier) {
            Object object;
            Restriction.ColumnQualifier columnQualifier = (Restriction.ColumnQualifier)restriction;
            Object object2 = columnQualifier.getConstantOperand();
            if (object2 == null) {
                object = null;
            } else if (object2 instanceof int[]) {
                int n = ((int[])object2)[0];
                ParameterValueSet parameterValueSet = activation.getParameterValueSet();
                object = parameterValueSet.getParameter(n).getObject();
            } else {
                object = object2;
            }
            return new Restriction.ColumnQualifier(columnQualifier.getColumnName(), columnQualifier.getComparisonOperator(), object);
        }
        throw StandardException.newException("0A000.S", restriction.getClass().getName());
    }

    private boolean[] setNullableColumnList() throws SQLException, StandardException {
        if (this.runtimeNullableColumn != null) {
            return this.runtimeNullableColumn;
        }
        if (this.isDerbyStyleTableFunction) {
            int n = this.getAllocatedRow().nColumns() + 1;
            this.runtimeNullableColumn = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.runtimeNullableColumn[i] = true;
            }
            return this.runtimeNullableColumn;
        }
        if (this.userVTI == null) {
            return null;
        }
        ResultSetMetaData resultSetMetaData = this.userVTI.getMetaData();
        boolean[] blArray = new boolean[resultSetMetaData.getColumnCount() + 1];
        for (int i = 1; i < blArray.length; ++i) {
            blArray[i] = resultSetMetaData.isNullable(i) != 0;
        }
        this.runtimeNullableColumn = blArray;
        return blArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reopenCore() throws StandardException {
        if (this.reuseablePs) {
            if (this.userVTI == null) return;
            try {
                this.userVTI.close();
                this.userVTI = this.userPS.executeQuery();
                if (!this.isTarget) return;
                this.activation.setTargetVTI(this.userVTI);
                return;
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
        } else {
            this.close();
            this.openCore();
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            try {
                int n;
                if (this.userVTI == null && this.fastPath != null && (n = this.fastPath.nextRow((execRow = this.getAllocatedRow()).getRowArray())) != 0) {
                    if (n == -1) {
                        execRow = null;
                    } else if (n == 1) {
                        this.userVTI = this.userPS.executeQuery();
                    }
                }
                if (this.userVTI != null) {
                    if (!this.userVTI.next()) {
                        if (null != this.fastPath) {
                            this.fastPath.rowsDone();
                        }
                        execRow = null;
                    } else {
                        execRow = this.getAllocatedRow();
                        this.populateFromResultSet(execRow);
                        if (this.fastPath != null) {
                            this.fastPath.currentRow(this.userVTI, execRow.getRowArray());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        this.setCurrentRow(execRow);
        if (execRow != null) {
            ++this.rowsReturned;
            ++this.rowsSeen;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            if (this.userVTI != null) {
                try {
                    try {
                        this.userVTI.close();
                    }
                    catch (SQLException sQLException) {
                        throw StandardException.unexpectedUserException(sQLException);
                    }
                    Object var3_1 = null;
                    this.userVTI = null;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    this.userVTI = null;
                    throw throwable;
                }
            }
            if (this.userPS != null && !this.reuseablePs) {
                try {
                    try {
                        this.userPS.close();
                    }
                    catch (SQLException sQLException) {
                        throw StandardException.unexpectedUserException(sQLException);
                    }
                    Object var5_6 = null;
                    this.userPS = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.userPS = null;
                    throw throwable;
                }
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        if (this.userPS != null && !this.reuseablePs) {
            try {
                this.userPS.close();
                this.userPS = null;
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
        }
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return l;
    }

    public RowLocation getRowLocation() {
        return null;
    }

    public ExecRow getCurrentRow() {
        return null;
    }

    GeneratedMethod getVTIConstructor() {
        return this.constructor;
    }

    boolean isReuseablePs() {
        return this.reuseablePs;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        if (this.allocatedRow == null) {
            this.allocatedRow = (ExecRow)this.row.invoke(this.activation);
        }
        return this.allocatedRow;
    }

    private int[] getProjectedColList() {
        FormatableBitSet formatableBitSet = this.referencedColumns;
        int n = formatableBitSet.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!formatableBitSet.isSet(i)) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (!formatableBitSet.isSet(i)) continue;
            nArray[n3++] = i + 1;
        }
        return nArray;
    }

    public void populateFromResultSet(ExecRow execRow) throws StandardException {
        try {
            DataTypeDescriptor[] dataTypeDescriptorArray = null;
            if (this.isDerbyStyleTableFunction) {
                dataTypeDescriptorArray = this.getReturnColumnTypes();
            }
            boolean[] blArray = this.setNullableColumnList();
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            int n = 1;
            for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
                if (this.referencedColumns != null && !this.referencedColumns.get(i)) {
                    if (this.pushedProjection) continue;
                    ++n;
                    continue;
                }
                dataValueDescriptorArray[i].setValueFromResultSet(this.userVTI, n, blArray[n]);
                ++n;
                if (!this.isDerbyStyleTableFunction) continue;
                DataTypeDescriptor dataTypeDescriptor = dataTypeDescriptorArray[i];
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[i];
                this.cast(dataTypeDescriptor, dataValueDescriptor);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public final int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    public final boolean isCompileTime() {
        return false;
    }

    public final String getOriginalSQL() {
        return this.activation.getPreparedStatement().getSource();
    }

    public final int getStatementIsolationLevel() {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getScanIsolationLevel()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void setSharedState(String string2, Serializable serializable2) {
        if (string2 == null) {
            return;
        }
        if (this.compileTimeConstants == null) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = this.activation.getPreparedStatement().getSavedObjects();
            // MONITORENTER : objectArray
            this.compileTimeConstants = (FormatableHashtable)objectArray[this.ctcNumber];
            if (this.compileTimeConstants == null) {
                this.compileTimeConstants = new FormatableHashtable();
                objectArray[this.ctcNumber] = this.compileTimeConstants;
            }
            // MONITOREXIT : objectArray2
        }
        if (serializable2 == null) {
            this.compileTimeConstants.remove(string2);
            return;
        }
        this.compileTimeConstants.put(string2, serializable2);
    }

    public Object getSharedState(String string2) {
        if (string2 == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(string2);
    }

    private DataTypeDescriptor[] getReturnColumnTypes() throws StandardException {
        if (this.returnColumnTypes == null) {
            TypeDescriptor[] typeDescriptorArray = this.returnType.getRowTypes();
            int n = typeDescriptorArray.length;
            this.returnColumnTypes = new DataTypeDescriptor[n];
            for (int i = 0; i < n; ++i) {
                this.returnColumnTypes[i] = DataTypeDescriptor.getType(typeDescriptorArray[i]);
            }
        }
        return this.returnColumnTypes;
    }

    private void cast(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        TypeId typeId = dataTypeDescriptor.getTypeId();
        if (!typeId.isBlobTypeId() && !typeId.isClobTypeId()) {
            if (typeId.isLongVarcharTypeId()) {
                this.castLongvarchar(dataTypeDescriptor, dataValueDescriptor);
            } else if (typeId.isLongVarbinaryTypeId()) {
                this.castLongvarbinary(dataTypeDescriptor, dataValueDescriptor);
            } else if (typeId.isDecimalTypeId()) {
                this.castDecimal(dataTypeDescriptor, dataValueDescriptor);
            } else {
                Object object = dataValueDescriptor.getObject();
                dataValueDescriptor.setObjectForCast(object, true, typeId.getCorrespondingJavaTypeName());
                if (typeId.variableLength()) {
                    VariableSizeDataValue variableSizeDataValue = (VariableSizeDataValue)((Object)dataValueDescriptor);
                    int n = typeId.isNumericTypeId() ? dataTypeDescriptor.getPrecision() : dataTypeDescriptor.getMaximumWidth();
                    variableSizeDataValue.setWidth(n, dataTypeDescriptor.getScale(), false);
                }
            }
        }
    }

    private void castLongvarchar(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.getLength() > 32700) {
            dataValueDescriptor.setValue(dataValueDescriptor.getString().substring(0, 32700));
        }
    }

    private void castLongvarbinary(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.getLength() > 32700) {
            byte[] byArray = dataValueDescriptor.getBytes();
            byte[] byArray2 = new byte[32700];
            System.arraycopy(byArray, 0, byArray2, 0, 32700);
            dataValueDescriptor.setValue(byArray2);
        }
    }

    private void castDecimal(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        VariableSizeDataValue variableSizeDataValue = (VariableSizeDataValue)((Object)dataValueDescriptor);
        variableSizeDataValue.setWidth(dataTypeDescriptor.getPrecision(), dataTypeDescriptor.getScale(), false);
    }
}

