/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class RevokeRoleConstantAction
extends DDLConstantAction {
    private List roleNames;
    private List grantees;
    private final boolean withAdminOption = false;

    public RevokeRoleConstantAction(List list2, List list3) {
        this.roleNames = list2;
        this.grantees = list3;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        String string2 = languageConnectionContext.getCurrentUserId(activation);
        dataDictionary.startWriting(languageConnectionContext);
        Iterator iterator2 = this.roleNames.iterator();
        while (iterator2.hasNext()) {
            String string3 = (String)iterator2.next();
            if (string3.equals("PUBLIC")) {
                throw StandardException.newException("4251B");
            }
            Iterator iterator3 = this.grantees.iterator();
            while (iterator3.hasNext()) {
                String string4 = (String)iterator3.next();
                RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(string3);
                if (roleGrantDescriptor == null) {
                    throw StandardException.newException("0P000", string3);
                }
                if (!string2.equals(languageConnectionContext.getDataDictionary().getAuthorizationDatabaseOwner())) {
                    throw StandardException.newException("4251A", "REVOKE role");
                }
                RoleGrantDescriptor roleGrantDescriptor2 = dataDictionary.getRoleGrantDescriptor(string3, string4, string2);
                if (roleGrantDescriptor2 != null) {
                    // empty if block
                }
                if (roleGrantDescriptor2 != null) {
                    String string5;
                    RoleClosureIterator roleClosureIterator = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string3, false);
                    while ((string5 = roleClosureIterator.next()) != null) {
                        roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(string5);
                        dataDictionary.getDependencyManager().invalidateFor(roleGrantDescriptor, 47, languageConnectionContext);
                    }
                    roleGrantDescriptor2.drop(languageConnectionContext);
                    continue;
                }
                activation.addWarning(StandardException.newWarning("01007", string3, string4));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.roleNames.iterator();
        while (object.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object.next().toString());
        }
        object = new StringBuffer();
        Iterator iterator2 = this.grantees.iterator();
        while (iterator2.hasNext()) {
            if (((StringBuffer)object).length() > 0) {
                ((StringBuffer)object).append(", ");
            }
            ((StringBuffer)object).append(iterator2.next().toString());
        }
        return "REVOKE " + stringBuffer.toString() + " FROM: " + ((StringBuffer)object).toString() + "\n";
    }
}

