/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropViewConstantAction
extends DDLConstantAction {
    private String fullTableName;
    private String tableName;
    private SchemaDescriptor sd;

    DropViewConstantAction(String string2, String string3, SchemaDescriptor schemaDescriptor) {
        this.fullTableName = string2;
        this.tableName = string3;
        this.sd = schemaDescriptor;
    }

    public String toString() {
        return "DROP VIEW " + this.fullTableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableName, this.sd, languageConnectionContext.getTransactionExecute());
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        if (tableDescriptor.getTableType() != 2) {
            throw StandardException.newException("X0Y16.S", this.fullTableName);
        }
        ViewDescriptor viewDescriptor = dataDictionary.getViewDescriptor(tableDescriptor);
        viewDescriptor.drop(languageConnectionContext, this.sd, tableDescriptor);
    }
}

