/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

public class DropTriggerConstantAction
extends DDLSingleTableConstantAction {
    private final String triggerName;
    private final SchemaDescriptor sd;

    DropTriggerConstantAction(SchemaDescriptor schemaDescriptor, String string2, UUID uUID) {
        super(uUID);
        this.sd = schemaDescriptor;
        this.triggerName = string2;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.tableId.toString());
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.lockTableForDDL(transactionController, tableDescriptor.getHeapConglomerateId(), true);
        tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X05.S", this.tableId.toString());
        }
        TriggerDescriptor triggerDescriptor = dataDictionary.getTriggerDescriptor(this.triggerName, this.sd);
        if (triggerDescriptor == null) {
            throw StandardException.newException("X0X81.S", (Object)"TRIGGER", (Object)(this.sd.getSchemaName() + "." + this.triggerName));
        }
        triggerDescriptor.drop(languageConnectionContext);
    }

    public String toString() {
        return "DROP TRIGGER " + this.triggerName;
    }
}

