/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.compile.ParserImpl;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;

public class GenericLanguageConnectionFactory
implements LanguageConnectionFactory,
CacheableFactory,
PropertySetCallback,
ModuleControl,
ModuleSupportable {
    private ExecutionFactory ef;
    private OptimizerFactory of;
    private TypeCompilerFactory tcf;
    private DataValueFactory dvf;
    private UUIDFactory uuidFactory;
    private JavaFactory javaFactory;
    private ClassFactory classFactory;
    private NodeFactory nodeFactory;
    private PropertyFactory pf;
    private int nextLCCInstanceNumber;
    private int cacheSize = 100;
    private CacheManager singleStatementCache;

    public Statement getStatement(SchemaDescriptor schemaDescriptor, String string2, boolean bl) {
        return new GenericStatement(schemaDescriptor, string2, bl);
    }

    public LanguageConnectionContext newLanguageConnectionContext(ContextManager contextManager, TransactionController transactionController, LanguageFactory languageFactory, Database database, String string2, String string3, String string4) throws StandardException {
        return new GenericLanguageConnectionContext(contextManager, transactionController, languageFactory, this, database, string2, this.getNextLCCInstanceNumber(), string3, string4);
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        return new CachedStatement();
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    public JavaFactory getJavaFactory() {
        return this.javaFactory;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    public PropertyFactory getPropertyFactory() {
        return this.pf;
    }

    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.tcf;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    public boolean canSupport(Properties properties) {
        return Monitor.isDesiredType(properties, 130);
    }

    private int statementCacheSize(Properties properties) {
        String string2 = null;
        string2 = PropertyUtil.getPropertyFromSet(properties, "derby.language.statementCacheSize");
        if (string2 != null) {
            try {
                this.cacheSize = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.cacheSize = 100;
            }
        }
        return this.cacheSize;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.dvf = (DataValueFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.javaFactory = (JavaFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.compiler.JavaFactory");
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.classFactory = (ClassFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.services.loader.ClassFactory");
        if (this.classFactory == null) {
            this.classFactory = (ClassFactory)Monitor.findSystemModule("org.apache.derby.iapi.services.loader.ClassFactory");
        }
        this.setValidation();
        this.ef = (ExecutionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", properties);
        this.of = (OptimizerFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.compile.OptimizerFactory", properties);
        this.tcf = (TypeCompilerFactory)Monitor.startSystemModule("org.apache.derby.iapi.sql.compile.TypeCompilerFactory");
        this.nodeFactory = (NodeFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.compile.NodeFactory", properties);
        int n = this.statementCacheSize(properties);
        if (n > 0) {
            CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
            this.singleStatementCache = cacheFactory.newCacheManager(this, "StatementCache", n / 4, n);
        }
    }

    public CacheManager getStatementCache() {
        return this.singleStatementCache;
    }

    public void stop() {
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string2, Serializable serializable2, Dictionary dictionary) throws StandardException {
        if (serializable2 == null) {
            return true;
        }
        if (string2.equals("derby.database.defaultConnectionMode")) {
            String string3 = (String)((Object)serializable2);
            if (!(string3 == null || StringUtil.SQLEqualsIgnoreCase(string3, "NOACCESS") || StringUtil.SQLEqualsIgnoreCase(string3, "READONLYACCESS") || StringUtil.SQLEqualsIgnoreCase(string3, "FULLACCESS"))) {
                throw StandardException.newException("4250B", (Object)string2, (Object)string3);
            }
            return true;
        }
        if (string2.equals("derby.database.readOnlyAccessUsers") || string2.equals("derby.database.fullAccessUsers")) {
            String[] stringArray;
            String string4 = (String)((Object)serializable2);
            try {
                stringArray = IdUtil.parseIdList(string4);
            }
            catch (StandardException standardException) {
                throw StandardException.newException("4250B", standardException, (Object)string2, (Object)string4);
            }
            String string5 = IdUtil.dups(stringArray);
            if (string5 != null) {
                throw StandardException.newException("4250D", (Object)string2, (Object)string5);
            }
            String string6 = string2.equals("derby.database.readOnlyAccessUsers") ? (String)dictionary.get("derby.database.fullAccessUsers") : (String)dictionary.get("derby.database.readOnlyAccessUsers");
            String[] stringArray2 = IdUtil.parseIdList(string6);
            String string7 = IdUtil.intersect(stringArray, stringArray2);
            if (string7 != null) {
                throw StandardException.newException("4250C", string7);
            }
            return true;
        }
        return false;
    }

    public Serviceable apply(String string2, Serializable serializable2, Dictionary dictionary) {
        return null;
    }

    public Serializable map(String string2, Serializable serializable2, Dictionary dictionary) {
        return null;
    }

    protected void setValidation() throws StandardException {
        this.pf = (PropertyFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        this.pf.addPropertySetNotification(this);
    }

    public Parser newParser(CompilerContext compilerContext) {
        return new ParserImpl(compilerContext);
    }

    protected synchronized int getNextLCCInstanceNumber() {
        return this.nextLCCInstanceNumber++;
    }
}

