/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;
import org.apache.derby.impl.sql.compile.UserDefinedTypeCompiler;

public class TypeCompilerFactoryImpl
implements TypeCompilerFactory {
    private static final String PACKAGE_NAME = "org.apache.derby.impl.sql.compile.";
    static TypeCompiler bitTypeCompiler;
    static TypeCompiler booleanTypeCompiler;
    static TypeCompiler charTypeCompiler;
    static TypeCompiler decimalTypeCompiler;
    static TypeCompiler doubleTypeCompiler;
    static TypeCompiler intTypeCompiler;
    static TypeCompiler longintTypeCompiler;
    static TypeCompiler longvarbitTypeCompiler;
    static TypeCompiler longvarcharTypeCompiler;
    static TypeCompiler realTypeCompiler;
    static TypeCompiler smallintTypeCompiler;
    static TypeCompiler tinyintTypeCompiler;
    static TypeCompiler dateTypeCompiler;
    static TypeCompiler timeTypeCompiler;
    static TypeCompiler timestampTypeCompiler;
    static TypeCompiler varbitTypeCompiler;
    static TypeCompiler varcharTypeCompiler;
    static TypeCompiler refTypeCompiler;
    static TypeCompiler blobTypeCompiler;
    static TypeCompiler clobTypeCompiler;
    static TypeCompiler xmlTypeCompiler;

    public TypeCompiler getTypeCompiler(TypeId typeId) {
        return TypeCompilerFactoryImpl.staticGetTypeCompiler(typeId);
    }

    static TypeCompiler staticGetTypeCompiler(TypeId typeId) {
        switch (typeId.getJDBCTypeId()) {
            case -2: {
                bitTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.BitTypeCompiler", bitTypeCompiler, typeId);
                return bitTypeCompiler;
            }
            case -7: 
            case 16: {
                booleanTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.BooleanTypeCompiler", booleanTypeCompiler, typeId);
                return booleanTypeCompiler;
            }
            case 1: {
                String string2 = typeId.getSQLTypeName();
                charTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.CharTypeCompiler", charTypeCompiler, typeId);
                return charTypeCompiler;
            }
            case 2: 
            case 3: {
                decimalTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.NumericTypeCompiler", decimalTypeCompiler, typeId);
                return decimalTypeCompiler;
            }
            case 8: {
                doubleTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.NumericTypeCompiler", doubleTypeCompiler, typeId);
                return doubleTypeCompiler;
            }
            case 4: {
                intTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.NumericTypeCompiler", intTypeCompiler, typeId);
                return intTypeCompiler;
            }
            case -5: {
                longintTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.NumericTypeCompiler", longintTypeCompiler, typeId);
                return longintTypeCompiler;
            }
            case 2004: {
                blobTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.LOBTypeCompiler", blobTypeCompiler, typeId);
                return blobTypeCompiler;
            }
            case -4: {
                longvarbitTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.BitTypeCompiler", longvarbitTypeCompiler, typeId);
                return longvarbitTypeCompiler;
            }
            case 2005: {
                String string3 = typeId.getSQLTypeName();
                clobTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.CLOBTypeCompiler", clobTypeCompiler, typeId);
                return clobTypeCompiler;
            }
            case -1: {
                String string4 = typeId.getSQLTypeName();
                longvarcharTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.CharTypeCompiler", longvarcharTypeCompiler, typeId);
                return longvarcharTypeCompiler;
            }
            case 7: {
                realTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.NumericTypeCompiler", realTypeCompiler, typeId);
                return realTypeCompiler;
            }
            case 5: {
                smallintTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.NumericTypeCompiler", smallintTypeCompiler, typeId);
                return smallintTypeCompiler;
            }
            case -6: {
                tinyintTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.NumericTypeCompiler", tinyintTypeCompiler, typeId);
                return tinyintTypeCompiler;
            }
            case 91: {
                dateTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.DateTypeCompiler", dateTypeCompiler, typeId);
                return dateTypeCompiler;
            }
            case 92: {
                timeTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.TimeTypeCompiler", timeTypeCompiler, typeId);
                return timeTypeCompiler;
            }
            case 93: {
                timestampTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.TimestampTypeCompiler", timestampTypeCompiler, typeId);
                return timestampTypeCompiler;
            }
            case -3: {
                varbitTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.BitTypeCompiler", varbitTypeCompiler, typeId);
                return varbitTypeCompiler;
            }
            case 12: {
                String string5 = typeId.getSQLTypeName();
                varcharTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.CharTypeCompiler", varcharTypeCompiler, typeId);
                return varcharTypeCompiler;
            }
            case 1111: 
            case 2000: {
                if (typeId.isRefTypeId()) {
                    refTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.RefTypeCompiler", refTypeCompiler, typeId);
                    return refTypeCompiler;
                }
                UserDefinedTypeCompiler userDefinedTypeCompiler = new UserDefinedTypeCompiler();
                userDefinedTypeCompiler.setTypeId(typeId);
                return userDefinedTypeCompiler;
            }
            case 2009: {
                xmlTypeCompiler = TypeCompilerFactoryImpl.getAnInstance("org.apache.derby.impl.sql.compile.XMLTypeCompiler", xmlTypeCompiler, typeId);
                return xmlTypeCompiler;
            }
        }
        return null;
    }

    private static TypeCompiler getAnInstance(String string2, TypeCompiler typeCompiler, TypeId typeId) {
        if (typeCompiler == null) {
            ReflectiveOperationException reflectiveOperationException = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
                typeCompiler = (TypeCompiler)clazz.newInstance();
                ((BaseTypeCompiler)typeCompiler).setTypeId(typeId);
            }
            catch (ClassNotFoundException classNotFoundException) {
                reflectiveOperationException = classNotFoundException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                reflectiveOperationException = instantiationException;
            }
        }
        return typeCompiler;
    }
}

