/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.execute.GenericPrivilegeInfo;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class PrivilegeNode
extends QueryTreeNode {
    public static final int TABLE_PRIVILEGES = 0;
    public static final int ROUTINE_PRIVILEGES = 1;
    public static final int SEQUENCE_PRIVILEGES = 2;
    public static final int UDT_PRIVILEGES = 3;
    private int objectType;
    private TableName objectName;
    private TablePrivilegesNode specificPrivileges;
    private RoutineDesignator routineDesignator;
    private String privilege;
    private boolean restrict;
    private Provider dependencyProvider;

    public void init(Object object, Object object2, Object object3) throws StandardException {
        this.objectType = (Integer)object;
        switch (this.objectType) {
            case 0: {
                this.objectName = (TableName)object2;
                this.specificPrivileges = (TablePrivilegesNode)object3;
                break;
            }
            case 1: {
                this.routineDesignator = (RoutineDesignator)object2;
                this.objectName = this.routineDesignator.name;
                break;
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
    }

    public void init(Object object, Object object2, Object object3, Object object4) {
        this.objectType = (Integer)object;
        this.objectName = (TableName)object2;
        this.privilege = (String)object3;
        this.restrict = (Boolean)object4;
    }

    public QueryTreeNode bind(HashMap hashMap, List list2, boolean bl) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.objectName.getSchemaName(), true);
        this.objectName.setSchemaName(schemaDescriptor.getSchemaName());
        if (list2.contains(schemaDescriptor.getAuthorizationId())) {
            throw StandardException.newException("42509", this.objectName.getFullTableName());
        }
        switch (this.objectType) {
            case 0: {
                if (schemaDescriptor.isSystemSchema()) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                TableDescriptor tableDescriptor = this.getTableDescriptor(this.objectName.getTableName(), schemaDescriptor);
                if (tableDescriptor == null) {
                    throw StandardException.newException("42X05", this.objectName);
                }
                if (this.isSessionSchema(schemaDescriptor.getSchemaName())) {
                    throw StandardException.newException("XCL51.S");
                }
                if (tableDescriptor.getTableType() != 0 && tableDescriptor.getTableType() != 2) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                this.specificPrivileges.bind(tableDescriptor, bl);
                this.dependencyProvider = tableDescriptor;
                break;
            }
            case 1: {
                if (!schemaDescriptor.isSchemaWithGrantableRoutines()) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                AliasDescriptor aliasDescriptor = null;
                RoutineAliasInfo routineAliasInfo = null;
                List list3 = this.getDataDictionary().getRoutineList(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), this.routineDesignator.isFunction ? (char)'F' : 'P');
                if (this.routineDesignator.paramTypeList == null) {
                    if (list3.size() > 1) {
                        throw StandardException.newException(this.routineDesignator.isFunction ? "42X46" : "42X47", this.objectName.getFullTableName());
                    }
                    if (list3.size() != 1) {
                        if (this.routineDesignator.isFunction) {
                            throw StandardException.newException("42Y03.S.2", this.objectName.getFullTableName());
                        }
                        throw StandardException.newException("42Y03.S.1", this.objectName.getFullTableName());
                    }
                    aliasDescriptor = (AliasDescriptor)list3.get(0);
                } else {
                    int n;
                    boolean bl2 = false;
                    block6: for (int i = list3.size() - 1; !bl2 && i >= 0; --i) {
                        aliasDescriptor = (AliasDescriptor)list3.get(i);
                        routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                        n = routineAliasInfo.getParameterCount();
                        if (n != this.routineDesignator.paramTypeList.size()) continue;
                        TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
                        bl2 = true;
                        for (int j = 0; j < n; ++j) {
                            if (typeDescriptorArray[j].equals(this.routineDesignator.paramTypeList.get(j))) continue;
                            bl2 = false;
                            continue block6;
                        }
                    }
                    if (!bl2) {
                        StringBuffer stringBuffer = new StringBuffer(this.objectName.getFullTableName());
                        stringBuffer.append("(");
                        for (n = 0; n < this.routineDesignator.paramTypeList.size(); ++n) {
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(this.routineDesignator.paramTypeList.get(n).toString());
                        }
                        throw StandardException.newException("42Y03.S.0", stringBuffer.toString());
                    }
                }
                this.routineDesignator.setAliasDescriptor(aliasDescriptor);
                this.dependencyProvider = aliasDescriptor;
                break;
            }
            case 2: {
                this.dependencyProvider = this.getDataDictionary().getSequenceDescriptor(schemaDescriptor, this.objectName.getTableName());
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", (Object)"SEQUENCE", (Object)this.objectName.getFullTableName());
            }
            case 3: {
                this.dependencyProvider = this.getDataDictionary().getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.objectName.getTableName(), 'A');
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", (Object)"TYPE", (Object)this.objectName.getFullTableName());
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
        if (this.dependencyProvider != null && hashMap.get(this.dependencyProvider) == null) {
            this.getCompilerContext().createDependency(this.dependencyProvider);
            hashMap.put(this.dependencyProvider, this.dependencyProvider);
        }
        return this;
    }

    PrivilegeInfo makePrivilegeInfo() throws StandardException {
        switch (this.objectType) {
            case 0: {
                return this.specificPrivileges.makePrivilegeInfo();
            }
            case 1: {
                return this.routineDesignator.makePrivilegeInfo();
            }
            case 2: 
            case 3: {
                return new GenericPrivilegeInfo((PrivilegedSQLObject)this.dependencyProvider, this.privilege, this.restrict);
            }
        }
        throw this.unimplementedFeature();
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException("XSCB3.S");
    }
}

