/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;

public class ModifyColumnNode
extends ColumnDefinitionNode {
    int columnPosition = -1;
    UUID oldDefaultUUID;

    UUID getOldDefaultUUID() {
        return this.oldDefaultUUID;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public void checkUserType(TableDescriptor tableDescriptor) throws StandardException {
        if (this.getNodeType() != 186) {
            return;
        }
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)tableDescriptor.getName());
        }
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
        this.setNullability(dataTypeDescriptor.isNullable());
        if (!dataTypeDescriptor.getTypeId().equals(this.getType().getTypeId())) {
            throw StandardException.newException("42Z15", this.name);
        }
        String string2 = this.getType().getTypeName();
        if (!(string2.equals("VARCHAR") || string2.equals("VARCHAR () FOR BIT DATA") || string2.equals("BLOB") || string2.equals("CLOB"))) {
            throw StandardException.newException("42Z16");
        }
        if (this.getType().getMaximumWidth() < dataTypeDescriptor.getMaximumWidth()) {
            throw StandardException.newException("42Z17", this.name);
        }
    }

    public void checkExistingConstraints(TableDescriptor tableDescriptor) throws StandardException {
        if (this.getNodeType() != 186 && this.getNodeType() != 187 && this.getNodeType() != 193) {
            return;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int[] nArray = new int[]{this.columnPosition};
        for (int i = 0; i < constraintDescriptorList.size(); ++i) {
            Object object;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof KeyConstraintDescriptor) || !constraintDescriptor.columnIntersects(nArray)) continue;
            int n = constraintDescriptor.getConstraintType();
            if (n == 6 && this.getNodeType() == 186) {
                throw StandardException.newException("42Z18", (Object)this.name, (Object)constraintDescriptor.getConstraintName());
            }
            if (!dataDictionary.checkVersion(160, null) && this.getNodeType() == 187 && constraintDescriptor.getConstraintType() == 3) {
                throw StandardException.newException("42Z20", this.name);
            }
            if (this.getNodeType() == 187 && constraintDescriptor.getConstraintType() == 2) {
                object = this.getLanguageConnectionContext().getDataDictionary().checkVersion(160, null) ? "42Z20.S.1" : "42Z20";
                throw StandardException.newException((String)object, this.name);
            }
            object = dataDictionary.getForeignKeys(constraintDescriptor.getUUID());
            if (((ArrayList)object).size() > 0) {
                throw StandardException.newException("42Z19", (Object)this.name, (Object)((ConstraintDescriptorList)object).elementAt(0).getConstraintName());
            }
            this.getCompilerContext().createDependency(constraintDescriptor);
        }
    }

    public void useExistingCollation(TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)tableDescriptor.getName());
        }
        if (this.getType() != null && this.getType().getTypeId().isStringTypeId()) {
            this.setCollationType(columnDescriptor.getType().getCollationType());
        }
    }

    int getAction() {
        switch (this.getNodeType()) {
            case 97: {
                if (this.autoinc_create_or_modify_Start_Increment == 1L) {
                    return 5;
                }
                if (this.autoinc_create_or_modify_Start_Increment == 2L) {
                    return 6;
                }
                return 7;
            }
            case 186: {
                return 2;
            }
            case 187: {
                return 3;
            }
            case 193: {
                return 4;
            }
            case 113: {
                return 1;
            }
        }
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)tableDescriptor.getName());
        }
        DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
        this.oldDefaultUUID = defaultDescriptor == null ? null : defaultDescriptor.getUUID();
        this.columnPosition = columnDescriptor.getPosition();
        if (this.getNodeType() != 97) {
            return;
        }
        if (this.keepCurrentDefault) {
            this.defaultInfo = (DefaultInfoImpl)columnDescriptor.getDefaultInfo();
        } else if (columnDescriptor.hasGenerationClause()) {
            throw StandardException.newException("42XA7", columnDescriptor.getColumnName());
        }
        if (this.autoinc_create_or_modify_Start_Increment == 1L) {
            this.autoincrementIncrement = columnDescriptor.getAutoincInc();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 2L) {
            this.autoincrementStart = columnDescriptor.getAutoincStart();
        }
        this.type = columnDescriptor.getType();
        this.validateDefault(dataDictionary, tableDescriptor);
    }

    private ColumnDescriptor getLocalColumnDescriptor(String string2, TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string2);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)string2, (Object)tableDescriptor.getName());
        }
        return columnDescriptor;
    }

    public void validateAutoincrement(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor;
        if (this.getNodeType() == 187 && (columnDescriptor = this.getLocalColumnDescriptor(this.name, tableDescriptor)).isAutoincrement()) {
            throw StandardException.newException("42Z26", this.getColumnName());
        }
        if (this.autoincrementVerify && !(columnDescriptor = this.getLocalColumnDescriptor(this.name, tableDescriptor)).isAutoincrement()) {
            throw StandardException.newException("42837", (Object)tableDescriptor.getQualifiedName(), (Object)this.name);
        }
        if (!this.isAutoincrement) {
            return;
        }
        super.validateAutoincrement(dataDictionary, tableDescriptor, n);
        if (this.getType().isNullable()) {
            throw StandardException.newException("42Z27", this.getColumnName());
        }
    }
}

