/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromSubquery
extends FromTable {
    ResultSetNode subquery;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    private SchemaDescriptor origCompilationSchema = null;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        super.init(object6, object8);
        this.subquery = (ResultSetNode)object;
        this.orderByList = (OrderByList)object2;
        this.offset = (ValueNode)object3;
        this.fetchFirst = (ValueNode)object4;
        this.hasJDBClimitClause = object5 == null ? false : (Boolean)object5;
        this.resultColumns = (ResultColumnList)object7;
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getSubquery() {
        return this.subquery;
    }

    protected FromTable getFromTableByName(String string2, String string3, boolean bl) throws StandardException {
        if (string3 != null && this.origTableName != null && !string3.equals(this.origTableName.schemaName)) {
            return null;
        }
        if (this.getExposedName().equals(string2)) {
            return this;
        }
        return null;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        this.subquery = this.subquery.bindNonVTITables(dataDictionary, fromList);
        return this;
    }

    public ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        this.subquery = this.subquery.bindVTITables(fromList);
        return this;
    }

    public void rejectParameters() throws StandardException {
        this.subquery.rejectParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindExpressions(FromList fromList) throws StandardException {
        FromList fromList2 = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumnList resultColumnList = this.resultColumns;
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.subquery);
        }
        FromList fromList3 = fromList2;
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.origCompilationSchema != null) {
            compilerContext.pushCompilationSchema(this.origCompilationSchema);
        }
        try {
            this.subquery.bindExpressions(fromList3);
            this.subquery.bindResultColumns(fromList3);
        }
        finally {
            if (this.origCompilationSchema != null) {
                compilerContext.popCompilationSchema();
            }
        }
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.subquery);
        }
        FromSubquery.bindOffsetFetch(this.offset, this.fetchFirst);
        ResultColumnList resultColumnList2 = this.subquery.getResultColumns();
        if (this.resultColumns != null && this.resultColumns.getCountMismatchAllowed() && this.resultColumns.size() < resultColumnList2.size()) {
            for (int i = resultColumnList2.size() - 1; i >= this.resultColumns.size(); --i) {
                resultColumnList2.removeElementAt(i);
            }
        }
        ResultColumnList resultColumnList3 = resultColumnList2.copyListAndObjects();
        resultColumnList3.genVirtualColumnNodes(this.subquery, this.subquery.getResultColumns());
        this.resultColumns = resultColumnList3;
        if (resultColumnList != null) {
            this.resultColumns.propagateDCLInfo(resultColumnList, this.correlationName);
        }
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        String string2 = columnReference.getTableName();
        if (columnReference.getGeneratedToReplaceAggregate()) {
            resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName());
        } else if (string2 == null || string2.equals(this.correlationName)) {
            resultColumn = this.resultColumns.getAtMostOneResultColumn(columnReference, this.correlationName, false);
        }
        if (resultColumn != null) {
            columnReference.setTableNumber(this.tableNumber);
            columnReference.setColumnNumber(resultColumn.getColumnPosition());
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.subquery.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.subquery.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        this.subquery = this.subquery.preprocess(n, groupByList, fromList);
        if ((groupByList == null || groupByList.size() == 0) && this.tableProperties == null && this.subquery.flattenableInFromSubquery(fromList)) {
            this.setReferencedTableMap(this.subquery.getReferencedTableMap());
            return this;
        }
        return this.extractSubquery(n);
    }

    public ResultSetNode extractSubquery(int n) throws StandardException {
        ResultSetNode resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(151, this.subquery, this.resultColumns, null, null, null, null, this.tableProperties, this.getContextManager());
        JBitSet jBitSet = new JBitSet(n);
        jBitSet.set(this.tableNumber);
        resultSetNode.setReferencedTableMap(jBitSet);
        ((FromTable)resultSetNode).setTableNumber(this.tableNumber);
        return resultSetNode;
    }

    public FromList flatten(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        FromList fromList = null;
        this.resultColumns.setRedundant();
        this.subquery.getResultColumns().setRedundant();
        if (this.subquery instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.subquery;
            fromList = selectNode.getFromList();
            if (selectNode.getWherePredicates().size() > 0) {
                predicateList.destructiveAppend(selectNode.getWherePredicates());
            }
            if (selectNode.getWhereSubquerys().size() > 0) {
                subqueryList.destructiveAppend(selectNode.getWhereSubquerys());
            }
        } else if (!(this.subquery instanceof RowResultSetNode)) {
            // empty if block
        }
        resultColumnList.remapColumnReferencesToExpressions();
        predicateList.remapColumnReferencesToExpressions();
        if (groupByList != null) {
            groupByList.remapColumnReferencesToExpressions();
        }
        if (valueNode != null) {
            valueNode.remapColumnReferencesToExpressions();
        }
        return fromList;
    }

    public String getExposedName() {
        return this.correlationName;
    }

    public ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = null;
        TableName tableName2 = tableName != null ? this.makeTableName(tableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (tableName != null && !tableName.equals(tableName2)) {
            return null;
        }
        TableName tableName3 = this.makeTableName(null, this.correlationName);
        resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.resultColumns.visibleSize();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (resultColumn.isGenerated()) continue;
            String string2 = resultColumn.getName();
            boolean bl = resultColumn.isNameGenerated();
            TableName tableName4 = tableName3;
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, string2, tableName4, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string2, valueNode, this.getContextManager());
            resultColumn.setNameGenerated(bl);
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public boolean referencesTarget(String string2, boolean bl) throws StandardException {
        return this.subquery.referencesTarget(string2, bl);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.subquery.referencesSessionSchema();
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        this.subquery.bindUntypedNullsToResultColumns(resultColumnList);
    }

    void decrementLevel(int n) {
        super.decrementLevel(n);
        this.subquery.decrementLevel(n);
    }

    public void setOrigCompilationSchema(SchemaDescriptor schemaDescriptor) {
        this.origCompilationSchema = schemaDescriptor;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        this.subquery.accept(visitor);
        if (this.orderByList != null) {
            this.orderByList.accept(visitor);
        }
        if (this.offset != null) {
            this.offset.accept(visitor);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst.accept(visitor);
        }
    }
}

