/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class DropAliasNode
extends DDLStatementNode {
    private char aliasType;
    private char nameSpace;

    public void init(Object object, Object object2) throws StandardException {
        TableName tableName = (TableName)object;
        this.initAndCheck(tableName);
        this.aliasType = ((Character)object2).charValue();
        switch (this.aliasType) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            case 'A': {
                this.nameSpace = (char)65;
                break;
            }
        }
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public String statementToString() {
        return "DROP ".concat(DropAliasNode.aliasTypeName(this.aliasType));
    }

    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String string2 = this.getRelativeName();
        AliasDescriptor aliasDescriptor = null;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (schemaDescriptor.getUUID() != null) {
            aliasDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string2, this.nameSpace);
        }
        if (aliasDescriptor == null) {
            throw StandardException.newException("42Y55", (Object)this.statementToString(), (Object)string2);
        }
        if (aliasDescriptor.getSystemAlias()) {
            throw StandardException.newException("42Y71", string2);
        }
        this.getCompilerContext().createDependency(aliasDescriptor);
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropAliasConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.nameSpace);
    }

    private static String aliasTypeName(char c) {
        String string2 = null;
        switch (c) {
            case 'P': {
                string2 = "PROCEDURE";
                break;
            }
            case 'F': {
                string2 = "FUNCTION";
                break;
            }
            case 'S': {
                string2 = "SYNONYM";
                break;
            }
            case 'A': {
                string2 = "TYPE";
            }
        }
        return string2;
    }
}

