/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class CharConstantNode
extends ConstantNode {
    public void init(Object object) throws StandardException {
        if (object instanceof TypeId) {
            super.init(object, Boolean.TRUE, ReuseFactory.getInteger(0));
        } else {
            String string2 = (String)object;
            super.init(TypeId.CHAR_ID, string2 == null ? Boolean.TRUE : Boolean.FALSE, string2 != null ? ReuseFactory.getInteger(string2.length()) : ReuseFactory.getInteger(0));
            this.setValue(this.getDataValueFactory().getCharDataValue(string2));
        }
    }

    public void init(Object object, Object object2) throws StandardException {
        String string2 = (String)object;
        int n = (Integer)object2;
        super.init(TypeId.CHAR_ID, string2 == null ? Boolean.TRUE : Boolean.FALSE, object2);
        if (string2.length() > n) {
            throw StandardException.newException("22001", (Object)"CHAR", (Object)string2, (Object)String.valueOf(n));
        }
        while (string2.length() < n) {
            string2 = string2 + ' ';
        }
        this.setValue(this.getDataValueFactory().getCharDataValue(string2));
    }

    public String getString() throws StandardException {
        return this.value.getString();
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getString();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.setCollationUsingCompilationSchema();
        this.value = ((StringDataValue)this.value).getValue(this.getLanguageConnectionContext().getDataValueFactory().getCharacterCollator(this.getTypeServices().getCollationType()));
        return this;
    }

    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.push(this.getString());
    }
}

