/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public class BitConstantNode
extends ConstantNode {
    private int bitLength;

    public void init(Object object) throws StandardException {
        super.init(object, Boolean.TRUE, ReuseFactory.getInteger(0));
    }

    public void init(Object object, Object object2) throws StandardException {
        String string2 = (String)object;
        byte[] byArray = StringUtil.fromHexString(string2, 0, string2.length());
        Integer n = (Integer)object2;
        this.bitLength = n;
        this.init(TypeId.getBuiltInTypeId(-2), Boolean.FALSE, n);
        BitDataValue bitDataValue = this.getDataValueFactory().getBitDataValue(byArray);
        bitDataValue.setWidth(this.bitLength, 0, false);
        this.setValue(bitDataValue);
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getBytes();
    }

    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        byte[] byArray = this.value.getBytes();
        String string2 = StringUtil.toHexString(byArray, 0, byArray.length);
        methodBuilder.push(string2);
        methodBuilder.push(0);
        methodBuilder.push(string2.length());
        methodBuilder.callMethod((short)184, "org.apache.derby.iapi.util.StringUtil", "fromHexString", "byte[]", 3);
    }
}

