/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class AggregateNode
extends UnaryOperatorNode {
    private boolean distinct;
    private AggregateDefinition uad;
    private StringBuffer aggregatorClassName;
    private String aggregateDefinitionClassName;
    private Class aggregateDefinitionClass;
    private ClassInspector classInspector;
    private String aggregateName;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object);
        this.aggregateName = (String)object4;
        if (object2 instanceof String) {
            this.aggregateDefinitionClassName = (String)object2;
            this.distinct = (Boolean)object3;
        } else {
            this.aggregateDefinitionClass = (Class)object2;
            this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
            if (!this.aggregateDefinitionClass.equals(MaxMinAggregateDefinition.class)) {
                this.distinct = (Boolean)object3;
            }
        }
    }

    public ValueNode replaceAggregatesWithColumnReferences(ResultColumnList resultColumnList, int n) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext compilerContext = this.getCompilerContext();
            String string2 = "SQLCol" + compilerContext.getNextColumnNumber();
            this.generatedRC = (ResultColumn)this.getNodeFactory().getNode(80, string2, this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = (ColumnReference)this.getNodeFactory().getNode(62, this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (n != -1) {
                this.generatedRef.setTableNumber(n);
            }
            resultColumnList.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceAggregate();
        } else {
            resultColumnList.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    AggregateDefinition getAggregateDefinition() {
        return this.uad;
    }

    public ResultColumn getGeneratedRC() {
        return this.generatedRC;
    }

    public ColumnReference getGeneratedRef() {
        return this.generatedRef;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        ClassFactory classFactory = this.getClassFactory();
        this.classInspector = classFactory.getClassInspector();
        this.instantiateAggDef();
        vector.add(this);
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.operand != null) {
            int n = this.orReliability(16384);
            this.bindOperand(fromList, subqueryList, vector);
            compilerContext.setReliability(n);
            HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(this.getClass(), ResultSetNode.class);
            this.operand.accept(hasNodeVisitor);
            if (hasNodeVisitor.hasNode()) {
                throw StandardException.newException("42Y33", this.aggregateName);
            }
            SelectNode.checkNoWindowFunctions(this.operand, this.aggregateName);
            dataTypeDescriptor = this.operand.getTypeServices();
            if (this.uad instanceof CountAggregateDefinition && !dataTypeDescriptor.isNullable()) {
                this.setOperator(this.aggregateName);
                this.setMethodName(this.aggregateName);
            }
            if (this.distinct && !this.operand.getTypeId().orderable(classFactory)) {
                throw StandardException.newException("X0X67.S", dataTypeDescriptor.getTypeId().getSQLTypeName());
            }
            if (this.operand instanceof UntypedNullConstantNode) {
                throw StandardException.newException("42Y83", this.aggregateName);
            }
        }
        this.aggregatorClassName = new StringBuffer();
        DataTypeDescriptor dataTypeDescriptor2 = this.uad.getAggregator(dataTypeDescriptor, this.aggregatorClassName);
        if (dataTypeDescriptor2 == null) {
            throw StandardException.newException("42Y22", (Object)this.aggregateName, (Object)this.operand.getTypeId().getSQLTypeName());
        }
        this.checkAggregatorClassName(this.aggregatorClassName.toString());
        this.setType(dataTypeDescriptor2);
        return this;
    }

    private void checkAggregatorClassName(String string2) throws StandardException {
        this.verifyClassExist(string2);
        if (!this.classInspector.assignableTo(string2, "org.apache.derby.iapi.sql.execute.ExecAggregator")) {
            throw StandardException.newException("42Y32", (Object)string2, (Object)this.aggregateName, (Object)this.operand.getTypeId().getSQLTypeName());
        }
    }

    private void instantiateAggDef() throws StandardException {
        AggregateDefinition aggregateDefinition;
        String string2;
        Class clazz = this.aggregateDefinitionClass;
        if (clazz == null) {
            string2 = this.aggregateDefinitionClassName;
            this.verifyClassExist(string2);
            try {
                clazz = this.classInspector.getClass(string2);
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        string2 = null;
        try {
            string2 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        if (!(string2 instanceof AggregateDefinition)) {
            throw StandardException.newException("42Y00", this.aggregateDefinitionClassName);
        }
        if (string2 instanceof MaxMinAggregateDefinition) {
            aggregateDefinition = (MaxMinAggregateDefinition)((Object)string2);
            if (this.aggregateName.equals("MAX")) {
                ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(true);
            } else {
                ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(false);
            }
        }
        if (string2 instanceof SumAvgAggregateDefinition) {
            aggregateDefinition = (SumAvgAggregateDefinition)((Object)string2);
            if (this.aggregateName.equals("SUM")) {
                ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(true);
            } else {
                ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(false);
            }
        }
        this.uad = (AggregateDefinition)((Object)string2);
        this.setOperator(this.aggregateName);
        this.setMethodName(this.aggregateDefinitionClassName);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getAggregatorClassName() {
        return this.aggregatorClassName.toString();
    }

    public String getAggregateName() {
        return this.aggregateName;
    }

    public ResultColumn getNewAggregatorResultColumn(DataDictionary dataDictionary) throws StandardException {
        String string2 = this.aggregatorClassName.toString();
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string2);
        ConstantNode constantNode = this.getNullNode(dataTypeDescriptor);
        constantNode.bindExpression(null, null, null);
        return (ResultColumn)this.getNodeFactory().getNode(80, this.aggregateName, constantNode, this.getContextManager());
    }

    public ResultColumn getNewExpressionResultColumn(DataDictionary dataDictionary) throws StandardException {
        ValueNode valueNode = this.operand == null ? this.getNewNullResultExpression() : this.operand;
        return (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate expression", valueNode, this.getContextManager());
    }

    public ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    public String toString() {
        return "";
    }

    public boolean isConstant() {
        return false;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return false;
    }
}

