/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSROLESRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSROLES";
    private static final int SYSROLES_COLUMN_COUNT = 6;
    private static final int SYSROLES_ROLE_UUID = 1;
    private static final int SYSROLES_ROLEID = 2;
    private static final int SYSROLES_GRANTEE = 3;
    private static final int SYSROLES_GRANTOR = 4;
    private static final int SYSROLES_WITHADMINOPTION = 5;
    static final int SYSROLES_ISDEF = 6;
    private static final int[][] indexColumnPositions = new int[][]{{2, 3, 4}, {2, 6}, {1}};
    static final int SYSROLES_ROLEID_COLPOS_IN_INDEX_ID_EE_OR = 1;
    static final int SYSROLES_GRANTEE_COLPOS_IN_INDEX_ID_EE_OR = 2;
    static final int SYSROLES_INDEX_ID_EE_OR_IDX = 0;
    static final int SYSROLES_INDEX_ID_DEF_IDX = 1;
    static final int SYSROLES_INDEX_UUID_IDX = 2;
    private static final boolean[] uniqueness = new boolean[]{true, false, true};
    private static final String[] uuids = new String[]{"e03f4017-0115-382c-08df-ffffe275b270", "c851401a-0115-382c-08df-ffffe275b270", "c065801d-0115-382c-08df-ffffe275b270", "787c0020-0115-382c-08df-ffffe275b270", "629f8094-0116-d8f9-5f97-ffffe275b270"};

    SYSROLESRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(6, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (tupleDescriptor != null) {
            RoleGrantDescriptor roleGrantDescriptor = (RoleGrantDescriptor)tupleDescriptor;
            string3 = roleGrantDescriptor.getRoleName();
            string4 = roleGrantDescriptor.getGrantee();
            string5 = roleGrantDescriptor.getGrantor();
            bl = roleGrantDescriptor.isWithAdminOption();
            bl2 = roleGrantDescriptor.isDef();
            UUID uUID = roleGrantDescriptor.getUUID();
            string2 = uUID.toString();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(6);
        execRow.setColumn(1, new SQLChar(string2));
        execRow.setColumn(2, new SQLVarchar(string3));
        execRow.setColumn(3, new SQLVarchar(string4));
        execRow.setColumn(4, new SQLVarchar(string5));
        execRow.setColumn(5, new SQLChar(bl ? "Y" : "N"));
        execRow.setColumn(6, new SQLChar(bl2 ? "Y" : "N"));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(2);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        String string4 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(4);
        String string5 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(5);
        String string6 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(6);
        String string7 = dataValueDescriptor.getString();
        RoleGrantDescriptor roleGrantDescriptor = dataDescriptorGenerator.newRoleGrantDescriptor(this.getUUIDFactory().recreateUUID(string2), string3, string4, string5, string6.equals("Y"), string7.equals("Y"));
        return roleGrantDescriptor;
    }

    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("UUID", false), SystemColumnImpl.getIdentifierColumn("ROLEID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getIndicatorColumn("WITHADMINOPTION"), SystemColumnImpl.getIndicatorColumn("ISDEF")};
    }
}

