/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSFOREIGNKEYSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSFOREIGNKEYS";
    protected static final int SYSFOREIGNKEYS_COLUMN_COUNT = 5;
    protected static final int SYSFOREIGNKEYS_CONSTRAINTID = 1;
    protected static final int SYSFOREIGNKEYS_CONGLOMERATEID = 2;
    protected static final int SYSFOREIGNKEYS_KEYCONSTRAINTID = 3;
    protected static final int SYSFOREIGNKEYS_DELETERULE = 4;
    protected static final int SYSFOREIGNKEYS_UPDATERULE = 5;
    protected static final int SYSFOREIGNKEYS_CONSTRAINTID_WIDTH = 36;
    protected static final int SYSFOREIGNKEYS_INDEX1_ID = 0;
    protected static final int SYSFOREIGNKEYS_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3}};
    private static final boolean[] uniqueness = new boolean[]{true, false};
    private static final String[] uuids = new String[]{"8000005b-00d0-fd77-3ed8-000a0a0b1900", "80000060-00d0-fd77-3ed8-000a0a0b1900", "8000005d-00d0-fd77-3ed8-000a0a0b1900", "8000005f-00d0-fd77-3ed8-000a0a0b1900"};

    SYSFOREIGNKEYSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(5, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "N";
        String string6 = "N";
        if (tupleDescriptor != null) {
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)tupleDescriptor;
            string2 = foreignKeyConstraintDescriptor.getUUID().toString();
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            string3 = referencedKeyConstraintDescriptor.getUUID().toString();
            string4 = foreignKeyConstraintDescriptor.getIndexUUIDString();
            string5 = this.getRefActionAsString(foreignKeyConstraintDescriptor.getRaDeleteRule());
            string6 = this.getRefActionAsString(foreignKeyConstraintDescriptor.getRaUpdateRule());
        }
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(5);
        execIndexRow.setColumn(1, new SQLChar(string2));
        execIndexRow.setColumn(2, new SQLChar(string4));
        execIndexRow.setColumn(3, new SQLChar(string3));
        execIndexRow.setColumn(4, new SQLChar(string5));
        execIndexRow.setColumn(5, new SQLChar(string6));
        return execIndexRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string2 = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string2);
        dataValueDescriptor = execRow.getColumn(2);
        String string3 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string3);
        dataValueDescriptor = execRow.getColumn(3);
        string2 = dataValueDescriptor.getString();
        UUID uUID3 = this.getUUIDFactory().recreateUUID(string2);
        dataValueDescriptor = execRow.getColumn(4);
        String string4 = dataValueDescriptor.getString();
        int n = this.getRefActionAsInt(string4);
        dataValueDescriptor = execRow.getColumn(5);
        string4 = dataValueDescriptor.getString();
        int n2 = this.getRefActionAsInt(string4);
        return new SubKeyConstraintDescriptor(uUID, uUID2, uUID3, n, n2);
    }

    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getUUIDColumn("CONGLOMERATEID", false), SystemColumnImpl.getUUIDColumn("KEYCONSTRAINTID", false), SystemColumnImpl.getIndicatorColumn("DELETERULE"), SystemColumnImpl.getIndicatorColumn("UPDATERULE")};
    }

    int getRefActionAsInt(String string2) {
        int n;
        switch (string2.charAt(0)) {
            case 'C': {
                n = 0;
                break;
            }
            case 'S': {
                n = 1;
                break;
            }
            case 'R': {
                n = 2;
                break;
            }
            case 'U': {
                n = 3;
                break;
            }
            case 'D': {
                n = 4;
                break;
            }
            default: {
                n = 2;
            }
        }
        return n;
    }

    String getRefActionAsString(int n) {
        String string2;
        switch (n) {
            case 0: {
                string2 = "C";
                break;
            }
            case 1: {
                string2 = "S";
                break;
            }
            case 2: {
                string2 = "R";
                break;
            }
            case 3: {
                string2 = "U";
                break;
            }
            case 4: {
                string2 = "D";
                n = 4;
                break;
            }
            default: {
                string2 = "N";
            }
        }
        return string2;
    }
}

