/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSCONSTRAINTSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCONSTRAINTS";
    protected static final int SYSCONSTRAINTS_COLUMN_COUNT = 7;
    protected static final int SYSCONSTRAINTS_CONSTRAINTID = 1;
    protected static final int SYSCONSTRAINTS_TABLEID = 2;
    protected static final int SYSCONSTRAINTS_CONSTRAINTNAME = 3;
    protected static final int SYSCONSTRAINTS_TYPE = 4;
    protected static final int SYSCONSTRAINTS_SCHEMAID = 5;
    protected static final int SYSCONSTRAINTS_STATE = 6;
    protected static final int SYSCONSTRAINTS_REFERENCECOUNT = 7;
    protected static final int SYSCONSTRAINTS_INDEX1_ID = 0;
    protected static final int SYSCONSTRAINTS_INDEX2_ID = 1;
    protected static final int SYSCONSTRAINTS_INDEX3_ID = 2;
    private static final boolean[] uniqueness = new boolean[]{true, true, false};
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3, 5}, {2}};
    private static final String[] uuids = new String[]{"8000002f-00d0-fd77-3ed8-000a0a0b1900", "80000036-00d0-fd77-3ed8-000a0a0b1900", "80000031-00d0-fd77-3ed8-000a0a0b1900", "80000033-00d0-fd77-3ed8-000a0a0b1900", "80000035-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCONSTRAINTSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(7, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = true;
        int n = 0;
        if (tupleDescriptor != null) {
            ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)tupleDescriptor;
            UUID uUID = constraintDescriptor.getUUID();
            string3 = uUID.toString();
            uUID = constraintDescriptor.getTableId();
            string4 = uUID.toString();
            string5 = constraintDescriptor.getConstraintName();
            int n2 = constraintDescriptor.getConstraintType();
            switch (n2) {
                case 2: {
                    string2 = "P";
                    break;
                }
                case 3: {
                    string2 = "U";
                    break;
                }
                case 4: {
                    string2 = "C";
                    break;
                }
                case 6: {
                    string2 = "F";
                    break;
                }
            }
            string6 = constraintDescriptor.getSchemaDescriptor().getUUID().toString();
            bl = constraintDescriptor.isEnabled();
            n = constraintDescriptor.getReferenceCount();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(7);
        execRow.setColumn(1, new SQLChar(string3));
        execRow.setColumn(2, new SQLChar(string4));
        execRow.setColumn(3, new SQLVarchar(string5));
        execRow.setColumn(4, new SQLChar(string2));
        execRow.setColumn(5, new SQLChar(string6));
        execRow.setColumn(6, new SQLChar(bl ? "E" : "D"));
        execRow.setColumn(7, new SQLInteger(n));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        boolean bl;
        ConstraintDescriptor constraintDescriptor = null;
        TableDescriptor tableDescriptor = null;
        int n = -1;
        int[] nArray = null;
        UUID uUID = null;
        SubConstraintDescriptor subConstraintDescriptor = (SubConstraintDescriptor)tupleDescriptor;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string2 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        dataValueDescriptor = execRow.getColumn(2);
        String string3 = dataValueDescriptor.getString();
        UUID uUID3 = this.getUUIDFactory().recreateUUID(string3);
        if (subConstraintDescriptor != null) {
            tableDescriptor = subConstraintDescriptor.getTableDescriptor();
        }
        if (tableDescriptor == null) {
            tableDescriptor = dataDictionary.getTableDescriptor(uUID3);
        }
        dataValueDescriptor = execRow.getColumn(3);
        String string4 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(4);
        String string5 = dataValueDescriptor.getString();
        boolean bl2 = false;
        switch (string5.charAt(0)) {
            case 'P': {
                n = 2;
                bl2 = true;
            }
            case 'U': {
                if (!bl2) {
                    n = 3;
                    bl2 = true;
                }
            }
            case 'F': {
                ConglomerateDescriptor conglomerateDescriptor;
                if (!bl2) {
                    n = 6;
                }
                if ((conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId())) == null) {
                    tableDescriptor = dataDictionary.getTableDescriptor(uUID3);
                    if (subConstraintDescriptor != null) {
                        subConstraintDescriptor.setTableDescriptor(tableDescriptor);
                    }
                    conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId());
                }
                nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
                uUID = ((SubKeyConstraintDescriptor)tupleDescriptor).getKeyConstraintId();
                nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
                break;
            }
            case 'C': {
                n = 4;
                break;
            }
        }
        dataValueDescriptor = execRow.getColumn(5);
        String string6 = dataValueDescriptor.getString();
        UUID uUID4 = this.getUUIDFactory().recreateUUID(string6);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID4, null);
        dataValueDescriptor = execRow.getColumn(6);
        String string7 = dataValueDescriptor.getString();
        switch (string7.charAt(0)) {
            case 'E': {
                bl = true;
                break;
            }
            case 'D': {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        dataValueDescriptor = execRow.getColumn(7);
        int n2 = dataValueDescriptor.getInt();
        switch (n) {
            case 2: {
                constraintDescriptor = dataDescriptorGenerator.newPrimaryKeyConstraintDescriptor(tableDescriptor, string4, false, false, nArray, uUID2, ((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId(), schemaDescriptor, bl, n2);
                break;
            }
            case 3: {
                constraintDescriptor = dataDescriptorGenerator.newUniqueConstraintDescriptor(tableDescriptor, string4, false, false, nArray, uUID2, ((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId(), schemaDescriptor, bl, n2);
                break;
            }
            case 6: {
                constraintDescriptor = dataDescriptorGenerator.newForeignKeyConstraintDescriptor(tableDescriptor, string4, false, false, nArray, uUID2, ((SubKeyConstraintDescriptor)tupleDescriptor).getIndexId(), schemaDescriptor, uUID, bl, ((SubKeyConstraintDescriptor)tupleDescriptor).getRaDeleteRule(), ((SubKeyConstraintDescriptor)tupleDescriptor).getRaUpdateRule());
                break;
            }
            case 4: {
                constraintDescriptor = dataDescriptorGenerator.newCheckConstraintDescriptor(tableDescriptor, string4, false, false, uUID2, ((SubCheckConstraintDescriptor)tupleDescriptor).getConstraintText(), ((SubCheckConstraintDescriptor)tupleDescriptor).getReferencedColumnsDescriptor(), schemaDescriptor, bl);
            }
        }
        return constraintDescriptor;
    }

    protected UUID getConstraintId(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string2 = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string2);
    }

    protected String getConstraintName(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(3);
        String string2 = dataValueDescriptor.getString();
        return string2;
    }

    protected UUID getSchemaId(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(5);
        String string2 = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string2);
    }

    protected UUID getTableId(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string2);
    }

    protected int getConstraintType(ExecRow execRow) throws StandardException {
        int n;
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(4);
        String string2 = dataValueDescriptor.getString();
        switch (string2.charAt(0)) {
            case 'P': {
                n = 2;
                break;
            }
            case 'U': {
                n = 3;
                break;
            }
            case 'C': {
                n = 4;
                break;
            }
            case 'F': {
                n = 6;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIdentifierColumn("CONSTRAINTNAME", false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIndicatorColumn("STATE"), SystemColumnImpl.getColumn("REFERENCECOUNT", 4, false)};
    }
}

