/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public final class GenericResultDescription
implements ResultDescription,
Formatable {
    private ResultColumnDescriptor[] columns;
    private String statementType;
    private transient ResultSetMetaData metaData;
    private Map columnNameMap;

    public GenericResultDescription() {
    }

    public GenericResultDescription(ResultColumnDescriptor[] resultColumnDescriptorArray, String string2) {
        this.columns = resultColumnDescriptorArray;
        this.statementType = string2;
    }

    public GenericResultDescription(ResultDescription resultDescription, int[] nArray) {
        this.columns = new ResultColumnDescriptor[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.columns[i] = resultDescription.getColumnDescriptor(nArray[i]);
        }
        this.statementType = resultDescription.getStatementType();
    }

    public String getStatementType() {
        return this.statementType;
    }

    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    public ResultColumnDescriptor[] getColumnInfo() {
        return this.columns;
    }

    public ResultColumnDescriptor getColumnDescriptor(int n) {
        return this.columns[n - 1];
    }

    public ResultDescription truncateColumns(int n) {
        ResultColumnDescriptor[] resultColumnDescriptorArray = new ResultColumnDescriptor[n - 1];
        System.arraycopy(this.columns, 0, resultColumnDescriptorArray, 0, resultColumnDescriptorArray.length);
        return new GenericResultDescription(resultColumnDescriptorArray, this.statementType);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.columns == null ? 0 : this.columns.length;
        objectOutput.writeObject(this.statementType);
        objectOutput.writeInt(n);
        while (n-- > 0) {
            if (!(this.columns[n] instanceof GenericColumnDescriptor)) {
                this.columns[n] = new GenericColumnDescriptor(this.columns[n]);
            }
            objectOutput.writeObject(this.columns[n]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.columns = null;
        this.statementType = (String)objectInput.readObject();
        int n = objectInput.readInt();
        if (n > 0) {
            this.columns = new GenericColumnDescriptor[n];
            while (n-- > 0) {
                this.columns[n] = (ResultColumnDescriptor)objectInput.readObject();
            }
        }
    }

    public int getTypeFormatId() {
        return 228;
    }

    public String toString() {
        return "";
    }

    public synchronized void setMetaData(ResultSetMetaData resultSetMetaData) {
        if (this.metaData == null) {
            this.metaData = resultSetMetaData;
        }
    }

    public synchronized ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumnInsenstive(String string2) {
        Map map2;
        Serializable serializable2 = this;
        synchronized (serializable2) {
            if (this.columnNameMap == null) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (int i = this.getColumnCount(); i >= 1; --i) {
                    String string3 = StringUtil.SQLToUpperCase(this.getColumnDescriptor(i).getName());
                    Integer n = ReuseFactory.getInteger(i);
                    hashMap.put(string3, n);
                }
                this.columnNameMap = Collections.unmodifiableMap(hashMap);
            }
            map2 = this.columnNameMap;
        }
        serializable2 = (Integer)map2.get(string2);
        if (serializable2 == null) {
            serializable2 = (Integer)map2.get(StringUtil.SQLToUpperCase(string2));
        }
        if (serializable2 == null) {
            return -1;
        }
        return (Integer)serializable2;
    }
}

