/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.stream.InfoStreams;
import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;
import org.apache.derby.impl.services.stream.BasicGetLogHeader;
import org.apache.derby.impl.services.stream.BasicHeaderPrintWriter;

public final class SingleStream
implements InfoStreams,
ModuleControl,
PrivilegedAction {
    private HeaderPrintWriter theStream;
    private String PBfileName;
    private PrintWriterGetHeader PBheader;

    public void boot(boolean bl, Properties properties) {
        this.theStream = this.makeStream();
    }

    public void stop() {
        ((BasicHeaderPrintWriter)this.theStream).complete();
    }

    public HeaderPrintWriter stream() {
        return this.theStream;
    }

    private HeaderPrintWriter makeStream() {
        PrintWriterGetHeader printWriterGetHeader = this.makeHeader();
        HeaderPrintWriter headerPrintWriter = this.makeHPW(printWriterGetHeader);
        if (headerPrintWriter == null) {
            headerPrintWriter = this.createDefaultStream(printWriterGetHeader);
        }
        return headerPrintWriter;
    }

    private PrintWriterGetHeader makeHeader() {
        return new BasicGetLogHeader(true, true, null);
    }

    private HeaderPrintWriter makeHPW(PrintWriterGetHeader printWriterGetHeader) {
        String string2 = PropertyUtil.getSystemProperty("derby.stream.error.file");
        if (string2 != null) {
            return this.makeFileHPW(string2, printWriterGetHeader);
        }
        string2 = PropertyUtil.getSystemProperty("derby.stream.error.method");
        if (string2 != null) {
            return this.makeMethodHPW(string2, printWriterGetHeader);
        }
        string2 = PropertyUtil.getSystemProperty("derby.stream.error.field");
        if (string2 != null) {
            return this.makeFieldHPW(string2, printWriterGetHeader);
        }
        return null;
    }

    private HeaderPrintWriter PBmakeFileHPW(String string2, PrintWriterGetHeader printWriterGetHeader) {
        Object object;
        boolean bl = PropertyUtil.getSystemBoolean("derby.infolog.append");
        File file = new File(string2);
        if (!file.isAbsolute() && (object = Monitor.getMonitor().getEnvironment()) instanceof File) {
            file = new File((File)object, string2);
        }
        try {
            object = file.exists() && bl ? new FileOutputStream(file.getPath(), true) : new FileOutputStream(file);
            FileUtil.limitAccessToOwner(file);
        }
        catch (IOException iOException) {
            return this.useDefaultStream(printWriterGetHeader, iOException);
        }
        catch (SecurityException securityException) {
            return this.useDefaultStream(printWriterGetHeader, securityException);
        }
        return new BasicHeaderPrintWriter(new BufferedOutputStream((OutputStream)object), printWriterGetHeader, true, file.getPath());
    }

    private HeaderPrintWriter makeMethodHPW(String string2, PrintWriterGetHeader printWriterGetHeader) {
        Throwable throwable;
        int n = string2.lastIndexOf(46);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        try {
            Class<?> clazz = Class.forName(string3);
            try {
                Method method = clazz.getMethod(string4, new Class[0]);
                if (!Modifier.isStatic(method.getModifiers())) {
                    HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
                    headerPrintWriter.printlnWithHeader(method.toString() + " is not static");
                    return headerPrintWriter;
                }
                try {
                    return this.makeValueHPW(method, method.invoke((Object)null, new Object[0]), printWriterGetHeader, string2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throwable = illegalAccessException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throwable = illegalArgumentException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = invocationTargetException.getTargetException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throwable = noSuchMethodException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        return this.useDefaultStream(printWriterGetHeader, throwable);
    }

    private HeaderPrintWriter makeFieldHPW(String string2, PrintWriterGetHeader printWriterGetHeader) {
        Exception exception;
        int n = string2.lastIndexOf(46);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1, string2.length());
        try {
            Class<?> clazz = Class.forName(string3);
            try {
                Field field2 = clazz.getField(string4);
                if (!Modifier.isStatic(field2.getModifiers())) {
                    HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
                    headerPrintWriter.printlnWithHeader(field2.toString() + " is not static");
                    return headerPrintWriter;
                }
                try {
                    return this.makeValueHPW(field2, field2.get(null), printWriterGetHeader, string2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = illegalAccessException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exception = illegalArgumentException;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                exception = noSuchFieldException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        return this.useDefaultStream(printWriterGetHeader, exception);
    }

    private HeaderPrintWriter makeValueHPW(Member member, Object object, PrintWriterGetHeader printWriterGetHeader, String string2) {
        if (object instanceof OutputStream) {
            return new BasicHeaderPrintWriter((OutputStream)object, printWriterGetHeader, false, string2);
        }
        if (object instanceof Writer) {
            return new BasicHeaderPrintWriter((Writer)object, printWriterGetHeader, false, string2);
        }
        HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
        if (object == null) {
            headerPrintWriter.printlnWithHeader(member.toString() + "=null");
        } else {
            headerPrintWriter.printlnWithHeader(member.toString() + " instanceof " + object.getClass().getName());
        }
        return headerPrintWriter;
    }

    private HeaderPrintWriter createDefaultStream(PrintWriterGetHeader printWriterGetHeader) {
        return this.makeFileHPW("derby.log", printWriterGetHeader);
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader printWriterGetHeader) {
        return new BasicHeaderPrintWriter(System.err, printWriterGetHeader, false, "System.err");
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader printWriterGetHeader, Throwable throwable) {
        HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
        while (throwable != null) {
            Throwable throwable2 = throwable.getCause();
            String string2 = MessageService.getTextMessage("N001");
            headerPrintWriter.printlnWithHeader(throwable.toString() + (throwable2 != null ? " " + string2 : ""));
            throwable = throwable2;
        }
        return headerPrintWriter;
    }

    private HeaderPrintWriter makeFileHPW(String string2, PrintWriterGetHeader printWriterGetHeader) {
        this.PBfileName = string2;
        this.PBheader = printWriterGetHeader;
        return (HeaderPrintWriter)AccessController.doPrivileged(this);
    }

    public final Object run() {
        return this.PBmakeFileHPW(this.PBfileName, this.PBheader);
    }
}

