/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.UpdateLoader;
import org.apache.derby.io.StorageFile;

final class JarLoader
extends SecureClassLoader {
    private final String[] name;
    private StorageFile installedJar;
    private JarFile jar;
    private boolean isStream;
    private UpdateLoader updateLoader;
    private HeaderPrintWriter vs;

    JarLoader(UpdateLoader updateLoader, String[] stringArray, HeaderPrintWriter headerPrintWriter) {
        this.updateLoader = updateLoader;
        this.name = stringArray;
        this.vs = headerPrintWriter;
    }

    void initialize() {
        Exception exception;
        String string2 = this.name[0];
        String string3 = this.name[1];
        try {
            this.installedJar = this.updateLoader.getJarReader().getJarFile(string2, string3);
            if (this.installedJar instanceof File) {
                try {
                    this.jar = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new JarFile((File)((Object)JarLoader.this.installedJar));
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                return;
            }
            this.isStream = true;
            return;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (StandardException standardException) {
            exception = standardException;
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage("C003", this.getJarName(), exception));
        }
        this.setInvalid();
    }

    protected Class loadClass(String string2, boolean bl) throws ClassNotFoundException {
        if (string2.startsWith("org.apache.derby.") && !string2.startsWith("org.apache.derby.jdbc.") && !string2.startsWith("org.apache.derby.vti.")) {
            ClassNotFoundException classNotFoundException = new ClassNotFoundException(string2);
            throw classNotFoundException;
        }
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.updateLoader == null) {
                throw new ClassNotFoundException(MessageService.getTextMessage("C004", string2));
            }
            Class clazz = this.updateLoader.loadClass(string2, bl);
            if (clazz == null) {
                throw classNotFoundException;
            }
            return clazz;
        }
    }

    public InputStream getResourceAsStream(String string2) {
        if (this.updateLoader == null) {
            return null;
        }
        return this.updateLoader.getResourceAsStream(string2);
    }

    final String getJarName() {
        return IdUtil.mkQualifiedName(this.name);
    }

    Class loadClassData(String string2, String string3, boolean bl) {
        if (this.updateLoader == null) {
            return null;
        }
        try {
            if (this.jar != null) {
                return this.loadClassDataFromJar(string2, string3, bl);
            }
            if (this.isStream) {
                return this.loadClassData(this.installedJar.getInputStream(), string2, string3, bl);
            }
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            if (this.vs != null) {
                this.vs.println(MessageService.getTextMessage("C007", string2, this.getJarName(), iOException));
            }
            return null;
        }
    }

    InputStream getStream(String string2) {
        if (this.updateLoader == null) {
            return null;
        }
        if (this.jar != null) {
            return this.getRawStream(string2);
        }
        if (this.isStream) {
            try {
                return this.getRawStream(this.installedJar.getInputStream(), string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassDataFromJar(String string2, String string3, boolean bl) throws IOException {
        Class clazz;
        JarEntry jarEntry = this.jar.getJarEntry(string3);
        if (jarEntry == null) {
            return null;
        }
        InputStream inputStream = this.jar.getInputStream(jarEntry);
        try {
            clazz = this.loadClassData(jarEntry, inputStream, string2, bl);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return clazz;
    }

    private Class loadClassData(InputStream inputStream, String string2, String string3, boolean bl) throws IOException {
        JarEntry jarEntry;
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        do {
            if ((jarEntry = jarInputStream.getNextJarEntry()) != null) continue;
            jarInputStream.close();
            return null;
        } while (!jarEntry.getName().equals(string3));
        Class clazz = this.loadClassData(jarEntry, jarInputStream, string2, bl);
        jarInputStream.close();
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassData(JarEntry jarEntry, InputStream inputStream, String string2, boolean bl) throws IOException {
        byte[] byArray = this.readData(jarEntry, inputStream, string2);
        Object[] objectArray = this.getSigners(string2, jarEntry);
        UpdateLoader updateLoader = this.updateLoader;
        synchronized (updateLoader) {
            Class<?> clazz = this.updateLoader.checkLoaded(string2, bl);
            if (clazz == null) {
                clazz = this.defineClass(string2, byArray, 0, byArray.length, (CodeSource)null);
                if (objectArray != null) {
                    this.setSigners(clazz, objectArray);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
            }
            return clazz;
        }
    }

    Class checkLoaded(String string2, boolean bl) {
        if (this.updateLoader == null) {
            return null;
        }
        Class<?> clazz = this.findLoadedClass(string2);
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    void setInvalid() {
        this.updateLoader = null;
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jar = null;
        }
        this.isStream = false;
    }

    private InputStream getRawStream(String string2) {
        try {
            JarEntry jarEntry = this.jar.getJarEntry(string2);
            if (jarEntry == null) {
                return null;
            }
            return this.jar.getInputStream(jarEntry);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getRawStream(InputStream var1_1, String var2_2) {
        block14: {
            block13: {
                var3_3 = null;
                try {
                    try {
                        var3_3 = new JarInputStream(var1_1);
                        while ((var4_4 = var3_3.getNextJarEntry()) != null) {
                            if (!var4_4.getName().equals(var2_2)) continue;
                            var5_6 = (int)var4_4.getSize();
                            if (var5_6 == -1) {
                                var5_6 = 8192;
                            }
                            var6_7 = AccessibleByteArrayOutputStream.copyStream(var3_3, var5_6);
                            var8_8 = null;
                            if (var3_3 == null) return var6_7;
                            break block13;
                        }
                        break block14;
                    }
                    catch (IOException var4_5) {
                        var8_10 = null;
                        if (var3_3 == null) return null;
                        try {
                            var3_3.close();
                            return null;
                        }
                        catch (IOException var9_14) {
                            return null;
                        }
                    }
                }
                catch (Throwable var7_16) {
                    var8_11 = null;
                    if (var3_3 == null) throw var7_16;
                    ** try [egrp 2[TRYBLOCK] [5 : 94->101)] { 
lbl30:
                    // 1 sources

                    var3_3.close();
                    throw var7_16;
lbl32:
                    // 1 sources

                    catch (IOException var9_15) {
                        // empty catch block
                    }
                    throw var7_16;
                }
            }
            try {}
            catch (IOException var9_12) {
                // empty catch block
                return var6_7;
            }
            var3_3.close();
            return var6_7;
        }
        var8_9 = null;
        if (var3_3 == null) return null;
        try {}
        catch (IOException var9_13) {}
        var3_3.close();
        return null;
        return null;
    }

    byte[] readData(JarEntry jarEntry, InputStream inputStream, String string2) throws IOException {
        try {
            int n;
            int n2 = (int)jarEntry.getSize();
            if (n2 != -1) {
                byte[] byArray = new byte[n2];
                InputStreamUtil.readFully(inputStream, byArray, 0, n2);
                return byArray;
            }
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (SecurityException securityException) {
            throw this.handleException(securityException, string2);
        }
    }

    private Certificate[] getSigners(String string2, JarEntry jarEntry) throws IOException {
        try {
            Certificate[] certificateArray = jarEntry.getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            for (int i = 0; i < certificateArray.length; ++i) {
                Object object;
                if (!(certificateArray[i] instanceof X509Certificate)) {
                    object = MessageService.getTextMessage("C001", string2, this.getJarName());
                    throw new SecurityException((String)object);
                }
                object = (X509Certificate)certificateArray[i];
                ((X509Certificate)object).checkValidity();
            }
            return certificateArray;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw this.handleException(generalSecurityException, string2);
        }
    }

    private SecurityException handleException(Exception exception, String string2) {
        String string3 = MessageService.getTextMessage("C002", string2, this.getJarName(), exception.getLocalizedMessage());
        return new SecurityException(string3);
    }

    public String toString() {
        return this.getJarName() + ":" + super.toString();
    }
}

