/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

final class StorageFactoryService
implements PersistentService {
    private static final String SERVICE_PROPERTIES_EOF_TOKEN = "#--- last line, don't put anything after this line ---";
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    StorageFactoryService(String string2, Class clazz) throws StandardException {
        this.subSubProtocol = string2;
        this.storageFactoryClass = clazz;
        Object object = Monitor.getMonitor().getEnvironment();
        if (object instanceof File) {
            final File file = (File)object;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, StandardException {
                        StorageFile storageFile;
                        boolean bl;
                        StorageFactoryService.this.home = file.getPath();
                        StorageFactoryService.this.canonicalHome = file.getCanonicalPath();
                        StorageFactoryService.this.rootStorageFactory = StorageFactoryService.this.getStorageFactoryInstance(true, null, null, null);
                        if (StorageFactoryService.this.home != null && (bl = (storageFile = StorageFactoryService.this.rootStorageFactory.newStorageFile(null)).mkdirs())) {
                            storageFile.limitAccessToOwner();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException iOException) {
                throw Monitor.exceptionStartingModule(iOException);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StorageFactoryService.this.separatorChar = StorageFactoryService.this.rootStorageFactory.getSeparator();
                return null;
            }
        });
    }

    public boolean hasStorageFactory() {
        return true;
    }

    public StorageFactory getStorageFactoryInstance(final boolean bl, final String string2, final String string3, final String string4) throws StandardException, IOException {
        try {
            return (StorageFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException, IOException {
                    return StorageFactoryService.this.privGetStorageFactoryInstance(bl, string2, string3, string4);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw StandardException.newException("XBM0W.S", exception, (Object)this.subSubProtocol, (Object)this.storageFactoryClass);
        }
    }

    private StorageFactory privGetStorageFactoryInstance(boolean bl, String string2, String string3, String string4) throws InstantiationException, IllegalAccessException, IOException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.newInstance();
        String string5 = string2 != null && this.subSubProtocol != null && string2.startsWith(this.subSubProtocol + ":") ? string2.substring(this.subSubProtocol.length() + 1) : string2;
        storageFactory.init(bl ? this.home : null, string5, string3, string4);
        return storageFactory;
    }

    public String getType() {
        return this.subSubProtocol;
    }

    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    public Properties getServiceProperties(final String string2, Properties properties) throws StandardException {
        final String string3 = this.recreateServiceRoot(string2, properties);
        final Properties properties2 = new Properties(properties);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                    if (string3 != null) {
                        File file = new File(string3, "service.properties");
                        FileInputStream fileInputStream = new FileInputStream(file);
                        try {
                            properties2.load(new BufferedInputStream(fileInputStream));
                        }
                        finally {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string2, null, null);
                    StorageFile storageFile = storageFactory.newStorageFile("service.properties");
                    StorageFactoryService.this.resolveServicePropertiesFiles(storageFactory, storageFile);
                    try {
                        InputStream inputStream = storageFile.getInputStream();
                        try {
                            properties2.load(new BufferedInputStream(inputStream));
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                    return null;
                }
            });
            return properties2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                return null;
            }
            throw Monitor.exceptionStartingModule(privilegedActionException.getException());
        }
        catch (SecurityException securityException) {
            throw Monitor.exceptionStartingModule(securityException);
        }
    }

    public void saveServiceProperties(final String string2, StorageFactory storageFactory, final Properties properties, final boolean bl) throws StandardException {
        if (!(storageFactory instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D");
        }
        final WritableStorageFactory writableStorageFactory = (WritableStorageFactory)storageFactory;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    StorageFile storageFile = bl ? writableStorageFactory.newStorageFile("service.properties".concat("old")) : null;
                    StorageFile storageFile2 = writableStorageFactory.newStorageFile("service.properties");
                    FileOperationHelper fileOperationHelper = new FileOperationHelper();
                    if (bl) {
                        fileOperationHelper.renameTo(storageFile2, storageFile, true);
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = storageFile2.getOutputStream();
                        properties.store(outputStream, string2 + MessageService.getTextMessage("M001"));
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                        bufferedWriter.write(StorageFactoryService.SERVICE_PROPERTIES_EOF_TOKEN);
                        bufferedWriter.newLine();
                        writableStorageFactory.sync(outputStream, false);
                        bufferedWriter.close();
                        outputStream.close();
                        outputStream = null;
                    }
                    catch (IOException iOException) {
                        if (storageFile != null) {
                            fileOperationHelper.renameTo(storageFile, storageFile2, false);
                        }
                        if (bl) {
                            throw StandardException.newException("XBM0B.D", iOException);
                        }
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (storageFile != null && !fileOperationHelper.delete(storageFile, false)) {
                        Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(storageFile)));
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    public void saveServiceProperties(final String string2, final Properties properties) throws StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    File file = new File(string2, "service.properties");
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        FileUtil.limitAccessToOwner(file);
                        properties.store(fileOutputStream, string2 + MessageService.getTextMessage("M001"));
                        fileOutputStream.getFD().sync();
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException) {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            fileOutputStream = null;
                        }
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    private void resolveServicePropertiesFiles(StorageFactory storageFactory, StorageFile storageFile) throws StandardException {
        StorageFile storageFile2 = storageFactory.newStorageFile("service.properties".concat("old"));
        FileOperationHelper fileOperationHelper = new FileOperationHelper();
        boolean bl = fileOperationHelper.exists(storageFile, true);
        boolean bl2 = fileOperationHelper.exists(storageFile2, true);
        if (bl && !bl2) {
            return;
        }
        if (bl2 && !bl) {
            fileOperationHelper.renameTo(storageFile2, storageFile, true);
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002"));
        } else if (bl2 && bl) {
            String string2;
            BufferedReader bufferedReader = null;
            String string3 = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(storageFile.getPath()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.trim().length() == 0) continue;
                    string3 = string2;
                }
            }
            catch (IOException iOException) {
                throw StandardException.newException("XJ113.S", iOException, (Object)storageFile.getPath(), (Object)iOException.getMessage());
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (string3 != null && string3.startsWith(SERVICE_PROPERTIES_EOF_TOKEN)) {
                string2 = fileOperationHelper.delete(storageFile2, false) ? MessageService.getTextMessage("M003") : MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(storageFile2));
                Monitor.getStream().printlnWithHeader(string2);
            } else {
                fileOperationHelper.delete(storageFile, false);
                fileOperationHelper.renameTo(storageFile2, storageFile, true);
                Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002"));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String recreateServiceRoot(final String string2, Properties properties) throws StandardException {
        if (properties == null) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string3 = properties.getProperty("createFrom");
        if (string3 != null) {
            bl = true;
            bl2 = false;
        } else {
            string3 = properties.getProperty("restoreFrom");
            if (string3 != null) {
                bl = true;
                bl2 = true;
            } else {
                string3 = properties.getProperty("rollForwardRecoveryFrom");
                if (string3 != null) {
                    try {
                        if (AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                                StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string2, null, null);
                                try {
                                    StorageFile storageFile = storageFactory.newStorageFile(null);
                                    7 var3_3 = storageFile.exists() ? this : null;
                                    return var3_3;
                                }
                                finally {
                                    storageFactory.shutdown();
                                }
                            }
                        }) == null) {
                            bl = true;
                            bl2 = false;
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
                    }
                }
            }
        }
        if (string3 == null) return string3;
        File file = new File(string3);
        if (!this.fileExists(file)) throw StandardException.newException("XBM0Y.D", file);
        File file2 = new File(string3, "service.properties");
        if (!this.fileExists(file2)) throw StandardException.newException("XBM0Q.D", file2);
        if (bl) {
            this.createServiceRoot(string2, bl2);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                    WritableStorageFactory writableStorageFactory = (WritableStorageFactory)StorageFactoryService.this.privGetStorageFactoryInstance(true, string2, null, null);
                    try {
                        StorageFile storageFile = writableStorageFactory.newStorageFile("service.properties");
                        if (storageFile.exists() && !storageFile.delete()) {
                            throw StandardException.newException("XBM0R.D", storageFile);
                        }
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        writableStorageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
        }
        properties.put("derby.__rt.inRestore", "True");
        if (!bl) return string3;
        properties.put("derby.__rt.deleteRootOnError", "True");
        return string3;
    }

    public String createServiceRoot(final String string2, final boolean bl) throws StandardException {
        Exception exception;
        block4: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException("XBM0P.D");
            }
            exception = null;
            try {
                return this.getProtocolLeadIn() + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                        StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string2, null, null);
                        try {
                            StorageFile storageFile = storageFactory.newStorageFile(null);
                            if (storageFile.exists()) {
                                if (bl) {
                                    if (!storageFile.deleteAll()) {
                                        throw StandardException.newException("XBM0I.D", StorageFactoryService.this.getDirectoryPath(string2));
                                    }
                                } else {
                                    StorageFactoryService.this.vetService(storageFactory, string2);
                                    throw StandardException.newException("XBM0J.D", StorageFactoryService.this.getDirectoryPath(string2));
                                }
                            }
                            if (storageFile.mkdirs()) {
                                storageFile.limitAccessToOwner();
                                String string22 = storageFile.getCanonicalPath();
                                storageFactory.setCanonicalName(string22);
                                try {
                                    String string3 = storageFactory.getCanonicalName();
                                    return string3;
                                }
                                catch (IOException iOException) {
                                    storageFile.deleteAll();
                                    throw iOException;
                                }
                            }
                            throw StandardException.newException("XBM0H.D", storageFile);
                        }
                        finally {
                            storageFactory.shutdown();
                        }
                    }
                });
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            catch (PrivilegedActionException privilegedActionException) {
                exception = privilegedActionException.getException();
                if (!(exception instanceof StandardException)) break block4;
                throw (StandardException)exception;
            }
        }
        throw StandardException.newException("XBM0H.D", exception, (Object)string2);
    }

    private void vetService(StorageFactory storageFactory, String string2) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = storageFactory.newStorageFile("service.properties");
        if (!storageFile2.exists() && (storageFile = storageFactory.newStorageFile("seg0")).exists()) {
            throw StandardException.newException("XBM0A.D", (Object)string2, (Object)"service.properties");
        }
    }

    private String getDirectoryPath(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.home != null) {
            stringBuffer.append(this.home);
            stringBuffer.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            stringBuffer.append(string2.replace('/', this.separatorChar));
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public boolean removeServiceRoot(final String string2) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string2, null, null);
                    try {
                        StorageFile storageFile = storageFactory.newStorageFile(null);
                        10 var3_3 = storageFile.deleteAll() ? this : null;
                        return var3_3;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            }) != null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    public String getCanonicalServiceName(String string2) throws StandardException {
        int n = string2.indexOf(58);
        if (n < 2 && !this.getType().equals("directory")) {
            return null;
        }
        if (n > 1) {
            if (!string2.startsWith(this.getType() + ":")) {
                return null;
            }
            string2 = string2.substring(n + 1);
        }
        final String string3 = string2;
        try {
            return this.getProtocolLeadIn() + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string3, null, null);
                    try {
                        String string2 = storageFactory.getCanonicalName();
                        return string2;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule(privilegedActionException.getException());
        }
    }

    public String getUserServiceName(String string2) {
        if (this.home != null && string2.length() > this.canonicalHome.length() + 1 && string2.startsWith(this.canonicalHome) && (string2 = string2.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            string2 = string2.substring(1);
        }
        return string2.replace(this.separatorChar, '/');
    }

    public boolean isSameService(String string2, String string3) {
        return string2.equals(string3);
    }

    private final boolean fileExists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    private String getProtocolLeadIn() {
        if (this.getType().equals("directory")) {
            return "";
        }
        return this.getType() + ":";
    }

    private static String getMostAccuratePath(StorageFile storageFile) {
        String string2 = storageFile.getPath();
        try {
            string2 = storageFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    private static class FileOperationHelper {
        private String operation;

        private FileOperationHelper() {
        }

        boolean exists(StorageFile storageFile, boolean bl) throws StandardException {
            this.operation = "exists";
            boolean bl2 = false;
            try {
                bl2 = storageFile.exists();
            }
            catch (SecurityException securityException) {
                this.handleSecPrivException(storageFile, bl, securityException);
            }
            return bl2;
        }

        boolean delete(StorageFile storageFile, boolean bl) throws StandardException {
            this.operation = "delete";
            boolean bl2 = false;
            try {
                bl2 = storageFile.delete();
            }
            catch (SecurityException securityException) {
                this.handleSecPrivException(storageFile, bl, securityException);
            }
            if (bl && !bl2) {
                throw StandardException.newException("XBM0R.D", storageFile.getPath());
            }
            return bl2;
        }

        boolean renameTo(StorageFile storageFile, StorageFile storageFile2, boolean bl) throws StandardException {
            this.operation = "renameTo";
            this.delete(storageFile2, false);
            boolean bl2 = false;
            try {
                bl2 = storageFile.renameTo(storageFile2);
            }
            catch (SecurityException securityException) {
                StorageFile storageFile3 = storageFile2;
                try {
                    System.getSecurityManager().checkWrite(storageFile.getPath());
                }
                catch (SecurityException securityException2) {
                    storageFile3 = storageFile;
                }
                this.handleSecPrivException(storageFile3, bl, securityException);
            }
            if (bl && !bl2) {
                throw StandardException.newException("XBM0S.D", (Object)storageFile.getPath(), (Object)storageFile2.getPath());
            }
            return bl2;
        }

        private void handleSecPrivException(StorageFile storageFile, boolean bl, SecurityException securityException) throws StandardException {
            if (bl) {
                throw StandardException.newException("XBM0C.D", securityException, (Object)this.operation, (Object)storageFile.getName(), (Object)securityException.getMessage());
            }
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("XBM0C.D", this.operation, StorageFactoryService.getMostAccuratePath(storageFile), securityException.getMessage()));
        }
    }

    final class DirectoryList
    implements Enumeration,
    PrivilegedAction {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            AccessController.doPrivileged(this);
        }

        public boolean hasMoreElements() {
            if (this.contents == null) {
                return false;
            }
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return AccessController.doPrivileged(this) != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        public final Object run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    while (this.index < this.contents.length) {
                        try {
                            StorageFile storageFile;
                            String string2 = this.contents[this.index];
                            StorageFile storageFile2 = StorageFactoryService.this.rootStorageFactory.newStorageFile(string2);
                            if (storageFile2.isDirectory() && (storageFile = StorageFactoryService.this.rootStorageFactory.newStorageFile(storageFile2, "service.properties")).exists()) {
                                this.contents[this.index] = storageFile2.getCanonicalPath();
                                this.validIndex = true;
                                return this;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.contents[this.index++] = null;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

