/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.impl.services.locks.Control;

class LockTableVTI
implements Enumeration {
    private final Iterator outerControl;
    private Control control;
    private ListIterator grantedList;
    private ListIterator waitingList;
    private Latch nextLock;

    LockTableVTI(Map map2) {
        this.outerControl = map2.values().iterator();
    }

    public boolean hasMoreElements() {
        if (this.nextLock != null) {
            return true;
        }
        while (true) {
            if (this.control == null) {
                List list2;
                if (!this.outerControl.hasNext()) {
                    return false;
                }
                this.control = (Control)this.outerControl.next();
                List list3 = this.control.getGranted();
                if (list3 != null) {
                    this.grantedList = list3.listIterator();
                }
                if ((list2 = this.control.getWaiting()) != null) {
                    this.waitingList = list2.listIterator();
                }
                this.nextLock = this.control.getFirstGrant();
                if (this.nextLock == null) {
                    this.nextLock = this.getNextLock(this.control);
                }
            } else {
                this.nextLock = this.getNextLock(this.control);
            }
            if (this.nextLock != null) {
                return true;
            }
            this.control = null;
        }
    }

    private Latch getNextLock(Control control) {
        Latch latch = null;
        if (this.grantedList != null) {
            if (this.grantedList.hasNext()) {
                latch = (Latch)this.grantedList.next();
            } else {
                this.grantedList = null;
            }
        }
        if (latch == null && this.waitingList != null) {
            if (this.waitingList.hasNext()) {
                latch = (Latch)this.waitingList.next();
            } else {
                this.waitingList = null;
            }
        }
        return latch;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Latch latch = this.nextLock;
        this.nextLock = null;
        return latch;
    }
}

