/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockList;
import org.apache.derby.impl.services.locks.LockTable;

final class LockSpace
implements CompatibilitySpace {
    private final HashMap groups;
    private final LockOwner owner;
    private HashMap[] spareGroups = new HashMap[3];
    private Object callbackGroup;
    private int limit;
    private int nextLimitCall;
    private Limit callback;
    private boolean inLimit;

    LockSpace(LockOwner lockOwner) {
        this.groups = new HashMap();
        this.owner = lockOwner;
    }

    public LockOwner getOwner() {
        return this.owner;
    }

    protected synchronized void addLock(Object object, Lock lock) throws StandardException {
        Lock lock2 = null;
        HashMap hashMap = (HashMap)this.groups.get(object);
        if (hashMap == null) {
            hashMap = this.getGroupMap(object);
        } else if (lock.getCount() != 1) {
            lock2 = (Lock)hashMap.get(lock);
        }
        if (lock2 == null) {
            lock2 = lock.copy();
            hashMap.put(lock2, lock2);
        }
        ++lock2.count;
        if (this.inLimit) {
            return;
        }
        if (!object.equals(this.callbackGroup)) {
            return;
        }
        int n = hashMap.size();
        if (n > this.nextLimitCall) {
            this.inLimit = true;
            this.callback.reached(this, object, this.limit, new LockList(Collections.enumeration(hashMap.keySet())), n);
            this.inLimit = false;
            int n2 = hashMap.size();
            this.nextLimitCall = n2 < this.limit / 2 ? this.limit : (n2 < this.nextLimitCall / 2 ? (this.nextLimitCall -= this.limit) : (this.nextLimitCall += this.limit));
        }
    }

    synchronized void unlockGroup(LockTable lockTable, Object object) {
        HashMap hashMap = (HashMap)this.groups.remove(object);
        if (hashMap == null) {
            return;
        }
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            lockTable.unlock((Lock)iterator2.next(), 0);
        }
        if (this.callbackGroup != null && object.equals(this.callbackGroup)) {
            this.nextLimitCall = this.limit;
        }
        this.saveGroup(hashMap);
    }

    private HashMap getGroupMap(Object object) {
        HashMap[] hashMapArray = this.spareGroups;
        HashMap hashMap = null;
        for (int i = 0; i < 3; ++i) {
            hashMap = hashMapArray[i];
            if (hashMap == null) continue;
            hashMapArray[i] = null;
            break;
        }
        if (hashMap == null) {
            hashMap = new HashMap(5, 0.8f);
        }
        this.groups.put(object, hashMap);
        return hashMap;
    }

    private void saveGroup(HashMap hashMap) {
        HashMap[] hashMapArray = this.spareGroups;
        for (int i = 0; i < 3; ++i) {
            if (hashMapArray[i] != null) continue;
            hashMapArray[i] = hashMap;
            hashMap.clear();
            break;
        }
    }

    synchronized void unlockGroup(LockTable lockTable, Object object, Matchable matchable) {
        HashMap hashMap = (HashMap)this.groups.get(object);
        if (hashMap == null) {
            return;
        }
        boolean bl = true;
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Lock lock = (Lock)iterator2.next();
            if (!matchable.match(lock.getLockable())) {
                bl = false;
                continue;
            }
            lockTable.unlock(lock, 0);
            iterator2.remove();
        }
        if (bl) {
            this.groups.remove(object);
            this.saveGroup(hashMap);
            if (this.callbackGroup != null && object.equals(this.callbackGroup)) {
                this.nextLimitCall = this.limit;
            }
        }
    }

    synchronized void transfer(Object object, Object object2) {
        HashMap hashMap = (HashMap)this.groups.get(object);
        if (hashMap == null) {
            return;
        }
        HashMap hashMap2 = (HashMap)this.groups.get(object2);
        if (hashMap2 == null) {
            this.groups.put(object2, hashMap);
            this.clearLimit(object);
            this.groups.remove(object);
            return;
        }
        if (hashMap2.size() < hashMap.size()) {
            this.mergeGroups(hashMap2, hashMap);
            HashMap hashMap3 = this.groups.put(object2, hashMap);
        } else {
            this.mergeGroups(hashMap, hashMap2);
        }
        this.clearLimit(object);
        this.groups.remove(object);
    }

    private void mergeGroups(HashMap hashMap, HashMap hashMap2) {
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Object k = iterator2.next();
            Object v = hashMap2.get(k);
            if (v == null) {
                hashMap2.put(k, k);
                continue;
            }
            Lock lock = (Lock)k;
            Lock lock2 = (Lock)v;
            lock2.count += lock.getCount();
        }
    }

    synchronized int unlockReference(LockTable lockTable, Lockable lockable, Object object, Object object2) {
        HashMap hashMap = (HashMap)this.groups.get(object2);
        if (hashMap == null) {
            return 0;
        }
        Lock lock = lockTable.unlockReference(this, lockable, object, hashMap);
        if (lock == null) {
            return 0;
        }
        if (lock.getCount() == 1) {
            if (hashMap.isEmpty()) {
                this.groups.remove(object2);
                this.saveGroup(hashMap);
                if (this.callbackGroup != null && object2.equals(this.callbackGroup)) {
                    this.nextLimitCall = this.limit;
                }
            }
            return 1;
        }
        --lock.count;
        hashMap.put(lock, lock);
        return 1;
    }

    synchronized boolean areLocksHeld(Object object) {
        return this.groups.containsKey(object);
    }

    synchronized boolean areLocksHeld() {
        return !this.groups.isEmpty();
    }

    synchronized boolean isLockHeld(Object object, Lockable lockable, Object object2) {
        HashMap hashMap = (HashMap)this.groups.get(object);
        if (hashMap == null) {
            return false;
        }
        Object v = hashMap.get(new Lock(this, lockable, object2));
        return v != null;
    }

    synchronized void setLimit(Object object, int n, Limit limit) {
        this.callbackGroup = object;
        this.nextLimitCall = this.limit = n;
        this.callback = limit;
    }

    synchronized void clearLimit(Object object) {
        if (object.equals(this.callbackGroup)) {
            this.callbackGroup = null;
            this.limit = Integer.MAX_VALUE;
            this.nextLimitCall = Integer.MAX_VALUE;
            this.callback = null;
        }
    }

    synchronized int deadlockCount(int n) {
        int n2 = 0;
        Iterator iterator2 = this.groups.values().iterator();
        while (iterator2.hasNext()) {
            HashMap hashMap = (HashMap)iterator2.next();
            Iterator iterator3 = hashMap.keySet().iterator();
            while (iterator3.hasNext()) {
                Lock lock = (Lock)iterator3.next();
                if ((n2 += lock.getCount()) <= n) continue;
                return n2;
            }
        }
        return n2;
    }
}

