/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.impl.services.locks.AbstractPool;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.TableNameInfo;

class Deadlock {
    private Deadlock() {
    }

    static Object[] look(AbstractPool abstractPool, LockTable lockTable, LockControl lockControl, ActiveLock activeLock, byte by2) {
        Hashtable hashtable = Deadlock.getWaiters(lockTable);
        Stack<Object> stack = new Stack<Object>();
        stack.push(activeLock.getCompatabilitySpace());
        stack.push(lockControl.getGrants());
        block0: while (!stack.isEmpty()) {
            int n;
            List list2 = (List)stack.peek();
            if (list2.isEmpty()) {
                Deadlock.rollback(stack);
                continue;
            }
            int n2 = list2.size() - 1;
            CompatibilitySpace compatibilitySpace = ((Lock)list2.get(n2)).getCompatabilitySpace();
            for (n = 0; n < n2; ++n) {
                if (!compatibilitySpace.equals(((Lock)list2.get(n)).getCompatabilitySpace())) continue;
                stack.push(compatibilitySpace);
                Deadlock.rollback(stack);
                continue block0;
            }
            block2: while (true) {
                Lock lock;
                if ((n = stack.indexOf(compatibilitySpace)) != -1) {
                    if (n == stack.size() - 1 || n == stack.size() - 2 && n == stack.indexOf(list2) - 1) {
                        lock = (ActiveLock)((Dictionary)hashtable).get(compatibilitySpace);
                        if (((ActiveLock)lock).canSkip) {
                            stack.push(compatibilitySpace);
                            Deadlock.rollback(stack);
                            continue block0;
                        }
                    }
                    return Deadlock.handle(abstractPool, stack, n, hashtable, by2);
                }
                stack.push(compatibilitySpace);
                while (true) {
                    Control control;
                    if ((lock = (Lock)((Dictionary)hashtable).get(compatibilitySpace)) == null) {
                        Deadlock.rollback(stack);
                        continue block0;
                    }
                    Object v = ((Dictionary)hashtable).get(lock);
                    if (v instanceof LockControl) {
                        control = (LockControl)v;
                        if (((LockControl)control).isUnlocked()) {
                            Deadlock.rollback(stack);
                            continue block0;
                        }
                        stack.push(((LockControl)control).getGrants());
                        continue block0;
                    }
                    control = (ActiveLock)v;
                    compatibilitySpace = ((Lock)control).getCompatabilitySpace();
                    if (!lock.getLockable().requestCompatible(lock.getQualifier(), ((Lock)control).getQualifier())) continue block2;
                }
                break;
            }
        }
        return null;
    }

    private static void rollback(Stack stack) {
        do {
            stack.pop();
            if (!stack.isEmpty()) continue;
            return;
        } while (!(stack.peek() instanceof List));
        List list2 = (List)stack.peek();
        list2.remove(list2.size() - 1);
    }

    private static Hashtable getWaiters(LockTable lockTable) {
        Hashtable hashtable = new Hashtable();
        lockTable.addWaiters(hashtable);
        return hashtable;
    }

    private static Object[] handle(AbstractPool abstractPool, Stack stack, int n, Dictionary dictionary, byte by2) {
        Object e = stack.elementAt(0);
        int n2 = Integer.MAX_VALUE;
        Object var7_7 = null;
        for (int i = n; i < stack.size(); ++i) {
            Object e2 = stack.elementAt(i);
            if (e2 instanceof List) continue;
            if (e.equals(e2) && by2 == 2) {
                var7_7 = e;
                break;
            }
            LockSpace lockSpace = (LockSpace)e2;
            int n3 = lockSpace.deadlockCount(n2);
            if (n3 > n2) continue;
            var7_7 = e2;
            n2 = n3;
        }
        if (e.equals(var7_7)) {
            Object[] objectArray = new Object[]{stack, dictionary};
            return objectArray;
        }
        ActiveLock activeLock = (ActiveLock)dictionary.get(var7_7);
        activeLock.wakeUp((byte)2);
        return null;
    }

    static StandardException buildException(AbstractPool abstractPool, Object[] objectArray) {
        Stack stack = (Stack)objectArray[0];
        Dictionary dictionary = (Dictionary)objectArray[1];
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        TableNameInfo tableNameInfo = null;
        TransactionInfo[] transactionInfoArray = null;
        TransactionController transactionController = null;
        if (languageConnectionContext != null) {
            try {
                transactionController = languageConnectionContext.getTransactionExecute();
                tableNameInfo = new TableNameInfo(languageConnectionContext, false);
                transactionInfoArray = transactionController.getAccessManager().getTransactionInfo();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        Hashtable hashtable = new Hashtable(17);
        String string2 = null;
        for (int i = 0; i < stack.size(); ++i) {
            Object object;
            Object e = stack.elementAt(i);
            if (e instanceof List) {
                object = (List)e;
                if (object.size() == 0) continue;
                stringBuffer.append("  Granted XID : ");
                for (int j = 0; j < object.size(); ++j) {
                    if (j != 0) {
                        stringBuffer.append(", ");
                    }
                    Lock lock = (Lock)object.get(j);
                    stringBuffer.append("{");
                    stringBuffer.append(lock.getCompatabilitySpace().getOwner());
                    stringBuffer.append(", ");
                    stringBuffer.append(lock.getQualifier());
                    stringBuffer.append("} ");
                }
                stringBuffer.append('\n');
                continue;
            }
            object = (Lock)dictionary.get(e);
            ((Lock)object).getLockable().lockAttributes(-1, hashtable);
            Deadlock.addInfo(stringBuffer, "Lock : ", hashtable.get("TYPE"));
            if (tableNameInfo != null) {
                Long l = (Long)hashtable.get("CONGLOMID");
                if (l == null) {
                    Long l2 = (Long)hashtable.get("CONTAINERID");
                    try {
                        l = new Long(transactionController.findConglomid(l2));
                    }
                    catch (StandardException standardException) {
                        // empty catch block
                    }
                }
                Deadlock.addInfo(stringBuffer, ", ", tableNameInfo.getTableName(l));
            }
            Deadlock.addInfo(stringBuffer, ", ", hashtable.get("LOCKNAME"));
            stringBuffer.append('\n');
            String string3 = String.valueOf(((Lock)object).getCompatabilitySpace().getOwner());
            if (i == 0) {
                string2 = string3;
            }
            Deadlock.addInfo(stringBuffer, "  Waiting XID : {", string3);
            Deadlock.addInfo(stringBuffer, ", ", ((Lock)object).getQualifier());
            stringBuffer.append("} ");
            if (transactionInfoArray != null) {
                for (int j = transactionInfoArray.length - 1; j >= 0; --j) {
                    String string4;
                    TransactionInfo transactionInfo = transactionInfoArray[j];
                    if (transactionInfo == null || (string4 = transactionInfo.getTransactionIdString()) == null || !string4.equals(string3)) continue;
                    Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getUsernameString());
                    Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getStatementTextString());
                    break;
                }
            }
            stringBuffer.append('\n');
            hashtable.clear();
        }
        StandardException standardException = StandardException.newException("40001", (Object)stringBuffer.toString(), string2);
        standardException.setReport(abstractPool.deadlockMonitor);
        return standardException;
    }

    private static void addInfo(StringBuffer stringBuffer, String string2, Object object) {
        stringBuffer.append(string2);
        if (object == null) {
            object = "?";
        }
        stringBuffer.append(object);
    }
}

