/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.LockTableVTI;

abstract class AbstractPool
implements LockFactory {
    protected final LockTable lockTable = this.createLockTable();
    int deadlockMonitor;

    protected AbstractPool() {
    }

    protected abstract LockTable createLockTable();

    public boolean lockObject(CompatibilitySpace compatibilitySpace, Object object, Lockable lockable, Object object2, int n) throws StandardException {
        Lock lock = this.lockTable.lockObject(compatibilitySpace, lockable, object2, n);
        if (lock == null) {
            if (n == -2) {
                throw StandardException.newException("40XL1");
            }
            return false;
        }
        ((LockSpace)compatibilitySpace).addLock(object, lock);
        return true;
    }

    public CompatibilitySpace createCompatibilitySpace(LockOwner lockOwner) {
        return new LockSpace(lockOwner);
    }

    public int unlock(CompatibilitySpace compatibilitySpace, Object object, Lockable lockable, Object object2) {
        int n = ((LockSpace)compatibilitySpace).unlockReference(this.lockTable, lockable, object2, object);
        return n;
    }

    public void unlockGroup(CompatibilitySpace compatibilitySpace, Object object) {
        ((LockSpace)compatibilitySpace).unlockGroup(this.lockTable, object);
    }

    public void unlockGroup(CompatibilitySpace compatibilitySpace, Object object, Matchable matchable) {
        ((LockSpace)compatibilitySpace).unlockGroup(this.lockTable, object, matchable);
    }

    public void transfer(CompatibilitySpace compatibilitySpace, Object object, Object object2) {
        ((LockSpace)compatibilitySpace).transfer(object, object2);
    }

    public boolean anyoneBlocked() {
        return this.lockTable.anyoneBlocked();
    }

    public boolean areLocksHeld(CompatibilitySpace compatibilitySpace, Object object) {
        return ((LockSpace)compatibilitySpace).areLocksHeld(object);
    }

    public boolean areLocksHeld(CompatibilitySpace compatibilitySpace) {
        return ((LockSpace)compatibilitySpace).areLocksHeld();
    }

    public boolean zeroDurationlockObject(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, int n) throws StandardException {
        boolean bl = this.lockTable.zeroDurationLockObject(compatibilitySpace, lockable, object, n);
        if (!bl && n == -2) {
            throw StandardException.newException("40XL1");
        }
        return bl;
    }

    public boolean isLockHeld(CompatibilitySpace compatibilitySpace, Object object, Lockable lockable, Object object2) {
        return ((LockSpace)compatibilitySpace).isLockHeld(object, lockable, object2);
    }

    public int getWaitTimeout() {
        return this.lockTable.getWaitTimeout();
    }

    public void setLimit(CompatibilitySpace compatibilitySpace, Object object, int n, Limit limit) {
        ((LockSpace)compatibilitySpace).setLimit(object, n, limit);
    }

    public void clearLimit(CompatibilitySpace compatibilitySpace, Object object) {
        ((LockSpace)compatibilitySpace).clearLimit(object);
    }

    static boolean noLockWait(int n, CompatibilitySpace compatibilitySpace) {
        if (n == 0) {
            return true;
        }
        LockOwner lockOwner = compatibilitySpace.getOwner();
        return lockOwner != null && lockOwner.noWait();
    }

    public Enumeration makeVirtualLockTable() {
        LockTableVTI lockTableVTI = new LockTableVTI(this.lockTable.shallowClone());
        return lockTableVTI;
    }

    public void init(boolean bl, Dictionary dictionary) {
        this.getAndApply(bl, dictionary, "derby.locks.deadlockTimeout");
        this.getAndApply(bl, dictionary, "derby.locks.waitTimeout");
        this.getAndApply(bl, dictionary, "derby.locks.monitor");
        this.getAndApply(bl, dictionary, "derby.locks.deadlockTrace");
    }

    private void getAndApply(boolean bl, Dictionary dictionary, String string2) {
        try {
            Serializable serializable2 = PropertyUtil.getPropertyFromSet(bl, dictionary, string2);
            if (serializable2 != null) {
                this.validate(string2, serializable2, dictionary);
                this.apply(string2, serializable2, dictionary);
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    public boolean validate(String string2, Serializable serializable2, Dictionary dictionary) throws StandardException {
        if (!string2.startsWith("derby.locks.")) {
            return false;
        }
        if (serializable2 != null) {
            if (string2.equals("derby.locks.deadlockTimeout")) {
                AbstractPool.getWaitValue((String)((Object)serializable2), 20);
            } else if (string2.equals("derby.locks.waitTimeout")) {
                AbstractPool.getWaitValue((String)((Object)serializable2), 60);
            } else if (string2.equals("derby.locks.monitor")) {
                PropertyUtil.booleanProperty("derby.locks.monitor", serializable2, false);
            } else if (string2.equals("derby.locks.deadlockTrace")) {
                PropertyUtil.booleanProperty("derby.locks.deadlockTrace", serializable2, false);
            }
        }
        return true;
    }

    public Serviceable apply(String string2, Serializable serializable2, Dictionary dictionary) throws StandardException {
        if (serializable2 == null) {
            serializable2 = PropertyUtil.getPropertyFromSet(dictionary, string2);
        }
        String string3 = (String)((Object)serializable2);
        if (string2.equals("derby.locks.deadlockTimeout")) {
            this.lockTable.setDeadlockTimeout(AbstractPool.getWaitValue(string3, 20));
        } else if (string2.equals("derby.locks.waitTimeout")) {
            this.lockTable.setWaitTimeout(AbstractPool.getWaitValue(string3, 60));
        } else if (string2.equals("derby.locks.monitor")) {
            this.deadlockMonitor = PropertyUtil.booleanProperty("derby.locks.monitor", (Serializable)((Object)string3), false) ? 2 : 0;
        } else if (string2.equals("derby.locks.deadlockTrace")) {
            this.lockTable.setDeadlockTrace(PropertyUtil.booleanProperty("derby.locks.deadlockTrace", (Serializable)((Object)string3), false));
        }
        return null;
    }

    public Serializable map(String string2, Serializable serializable2, Dictionary dictionary) {
        return null;
    }

    private static int getWaitValue(String string2, int n) {
        int n2 = PropertyUtil.handleInt(string2, Integer.MIN_VALUE, 2147483, n);
        n2 = n2 < 0 ? -1 : (n2 *= 1000);
        return n2;
    }
}

