/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jce;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.jce.JCECipherProvider;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

public final class JCECipherFactory
implements CipherFactory,
PrivilegedExceptionAction {
    private static final String MESSAGE_DIGEST = "MD5";
    private static final String DEFAULT_ALGORITHM = "DES/CBC/NoPadding";
    private static final String DES = "DES";
    private static final String DESede = "DESede";
    private static final String TripleDES = "TripleDES";
    private static final String AES = "AES";
    private static final int BLOCK_LENGTH = 8;
    private static final int AES_IV_LENGTH = 16;
    private int keyLengthBits;
    private int encodedKeyLength;
    private String cryptoAlgorithm;
    private String cryptoAlgorithmShort;
    private String cryptoProvider;
    private String cryptoProviderShort;
    private MessageDigest messageDigest;
    private SecretKey mainSecretKey;
    private byte[] mainIV;
    private Properties persistentProperties;
    private static final int VERIFYKEY_DATALEN = 4096;
    private StorageFile activeFile;
    private int action;
    private String activePerms;

    public JCECipherFactory(boolean bl, Properties properties, boolean bl2) throws StandardException {
        this.init(bl, properties, bl2);
    }

    static String providerErrorName(String string2) {
        return string2 == null ? "default" : string2;
    }

    private byte[] generateUniqueBytes() throws StandardException {
        try {
            KeyGenerator keyGenerator;
            String string2 = this.cryptoProviderShort;
            if (string2 == null) {
                keyGenerator = KeyGenerator.getInstance(this.cryptoAlgorithmShort);
            } else {
                if (string2.equals("BouncyCastleProvider")) {
                    string2 = "BC";
                }
                keyGenerator = KeyGenerator.getInstance(this.cryptoAlgorithmShort, string2);
            }
            keyGenerator.init(this.keyLengthBits);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw StandardException.newException("XBCXC.S", (Object)this.cryptoAlgorithm, (Object)JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw StandardException.newException("XBCXG.S", JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
    }

    private EncryptedKeyResult encryptKey(byte[] byArray, byte[] byArray2) throws StandardException {
        int n = byArray.length;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            n = 16;
        }
        byte[] byArray3 = this.getMuckFromBootPassword(byArray2, n);
        SecretKey secretKey = this.generateKey(byArray3);
        byte[] byArray4 = this.generateIV(byArray3);
        CipherProvider cipherProvider = this.createNewCipher(1, secretKey, byArray4);
        this.encodedKeyLength = byArray.length;
        byArray = this.padKey(byArray, cipherProvider.getEncryptionBlockSize());
        byte[] byArray5 = new byte[byArray.length];
        cipherProvider.encrypt(byArray, 0, byArray.length, byArray5, 0);
        String string2 = StringUtil.toHexString(byArray5, 0, byArray5.length);
        return new EncryptedKeyResult(string2, byArray);
    }

    private byte[] padKey(byte[] byArray, int n) {
        byte[] byArray2 = byArray;
        if (byArray.length % n != 0) {
            int n2 = byArray.length + n - byArray.length % n;
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    private byte[] decryptKey(String string2, int n, byte[] byArray) throws StandardException {
        byte[] byArray2 = StringUtil.fromHexString(string2, 0, n);
        int n2 = this.cryptoAlgorithmShort.equals(AES) ? 16 : byArray2.length;
        byte[] byArray3 = this.getMuckFromBootPassword(byArray, n2);
        SecretKey secretKey = this.generateKey(byArray3);
        byte[] byArray4 = this.generateIV(byArray3);
        this.createNewCipher(2, secretKey, byArray4).decrypt(byArray2, 0, byArray2.length, byArray2, 0);
        return byArray2;
    }

    private byte[] getMuckFromBootPassword(byte[] byArray, int n) {
        int n2;
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n];
        int n4 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n4 += byArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArray2[n2] = (byte)(byArray[(n2 + n4) % n3] ^ byArray[n2 % n3] << 4);
        }
        return byArray2;
    }

    private SecretKey generateKey(byte[] byArray) throws StandardException {
        int n = byArray.length;
        if (n < 8) {
            throw StandardException.newException("XBCX2.S", new Integer(8));
        }
        try {
            if (this.cryptoAlgorithmShort.equals(DES) && DESKeySpec.isWeak(byArray, 0)) {
                byte[] byArray2 = StringUtil.getAsciiBytes("louDScap");
                for (int i = 0; i < 7; ++i) {
                    byArray[i] = (byte)(byArray2[i] << 3 ^ byArray[i]);
                }
            }
            return new SecretKeySpec(byArray, this.cryptoAlgorithmShort);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw StandardException.newException("XBCX0.S", invalidKeyException);
        }
    }

    private byte[] generateIV(byte[] byArray) {
        int n = 8;
        byte[] byArray2 = null;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            int n2;
            n = 16;
            byArray2 = new byte[n];
            byArray2[0] = (byte)((byArray[byArray.length - 1] << 2 | 0xF) ^ byArray[0]);
            for (n2 = 1; n2 < 8; ++n2) {
                byArray2[n2] = (byte)((byArray[n2 - 1] << n2 % 5 | 0xF) ^ byArray[n2]);
            }
            for (n2 = 8; n2 < 16; ++n2) {
                byArray2[n2] = byArray2[n2 - 8];
            }
        } else {
            byArray2 = new byte[8];
            byArray2[0] = (byte)((byArray[byArray.length - 1] << 2 | 0xF) ^ byArray[0]);
            for (int i = 1; i < 8; ++i) {
                byArray2[i] = (byte)((byArray[i - 1] << i % 5 | 0xF) ^ byArray[i]);
            }
        }
        return byArray2;
    }

    private int digest(byte[] byArray) {
        int n;
        this.messageDigest.reset();
        byte[] byArray2 = this.messageDigest.digest(byArray);
        byte[] byArray3 = new byte[2];
        for (n = 0; n < byArray2.length; ++n) {
            int n2 = n % 2;
            byArray3[n2] = (byte)(byArray3[n2] ^ byArray2[n]);
        }
        n = byArray3[0] & 0xFF | byArray3[1] << 8 & 0xFF00;
        return n;
    }

    public SecureRandom getSecureRandom() {
        return new SecureRandom(this.mainIV);
    }

    public CipherProvider createNewCipher(int n) throws StandardException {
        return this.createNewCipher(n, this.mainSecretKey, this.mainIV);
    }

    private CipherProvider createNewCipher(int n, SecretKey secretKey, byte[] byArray) throws StandardException {
        return new JCECipherProvider(n, secretKey, byArray, this.cryptoAlgorithm, this.cryptoProviderShort);
    }

    public void init(boolean bl, Properties properties, boolean bl2) throws StandardException {
        Throwable throwable;
        Object object;
        int n;
        boolean bl3 = false;
        boolean bl4 = bl;
        this.persistentProperties = new Properties();
        String string2 = properties.getProperty(bl2 ? "newEncryptionKey" : "encryptionKey");
        if (string2 != null) {
            bl4 = false;
        }
        this.cryptoProvider = properties.getProperty("encryptionProvider");
        if (this.cryptoProvider != null) {
            bl3 = true;
            n = this.cryptoProvider.lastIndexOf(46);
            this.cryptoProviderShort = n == -1 ? this.cryptoProvider : this.cryptoProvider.substring(n + 1);
        }
        this.cryptoAlgorithm = properties.getProperty("encryptionAlgorithm");
        if (this.cryptoAlgorithm == null) {
            this.cryptoAlgorithm = DEFAULT_ALGORITHM;
        } else {
            bl3 = true;
        }
        if (bl4) {
            this.persistentProperties.put("encryptionAlgorithm", this.cryptoAlgorithm);
        }
        n = this.cryptoAlgorithm.indexOf(47);
        int n2 = this.cryptoAlgorithm.lastIndexOf(47);
        if (n < 0 || n2 < 0 || n == n2) {
            throw StandardException.newException("XBCXH.S", this.cryptoAlgorithm);
        }
        this.cryptoAlgorithmShort = this.cryptoAlgorithm.substring(0, n);
        if (bl3) {
            try {
                object = Class.forName("javax.crypto.ExemptionMechanism");
            }
            catch (Throwable throwable2) {
                throw StandardException.newException("XBCXJ.S");
            }
        }
        if (!bl && properties.getProperty("encryptionKeyLength") != null) {
            object = properties.getProperty("encryptionKeyLength");
            int n3 = ((String)object).lastIndexOf(45);
            this.encodedKeyLength = Integer.parseInt(((String)object).substring(n3 + 1));
            if (n3 != -1) {
                this.keyLengthBits = Integer.parseInt(((String)object).substring(0, n3));
            }
        }
        if (string2 == null && bl) {
            this.keyLengthBits = properties.getProperty("encryptionKeyLength") != null ? Integer.parseInt(properties.getProperty("encryptionKeyLength")) : (this.cryptoAlgorithmShort.equals(DES) ? 56 : (this.cryptoAlgorithmShort.equals(DESede) || this.cryptoAlgorithmShort.equals(TripleDES) ? 168 : 128));
        }
        if (!(((String)(object = this.cryptoAlgorithm.substring(n + 1, n2))).equals("CBC") || ((String)object).equals("CFB") || ((String)object).equals("ECB") || ((String)object).equals("OFB"))) {
            throw StandardException.newException("XBCXI.S", object);
        }
        String string3 = this.cryptoAlgorithm.substring(n2 + 1, this.cryptoAlgorithm.length());
        if (!string3.equals("NoPadding")) {
            throw StandardException.newException("XBCXB.S", string3);
        }
        try {
            byte[] byArray;
            if (this.cryptoProvider != null && Security.getProvider(this.cryptoProviderShort) == null) {
                this.action = 1;
                AccessController.doPrivileged(this);
            }
            this.messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST);
            if (string2 != null) {
                if (properties.getProperty(bl2 ? "newBootPassword" : "bootPassword") != null) {
                    throw StandardException.newException("XBM06.D");
                }
                byArray = StringUtil.fromHexString(string2, 0, string2.length());
                if (byArray == null) {
                    throw StandardException.newException(string2.length() % 2 == 0 ? "XBCXN.S" : "XBCXM.S");
                }
            } else {
                byArray = this.handleBootPassword(bl, properties, bl2);
                if (bl || bl2) {
                    this.persistentProperties.put("encryptionKeyLength", this.keyLengthBits + "-" + byArray.length);
                }
            }
            this.mainSecretKey = this.generateKey(byArray);
            this.mainIV = this.generateIV(byArray);
            if (bl) {
                this.persistentProperties.put("dataEncryption", "true");
                this.persistentProperties.put("data_encrypt_algorithm_version", String.valueOf(1));
                this.persistentProperties.put("log_encrypt_algorithm_version", String.valueOf(1));
            }
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throwable = privilegedActionException.getException();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throwable = noSuchAlgorithmException;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        throw StandardException.newException("XBM0G.D", throwable);
    }

    private byte[] handleBootPassword(boolean bl, Properties properties, boolean bl2) throws StandardException {
        byte[] byArray;
        String string2 = properties.getProperty(bl2 ? "newBootPassword" : "bootPassword");
        if (string2 == null) {
            throw StandardException.newException("XBM06.D");
        }
        byte[] byArray2 = StringUtil.getAsciiBytes(string2);
        if (byArray2.length < 8) {
            String string3 = bl ? "XBM07.D" : "XBM06.D";
            throw StandardException.newException(string3);
        }
        if (bl || bl2) {
            byArray = this.generateUniqueBytes();
            this.persistentProperties.put("encryptedBootPassword", this.saveSecretKey(byArray, byArray2));
        } else {
            byArray = this.getDatabaseSecretKey(properties, byArray2, "XBM06.D");
        }
        return byArray;
    }

    public void saveProperties(Properties properties) {
        Enumeration<Object> enumeration = this.persistentProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            properties.put(string2, this.persistentProperties.get(string2));
        }
        this.persistentProperties = null;
    }

    private byte[] getDatabaseSecretKey(Properties properties, byte[] byArray, String string2) throws StandardException {
        String string3 = properties.getProperty("encryptedBootPassword");
        if (string3 == null) {
            throw StandardException.newException(string2);
        }
        int n = string3.indexOf(45);
        if (n == -1) {
            throw StandardException.newException(string2);
        }
        int n2 = Integer.parseInt(string3.substring(n + 1));
        byte[] byArray2 = this.decryptKey(string3, n, byArray);
        int n3 = this.digest(byArray2);
        if (n3 != n2) {
            throw StandardException.newException(string2);
        }
        if (this.encodedKeyLength != 0) {
            byte[] byArray3 = new byte[this.encodedKeyLength];
            System.arraycopy(byArray2, 0, byArray3, 0, this.encodedKeyLength);
            return byArray3;
        }
        return byArray2;
    }

    private String saveSecretKey(byte[] byArray, byte[] byArray2) throws StandardException {
        EncryptedKeyResult encryptedKeyResult = this.encryptKey(byArray, byArray2);
        String string2 = encryptedKeyResult.hexOutput;
        int n = this.digest(encryptedKeyResult.paddedInputKey);
        return string2.concat("-" + n);
    }

    public String changeBootPassword(String string2, Properties properties, CipherProvider cipherProvider) throws StandardException {
        int n = string2.indexOf(44);
        if (n == -1) {
            throw StandardException.newException("XBCX7.S");
        }
        String string3 = string2.substring(0, n).trim();
        byte[] byArray = StringUtil.getAsciiBytes(string3);
        if (byArray == null || byArray.length < 8) {
            throw StandardException.newException("XBCXA.S");
        }
        String string4 = string2.substring(n + 1).trim();
        byte[] byArray2 = StringUtil.getAsciiBytes(string4);
        if (byArray2 == null || byArray2.length < 8) {
            throw StandardException.newException("XBCX2.S", new Integer(8));
        }
        byte[] byArray3 = this.getDatabaseSecretKey(properties, byArray, "XBCXA.S");
        byte[] byArray4 = this.generateIV(byArray3);
        if (!((JCECipherProvider)cipherProvider).verifyIV(byArray4)) {
            throw StandardException.newException("XBCXA.S");
        }
        String string5 = this.saveSecretKey(byArray3, byArray2);
        properties.put("encryptionKeyLength", this.keyLengthBits + "-" + this.encodedKeyLength);
        return this.saveSecretKey(byArray3, byArray2);
    }

    public final Object run() throws StandardException, InstantiationException, IllegalAccessException {
        try {
            switch (this.action) {
                case 1: {
                    Security.addProvider((Provider)Class.forName(this.cryptoProvider).newInstance());
                    break;
                }
                case 2: {
                    return this.activeFile.getRandomAccessFile(this.activePerms);
                }
                case 3: {
                    return this.activeFile.getInputStream();
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw StandardException.newException("XBCXF.S", this.cryptoProvider);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw StandardException.newException("XBCXL.S", this.cryptoProvider);
        }
        return null;
    }

    public void verifyKey(boolean bl, StorageFactory storageFactory, Properties properties) throws StandardException {
        if (properties.getProperty("encryptionKey") == null) {
            return;
        }
        InputStream inputStream = null;
        StorageRandomAccessFile storageRandomAccessFile = null;
        byte[] byArray = new byte[4096];
        try {
            Object object;
            if (bl) {
                this.getSecureRandom().nextBytes(byArray);
                object = this.getMD5Checksum(byArray);
                CipherProvider cipherProvider = this.createNewCipher(1, this.mainSecretKey, this.mainIV);
                cipherProvider.encrypt(byArray, 0, byArray.length, byArray, 0);
                storageRandomAccessFile = this.privAccessFile(storageFactory, "verifyKey.dat", "rw");
                storageRandomAccessFile.writeInt(((Object)object).length);
                storageRandomAccessFile.write((byte[])object);
                storageRandomAccessFile.write(byArray);
                storageRandomAccessFile.sync();
            } else {
                inputStream = this.privAccessGetInputStream(storageFactory, "verifyKey.dat");
                object = new DataInputStream(inputStream);
                int n = ((DataInputStream)object).readInt();
                byte[] byArray2 = new byte[n];
                ((DataInputStream)object).readFully(byArray2);
                ((DataInputStream)object).readFully(byArray);
                CipherProvider cipherProvider = this.createNewCipher(2, this.mainSecretKey, this.mainIV);
                cipherProvider.decrypt(byArray, 0, byArray.length, byArray, 0);
                byte[] byArray3 = this.getMD5Checksum(byArray);
                if (!MessageDigest.isEqual(byArray2, byArray3)) {
                    throw StandardException.newException("XBCXK.S");
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XBCXL.S", iOException);
        }
        finally {
            try {
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw StandardException.newException("XBCXL.S", iOException);
            }
        }
    }

    private byte[] getMD5Checksum(byte[] byArray) throws StandardException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw StandardException.newException("XBCXH.S", MESSAGE_DIGEST);
        }
    }

    private StorageRandomAccessFile privAccessFile(StorageFactory storageFactory, String string2, String string3) throws IOException {
        StorageFile storageFile;
        this.activeFile = storageFile = storageFactory.newStorageFile("", string2);
        this.action = 2;
        this.activePerms = string3;
        try {
            return (StorageRandomAccessFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private InputStream privAccessGetInputStream(StorageFactory storageFactory, String string2) throws StandardException {
        StorageFile storageFile;
        this.activeFile = storageFile = storageFactory.newStorageFile("", string2);
        this.action = 3;
        try {
            return (InputStream)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    private static final class EncryptedKeyResult {
        public String hexOutput;
        public byte[] paddedInputKey;

        public EncryptedKeyResult(String string2, byte[] byArray) {
            this.hexOutput = string2;
            this.paddedInputKey = byArray;
        }
    }
}

